;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: erase.lisp,v 1.2 1993/06/04 06:21:51 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


;;;
;;; GI-Erase -- Erases a node from the display.
;;;

(defun gi-erase (ns)
  (sneps::do.ns (n ns ns)
    (erase-node (sneps::node-gi-node n))))

(defun erase-node (gi-node)
  (send gi-node :draw-self *window* tv:alu-andca)
  (erase-arcs (send gi-node :arcs)))

(defun erase-arcs (gi-arcs)
  (when (and gi-arcs
	     (listp gi-arcs))
    (dolist (arc gi-arcs t)
      (send arc :draw-self *window* tv:alu-andca))))


;;;*******************************************************************
;;;
;;; GI-DELETE -- Deletes the graphical representation of a node.
;;;

(defun gi-delete (ns)
  (sneps::do.ns (n ns ns)
    ;; Delete each listed node.
    (delete-node (sneps::node-gi-node n)))
  ;; Delete all of those nodes that have become isolated.
  (mapcar #'(lambda (gi-node)
	      (when (null (send gi-node :arcs))
		(delete-node gi-node)))
	  *displayed-nodes*)
  ns)

(defun delete-node (gi-node)
  (send gi-node :draw-self *window* tv:alu-andca)
  (delete-arcs (send gi-node :arcs))
  (setf *displayed-nodes* (remove gi-node *displayed-nodes*))
  (setf (sneps::node-gi-node (send gi-node :the-node)) nil))

(defun delete-arcs (gi-arcs)
  (if (and gi-arcs
	(listp gi-arcs))
      (dolist (arc gi-arcs t)
	(send arc :draw-self *window* tv:alu-andca)
	(setf (send (send arc :node1) :arcs) (remove arc (send (send arc :node1) :arcs)))
	(setf (send (send arc :node2) :arcs) (remove arc (send (send arc :node2) :arcs))))))
