;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: command.lisp,v 1.2 1993/06/04 06:21:46 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


(defun ginseng ()
  "Create Ginseng window and initialize."
  (ginseng::ginseng)
  (scl:send ginseng::*window* :deselect))

(setf (symbol-plist 'ginseng)
      (append (symbol-plist 'ginseng)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro gi-dump (&rest snepsul-exp)
  "Graphically DUMP listed nodes."
  `(let ((ns (sneps::nseval ',snepsul-exp)))
     (ginseng::ginseng)
     (cond ((null ns) nil)
	   (t (ginseng::gi-dump ns)))
     (scl:send ginseng::*window* :deselect)
     ns))

(setf (symbol-plist 'gi-dump)
      (append (symbol-plist 'gi-dump)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro gi-describe (&rest snepsul-exp)
  "Graphically Describe listed nodes."
  `(let ((ns (sneps::nseval ',snepsul-exp)))
     (ginseng::ginseng)
     (cond ((null ns) nil)
	   (t (ginseng::gi-desc ns)))
     (scl:send ginseng::*window* :deselect)
     ns))


(setf (symbol-plist 'gi-describe)
      (append (symbol-plist 'gi-describe)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro gi-erase (&rest snepsul-exp)
  "Erase listed nodes from the diplay, but do not delete the
      graphical representation."
  `(let ((ns (sneps::nseval ',snepsul-exp)))
     (ginseng::ginseng)
     (cond ((null ns) nil)
	   (t (ginseng::gi-erase ns)))
     (scl:send ginseng::*window* :deselect)
     ns))


(setf (symbol-plist 'gi-erase)
      (append (symbol-plist 'gi-erase)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro gi-delete (&rest snepsul-exp)
  "Erase listed nodes and delete their graphical representations."
  `(let ((ns (sneps::nseval ',snepsul-exp)))
     (ginseng::ginseng)
     (cond ((null ns) nil)
	   (t (ginseng::gi-delete ns)))
     (scl:send ginseng::*window* :deselect)
     ns))


(setf (symbol-plist 'gi-delete)
      (append (symbol-plist 'gi-delete)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro gi-reset ()
  "Reset Ginseng to its initial state."
  `(prog1
     (ginseng::reset-all)
     (scl:send ginseng::*window* :deselect)))



(setf (symbol-plist 'gi-reset)
      (append (symbol-plist 'gi-reset)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun gi-pan-on ()
  "Turn on Panning Mode."
  (ginseng::ginseng)
  (ginseng::enable-panning))

(setf (symbol-plist 'gi-pan-on)
      (append (symbol-plist 'gi-pan-on)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun gi-pan-off ()
  "Turn off Panning Mode."
  (ginseng::ginseng)
  (ginseng::disable-panning))

(setf (symbol-plist 'gi-pan-off)
      (append (symbol-plist 'gi-pan-off)
	      '(=COMMAND T =TOPCOMMAND T)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



