;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: pan.lisp,v 1.3 1993/06/04 06:21:39 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun enable-panning ()
  (defmethod (graph-window :override :who-line-documentation-string) nil
    (and (not (send world :pick tv:mouse-x tv:mouse-y))
	 "Bump Mouse with any window EDGE to Pan"))
  (go-nuts-with-panning-dude))


(defun go-nuts-with-panning-dude ()
  (multiple-value-bind (x1 y1 x2 y2) (send window :edges)
    (setq pan-flag t)
    (loop while (eq t pan-flag) do
	  (cond ((< tv:mouse-x (+ x1 5)) 
		 (pan-right))
		((> tv:mouse-x (- x2 5)) 
		 (pan-left))
		((< tv:mouse-y (+ y1 5)) 
		 (pan-down))
		((> tv:mouse-y (- y2 5)) 
		 (pan-up))))))

(defun disable-panning ()
  (setq pan-flag nil)
  (defmethod (graph-window :override :who-line-documentation-string) nil
    (and (not (send world :pick tv:mouse-x tv:mouse-y))
	 "Currently panning OFF")))


(setq main-menu '(("PUT A NODE HERE"
		   :funcall gi-add-to-shownode
		   :documentation "A new node of the users choice
                                   will be put on the screen at this point")
		  ("RESTART with fresh window"
		   :funcall fresh-window
		   :documentation "Start with fresh window")
		  ("REFRESH window"
		   :funcall refresh-window
		   :documentation "Just refresh current window")
		  ("ENABLE Panning"
		   :funcall enable-panning
		   :documentation "Enable Panning of The Network")
		  ("DISABLE Panning"
		   :funcall disable-panning
		   :documentation "Disable Panning of the Network")
		  ("ZOOM IN"
		   :funcall zoom-in
		   :documentation "Zoom into the network, making the nodes larger")
		  ("ZOOM OUT"
		   :funcall zoom-out
		   :documentation "Zoom out of the network, making the nodes smaller")
		  ("SEE ALL the networks"
		   :funcall gi-see-entire-network
		   :documentation "Zoom out until everything drawn is displayed")
		  ("EXIT GINSENG"
		   :funcall bye
		   :documentation "Exit from GINSENG")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;		 ("Change Panning Increment"
;		 :funcall change-panning-increment
;		 :documentation "Change the Amount of the Panning"
;		)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun eval-pan-menu ()
  (declare (special main-menu))
  (tv:menu-choose main-menu "GINSENG MENU" '(:mouse) nil window))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;fresh-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun refresh-window () 
  (pan 0 0))

(defun fresh-window ()
  (setq *already-expanded* nil)
  (setq *node-list* nil)
  (setq *drawn-arcs* nil) 
  (setq *drawn-arcs1* nil) 
  (send window :clear-screen)
  (send window :zoom (/ 1 current-zoom-factor) (/ 1 current-zoom-factor))
  (setq current-zoom-factor 1)
  (send world :set-objects-in-window nil)
  (send world :set-display-list nil)
  (send window :refresh))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;gi-shownode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun gi-shownode ()
  (let ((p (tv:get-line-from-keyboard "Please enter the show node."
				      tv:mouse-sheet 
				      #'readline-or-nil)))
    (setq *node-list* nil)
    (send world :set-display-list nil)
    (setq current-zoom-factor 1)
    (cond ((listp p) (show-node (sneps:nseval (list-of-nodes p))))
	  (t (show-node (sneps:nseval (st.to.n p)))))))

(defun st.to.n (st)
  (sneps:node (read-from-string (zlc:string-append "snepsul:" st))))

(defun list-of-nodes (strings)
  (cond ((null strings) nil)
	(t (cons (st.to.n (car strings)) (list-of-nodes (cdr strings))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;gi-add-to-shownode
;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setq error-menu '((" TRY ANOTHER NODE " :funcall gi-add-to-shownode :documentation "What you typed is not a node. Try another node.")
		   (" EXIT " :funcall nothing :documentation "Try a node later")))

(defun gi-add-to-shownode ()
  (declare (special error-menu))
  (let ((p (tv:get-line-from-keyboard 
	     "ENTER THE NODE TO SHOW"
	     tv:mouse-sheet
	     #'readline-or-nil)))
    (cond ((null (st.to.n p)) (tv:menu-choose error-menu "NOT A NODE" '(:mouse) nil window))
	  (t (alt-show-node (list (st.to.n p) sn-clicked-x sn-clicked-y))))))

(defun alt-show-node (node-list)
  (let* ((new-node-list (remove-dup (remove-coor node-list)))
	 (new-list (add-coordinates-back new-node-list node-list)))
    (cond ((null new-list))
	  (t (show-alt new-list)
	     (DRAW-SCREEN *node-list*)))))

(defun add-coordinates-back (nodes node-list)
  (cond ((null nodes) nil)
	((eq (car nodes) (car node-list))
	 (cons (first node-list) 
	       (cons (second node-list) 
		     (cons (third node-list)
			   (add-coordinates-back (cdr nodes) (cdddr node-list))))))
	(t (add-coordinates-back nodes (cdddr node-list)))))

(defun show-alt (node-list)
  (cond ((null node-list) t)
	((member1 (sneps:node-gi-node (car node-list)) *node-list*)
	 (setf (sneps:node-gi-node (car node-list))
	       (make-instance 'node : label (ntost (car node-list))
			      : the-node (car node-list)
			      : xpos (second node-list)
			      : ypos (third node-list)))
	 (show-alt (cdddr node-list)))
	(t (show-alt (cdr node-list)))))


(defun member1 (node node-list)
  (cond ((null node-list) t)
	((eq node (send (car node-list) :the-node)) nil)
	(t (member1 node (cdr node-list)))))

(defun remove-dup (node-list)
  (cond ((null node-list) nil)
	((member1 (sneps:node-gi-node (car node-list)) *node-list*)
	 (cons (car node-list) 
	       (remove-dup (cdr node-list))))
	(t (remove-dup (cdr node-list)))))


(defun remove-coor (nodes)
  (cond ((null nodes) nil)
	(t (cons (car nodes)
		 (remove-coor (cdddr nodes))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gi-add-to-shownode2 ()
  (let ((ppp (tv:get-line-from-keyboard "Please enter a node or list of nodes to be added."
					tv:mouse-sheet #'readline-or-nil)))
    (cond ((listp ppp) (show-node-22 ppp))
	  (t (show-node-22 (list ppp))))))


(defun show-node-22 (node-list)
  (show-me-the-nodes (remove-dup node-list)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun gi-see-entire-network ()
  (send window :refresh)
  (cond ((equal (zlc:length (send world :objects-in-window))
		(zlc:length (send world :display-list))) t)
	(t (setq current-zoom-factor (* current-zoom-factor zoom-factor))
	   (send window :zoom zoom-factor zoom-factor)
	   (gi-see-entire-network))))

(defun pan-right ()
  (expose-if-not)
  (pan pan-value 0))

(defun pan-left ()
  (expose-if-not)
  (pan (- 0 pan-value) 0))

(defun pan-up ()
  (expose-if-not)
  (pan 0 (- 0 pan-value)))

(defun pan-down ()
  (expose-if-not)
  (pan 0 pan-value))

(defun modify-node-list (x y)
  (send world :set-display-list nil)
  (setq *drawn-arcs* nil)
  (modify-node-list-1 *node-list* x y))

(defun modify-node-list-1 (nl x y)
  (cond ((null nl) nil)
	(t (send (car nl) :set-xpos (+ (send (car nl) :xpos) x))
	   (send (car nl) :set-ypos (+ (send (car nl) :ypos) y))
	   (send (car nl) :modify-list)
	   (modify-node-list-1 (cdr nl) x y))))

(defmethod (node :modify-list) ()
  (cond ((sneps:isbase.n the-node)
	 (setq shapeflavor
	       (send world :insert-rectangle (- xpos radius) (- ypos 10) (* radius 2) 20))
	 (setq textflavor
	       (send world :insert-text (+ 4 (- xpos radius)) (- ypos 8) label))) 
	(t (setq shapeflavor
		 (send world :insert-circle xpos ypos radius))
	   (setq textflavor
		 (send world :insert-text (- (- xpos 3) (// radius 2))
		       (+ 3 (- ypos (// radius 2))) label))))
  (send shapeflavor :draw window)
  (send textflavor :draw window)
  (add-to-oblist shapeflavor self)
  (and label (add-to-oblist textflavor self)))


(defun pan (x y)
  (cond ((null *node-list*) nil)
	(t (modify-node-list x y)
	   (send window :refresh)
	   (draw-screen *node-list*))))


(defun bye ()
  (setq pan-flag nil)
  (send window :deactivate)
  (setq window nil))





















