;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPSUL; Base:10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: utils.lisp,v 1.2 1993/06/04 06:21:24 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snepsul)


;;; Definitions of Primitive Arc/Info Actions

(defvar *just-fake-it* nil
  "If T actions are not actually sent to ARC/INFO.")

(defun just-do-it (command &optional (print-result nil))
  "Takes an AML COMMAND (a string) and executes it, i.e., sends it to
ARC/INFO unless *just-fake-it* is T."
  (format t "~&~% Now  doing: ~a~%" command)
  (unless *just-fake-it*
    (execute-command command)
    (when print-result (print-result))))

(defun coerce-node (node type)
  "Coerces NODE into TYPE."
  (case type
    (:node node)
    (:symbol (node-na node))
    (:string (format nil "~a" node))
    (t (format nil "~a" node))))

(defmacro action (action-node &optional (return-type :node))
  "Returns the lexical descripton (a base node) of the action of ACTION-NODE
and converts it to RETURN-TYPE."
  `(coerce-node (choose.ns (pathfrom '(action lex) (node ,action-node)))
                ,return-type))

(defmacro object1 (action-node &optional (return-type :node))
  "Returns the lexical descripton (a base node) of object1 of ACTION-NODE
and converts it to RETURN-TYPE."
  `(coerce-node (choose.ns (pathfrom '(object1 lex) (node ,action-node)))
                ,return-type))

(defmacro object2 (action-node &optional (return-type :node))
  "See object1."
  `(coerce-node (choose.ns (pathfrom '(object2 lex) (node ,action-node)))
                ,return-type))

(defmacro object3 (action-node &optional (return-type :node))
  "See object1."
  `(coerce-node (choose.ns (pathfrom '(object3 lex) (node ,action-node)))
                ,return-type))



(defun declare-primactions ()
  "Takes all the primitive actions that have not been declared as such in
a SNePS member/class case frame and generates such a case frame for them."
  (let (primactions-not-yet-defined)
    (maphash #'(lambda (k v)
		 (let ((pa (format nil "~(~a~)" k)))
		   (unless (eval `(find member (build lex ,pa)
				   class (build lex "primitive")))
		     (lisp:push pa primactions-not-yet-defined))))
	     *primitive-action-functions*)
    (eval `(assert member ,(mapcar #'(lambda (pa) `(build lex ,pa))
			    primactions-not-yet-defined)
	    class (build lex "primitive")))
    primactions-not-yet-defined))
