;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPSUL; Base:10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: graphics.lisp,v 1.3 1993/07/08 10:08:18 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snepsul)


;(use-package 'kr)
; Create a window called BLOCKSWINDOW
(kr:create-instance 'blockswindow opal:window
		 (:left 10) (:top 10)
                 (:width 1000) (:height 400)
		 (:title "Blocksworld")
		 (:icon-title "Blocksworld"))
;
; All objects in the window will be a part of the BLOCKSWORLD aggregate
;
(kr:create-instance 'blocksworld opal:aggregate)
;
(kr:s-value blockswindow :aggregate blocksworld)
;
(defparameter bigfnt (kr:create-instance NIL opal:font
				      (:size :very-large)
			   	      (:family :serif)))
; Read the bit map of the arm
;
(opal:add-component blocksworld
		    (kr:create-instance 'arm opal:bitmap
				     (:left 50) (:top 30)
;				     (:fast-redraw-p t) (:draw-function :xor)
				     (:image (opal:read-image "sneps:demo;snactor;blocksworld;arm.bm"))))
(opal:add-component blocksworld
		    (kr:create-instance 'signature opal:bitmap
				     (:left 930) (:top 300)
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:image (opal:read-image "sneps:demo;snactor;blocksworld;dk.bm"))))
;
; Create the left grasper of the arm (the part that slides and grasps)
;
(opal:add-component blocksworld
		    (kr:create-instance 'arm-stand opal:rectangle
				     (:left 0) (:top 5)
				     (:width 1000) (:height 20)
			;	     (:fast-redraw-p t) (:draw-function :xor)
				     (:filling-style opal:black-fill)))
 (opal:add-component blocksworld
		      (kr:create-instance 'line-1 opal:line
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:x1 400) (:y1 10)
				       (:x2 400) (:y2 30)))
 (opal:add-component blocksworld
		      (kr:create-instance 'line-2 opal:line
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:x1 430) (:y1 10)
				       (:x2 430) (:y2 30)))
(kr:s-value line-1 :x2 (kr:o-formula (lisp:+ 20 (kr:gv arm :left))))
(kr:s-value line-1 :y2 (kr:o-formula (kr:gv arm :top)))
(kr:s-value line-1 :x1 (kr:o-formula (lisp:+ 20 (kr:gv arm :left))))
(kr:s-value line-2 :x2 (kr:o-formula (lisp:+ 60 (kr:gv arm :left))))
(kr:s-value line-2 :y2 (kr:o-formula (kr:gv arm :top)))
(kr:s-value line-2 :x1 (kr:o-formula (lisp:+ 60 (kr:gv arm :left))))
;
(opal:add-component blocksworld
		    (kr:create-instance 'left-grasper opal:rectangle
				     (:left ) (:top )
				     (:width 10) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:filling-style opal:dark-gray-fill)))
;
; Create the right grasper of the arm (the part that slides and grasps)
;
(opal:add-component blocksworld
		    (kr:create-instance 'right-grasper opal:rectangle
				     (:left ) (:top )
				     (:width 10) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:filling-style opal:dark-gray-fill)))
;
; This slot governs the positioning of the graspers (up or down)
;
(kr:s-value arm :grasping nil)
;
; Hook up the graspers to the arm
;
(kr:s-value left-grasper :left (kr:o-formula (lisp:+ 4 (kr:gv arm :left))))
(kr:s-value right-grasper :left (kr:o-formula (lisp:+ 66 (kr:gv arm :left))))
(kr:s-value left-grasper :top (kr:o-formula
			    (if (kr:gv arm :grasping)
				(lisp:+ 80 (kr:gv arm :top))
				(lisp:+ 60 (kr:gv arm :top)))))
(kr:s-value right-grasper :top (kr:o-formula
			     (if (kr:gv arm :grasping)
				 (lisp:+ 80 (kr:gv arm :top))
				 (lisp:+ 60 (kr:gv arm :top)))))
;
; create the table
;
 (opal:add-component blocksworld 
		      (kr:create-instance 'table opal:rectangle
				       (:left 50) (:top 300)
				       (:width 900) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:filling-style opal:light-gray-fill)))
(opal:add-component blocksworld 
		      (kr:create-instance 'leg1 opal:rectangle
				       (:left 125) (:top 350)
				       (:width 25) (:height 50)
				       (:filling-style opal:light-gray-fill)))
(opal:add-component blocksworld 
		      (kr:create-instance 'leg2 opal:rectangle
				       (:left 850) (:top 350)
				       (:width 25) (:height 50)
				       (:filling-style opal:light-gray-fill)))

;
; create the blocks
;
(opal:add-component blocksworld 
		      (kr:create-instance 'a opal:rectangle
				       (:left 200) (:top 250)
				       (:width 50) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:filling-style opal:white-fill)))
(opal:add-component blocksworld
		    (kr:create-instance 'a-text opal:text
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:font bigfnt) (:string "A")))
(kr:s-value a-text :left (kr:o-formula (lisp:+ (kr:gv a :left) 18)))
(kr:s-value a-text :top (kr:o-formula (lisp:+ (kr:gv a :top) 15)))

(opal:add-component blocksworld 
		      (kr:create-instance 'b opal:rectangle
				       (:left 450) (:top 250)
				       (:width 50) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:filling-style opal:white-fill)))
(opal:add-component blocksworld
		    (kr:create-instance 'b-text opal:text
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:font bigfnt) (:string "B")))
(kr:s-value b-text :left (kr:o-formula (lisp:+ (kr:gv b :left) 18)))
(kr:s-value b-text :top (kr:o-formula (lisp:+ (kr:gv b :top) 15)))

(opal:add-component blocksworld 
		      (kr:create-instance 'c opal:rectangle
				       (:left 700) (:top 250)
				       (:width 50) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:filling-style opal:white-fill)))
(opal:add-component blocksworld
		    (kr:create-instance 'c-text opal:text
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:font bigfnt) (:string "C")))
(kr:s-value c-text :left (kr:o-formula (lisp:+ (kr:gv c :left) 18)))
(kr:s-value c-text :top (kr:o-formula (lisp:+ (kr:gv c :top) 15)))
(opal:add-component blocksworld 
		      (kr:create-instance 'd opal:rectangle
				       (:left -150) (:top 150)
				       (:width 50) (:height 50)
				     (:fast-redraw-p t) (:draw-function :xor)
				       (:filling-style opal:white-fill)))
(opal:add-component blocksworld
		    (kr:create-instance 'd-text opal:text
				     (:fast-redraw-p t) (:draw-function :xor)
				     (:font bigfnt) (:string "D")))
(kr:s-value d-text :left (kr:o-formula (lisp:+ (kr:gv d :left) 18)))
(kr:s-value d-text :top (kr:o-formula (lisp:+ (kr:gv d :top) 15)))

(kr:s-value arm :home-top 30)
(kr:s-value arm :home-left 50)
(kr:s-value a :home-left 200)
(kr:s-value a :home-top 250)
(kr:s-value b :home-left 450)
(kr:s-value b :home-top 250)
(kr:s-value c :home-left 700)
(kr:s-value c :home-top 250)
(kr:s-value d :home-left 100)
(kr:s-value d :home-top 250)
;
; Display the blocksworld, finally!
;
(opal:update blockswindow)
;
; animation functions
;
(defun translate-x (arm distance dir)
    (dotimes (n (floor distance 5) t)
      (kr:s-value arm :left (lisp:+ (lisp:* 5 dir)
			    (kr:g-value arm :left)))
      (opal:update blockswindow)
;      (sleep sleep-time)
      ))
;
;
 (defun translate-y (arm distance dir)
    (dotimes (n (floor distance 5) t)
      (kr:s-value arm :top (lisp:+ (lisp:* 5 dir)
			    (kr:g-value arm :top)))
      (opal:update blockswindow)
;      (sleep sleep-time)
      ))
;
(defun move-arm (arm newx newy)     ; newx=newleft newy=newtop
    (let* ((oldx (kr:g-value arm :left))
	   (oldy (kr:g-value arm :top))
	   (x-distance (lisp:- newx oldx))
	   (y-distance (lisp:- newy oldy))
	   (x-dir (if (minusp x-distance) -1 1))
	   (y-dir (if (minusp y-distance) -1 1)))
      (cond ((minusp y-dir)
	     (translate-y arm (abs y-distance) y-dir)
	     (kr:s-value arm :top newy)
	     (translate-x arm (abs x-distance) x-dir)
	     (kr:s-value arm :left newx))
	    (t (translate-x arm (abs x-distance) x-dir)
	       (kr:s-value arm :left newx)
	       (translate-y arm (abs y-distance) y-dir)
	       (kr:s-value arm :top newy)))
      (opal:update blockswindow)))
;
(defun grasp ()
    (kr:s-value arm :grasping t)
    (opal:update blockswindow))
;
(defun ungrasp ()
    (kr:s-value arm :grasping nil)
    (opal:update blockswindow))
;

(defun bw-putdown (block object)
    (let ((new-left (if (equal object table)
			(kr:g-value block :home-left)
			(kr:g-value object :left)))
	  (new-top (if (equal object table)
		       (kr:g-value block :home-top)
		       (lisp:- (kr:g-value object :top) 50))))
      (move-arm arm (lisp:- new-left 15) (lisp:- new-top 101))
      (ungrasp)
      (kr:s-value block :left (kr:o-formula new-left))
      (kr:s-value block :top (kr:o-formula new-top))
      (move-arm arm (kr:g-value arm :left) (kr:g-value arm :home-top))))
;
(defun bw-pickup (block)
    (move-arm arm (lisp:- (kr:g-value block :left) 15)
	          (lisp:- (kr:g-value block :top) 101))
    (kr:s-value block :left  (kr:o-formula (lisp:+ (kr:gv arm :left) 15)))
    (kr:s-value block :top (kr:o-formula (lisp:+ (kr:gv arm :top) 101)))
    (kr:s-value arm :grasping t)
    (kr:s-value arm :grasped-block block)
    (opal:update blockswindow)
    (move-arm arm (kr:g-value arm :left) (kr:g-value arm :home-top)))
;


