;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPSUL; Base:10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: blocks.lisp,v 1.2 1993/06/04 06:21:15 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snepsul)


;;; Definitions of Primitive Blocks World Actions

(define-primaction pickup (n)
  (format t "~&Now  doing: Pickup ~A.~%"
	  (setq block (choose.ns (pathfrom '(object1 lex) (node n)))))
	  (bw-pickup (eval (node-na block)))
	  )

;(define-primaction putdown (n)
;  (format t "~&Now doing: PUTDOWN ~A on table.~%"
;	  (setq block (choose.ns (pathfrom '(object1 lex) n))))
;	  (bw-putdown (eval (node-na block))))

(define-primaction put (n)
  (format t "~&Now doing: Put ~A on ~A.~%"
	  (setq block1 (choose.ns (pathfrom '(object1 lex) n)))
	  (if (not (setq block2 (choose.ns (pathfrom '(object2 lex) n))))
	      "table"
	      block2))
 	  (if (sneps:isbase.n (choose.ns (pathfrom '(object2) n)))
	      (bw-putdown (eval (node-na block1)) table)
	      (bw-putdown (eval (node-na block1)) (eval (node-na block2)))))

(define-primaction unstack (n)
  (format t "~&Now doing:  UNSTACK ~A from ~A.~%"
	  (setq block1 (choose.ns (pathfrom '(object1 lex) n)))
	  (setq block2 (choose.ns (pathfrom '(object2 lex) n))))
	  (bw-unstack (eval (node-na block1)) (eval (node-na block2))))
