;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: xnode.lisp,v 1.2 1993/06/04 06:20:46 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


(defvar *fillstyle-update-wait-function*
  #'(lambda ()(sleep 1.2))
  "Function to be called before the fillstyle of an XGinseng node gets
updated")

;; An access function:
(defun set-fillstyle.n (sneps-node activation)
  (let ((gi-node (intern (stringify.n sneps-node) 'xginseng)))
    ;; check whether we have an XGinseng node for this Sneps node
    (when (boundp gi-node)
      (setq gi-node (eval gi-node))
      (funcall *fillstyle-update-wait-function*)
      (case activation
	(:initiated
	 (s-value (g-value gi-node :frame)
		  :filling-style opal:light-gray-fill))
	(:executing
	 (s-value (g-value gi-node :frame)
		  :filling-style opal:dark-gray-fill))
	(t (s-value (g-value gi-node :frame)
		    :filling-style opal:white-fill)))
      (opal:update display-window)
      )))
