#! /bin/csh
#
# This is the OLD install-sneps script. I just kept it because it contains
# fancy sed statements that perform more or less the same as what is
# done by slinkdir.c
#
#
# Script for installation and compilation of SNePS
# Depends on the following enviroment variables:
#
# $SNEPSTEMP   a link to the temporary SNePS tree for compilation
# $SNEPSDIST   a link to the SNePS distribution tree
# $CLISP         the command that starts common lisp
#
# The basic idea is to have two actual directories A and B that are pointed
# two by two symbolic links DIST and TEMP. Suppose DIST points to A and TEMP
# to B. Then a new SNePS release is copied into TEMP (i.e. B), then the
# actual pathname to which TEMP points is figured out (B in this case), then
# SNePS gets compiled with the actual B pathname set (important so the
# compiled files will have the right source pathnames), and after successful
# compilation the two links will be swapped, i.e., now TEMP is pointing to A
# and DIST to B and all the source file pathnames will still work (swapping
# the actual directory names A and B would mess things up).

# First we figure out various components and actual referents of the
# two symbolic links. Both have to be absolute pathnames!!
set temp_link_base = `basename $SNEPSTEMP`
echo temp_link_base $temp_link_base
# _link_root is used to strip off /tmp_mnt/.../ portions if they exist
set temp_link_root = `echo $SNEPSTEMP | sed -e 's,\(/[^/]*\).*,\1,p'`
echo temp_link_root $temp_link_root
set temp_link_parent = `echo $SNEPSTEMP | sed -e 's,[^/]*$,,p'`
echo temp_link_parent $temp_link_parent
set temp_link_actual = `ls -l $temp_link_parent | fgrep $temp_link_base | \\
                        sed -e "s,.*\($temp_link_root.*\),\1,p"`
echo temp_link_actual $temp_link_actual

set dist_link_base = `basename $SNEPSDIST`
echo dist_link_base $dist_link_base
set dist_link_root = `echo $SNEPSDIST | sed -e 's,\(/[^/]*\).*,\1,p'`
echo dist_link_root $dist_link_root
set dist_link_parent = `echo $SNEPSDIST | sed -e 's,[^/]*$,,p'`
echo dist_link_parent $dist_link_parent
set dist_link_actual = `ls -l $dist_link_parent | fgrep $dist_link_base | \\
                        sed -e "s,.*\($dist_link_root.*\),\1,p"`
echo dist_link_actual $dist_link_actual

set compilation_log = $temp_link_actual/Logs/compilation.log 

exit

cd $temp_link_actual

echo Starting compilation of SNePS

$CLISP <<EOF >& $compilation_log
 (setq *sneps-directory* "$temp_link_actual")
 (setq *sneps-noquery* nil)
 (load "myload")
 ;; Recompile everything
 c
 ;; Load and compile SNACTor
 (load "sneps:snactor")
 ;; Check whether it works
 (sneps)
 (lisp)
EOF

echo Updating protection bits...
chmod -R u=rwX *
chmod -R go=rX *

if (`fgrep -c "End of SNePS" $compilation_log` == 1) then
   # All went well, swap the links
   "rm" -f $SNEPSDIST
   ln -s $temp_link_actual $SNEPSDIST
   "rm" -f $SNEPSTEMP
   ln -s $dist_link_actual $SNEPSTEMP
   echo . | mail -s "SNePS installed on $HOST" hans@cs.buffalo.edu
else
   # it bombed somewhere
   echo . | mail -s "SNePS installation on $HOST bombed" \
                    hans@cs.buffalo.edu
endif

cd $HOME/bin
