;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: USER; Base: 10 -*-

;; Load this file to compile SNePS in various Lisps. Call
;; compile-sneps to do the actual compilation, e.g., 
;; (compile-sneps "Sneps-B") if the Temp link currently points
;; to Sneps-B.

(in-package :user)

(defvar *sneps-parent-dir* "hadar:/u6/rstaff/snerg/src/Sneps21/All-Lisps")

(defvar *sneps-garnet-directory* "/util/lisp/garnet")

#+allegro-v4.1 (setq excl::*enable-package-locked-errors* nil)

;; Use production mode compiler if available:
(proclaim '(optimize (safety 0) (speed 3) (space 0) (compilation-speed 0)))

;; Deal with Explorer/Telnet stack size limitations:
#+explorer
(when (equal (SYS:SG-NAME *current-stack-group*) "Telnet Server")
  (setf (SYS:SG-REGULAR-PDL-LIMIT *current-stack-group*) 64000))
  
(defun compile-sneps (temp-actual-name
		      &key
		      (parent *sneps-parent-dir*)
		      (lisp #+allegro   "cl"
			    #+lucid     "scl"
			    #+explorer  "ticl"
			    #+symbolics "symcl")
		      (dribble-on t)
		      )
  (let ((dribble-stream *terminal-io*))
    (unwind-protect
	 (progn 
	   (when dribble-on
	     (setq dribble-stream
		   ;; Use a stream that can also deal with input operations
		   ;; because Explorers like to send clear-input messages.
		   (make-two-way-stream
		    *terminal-io*
		    (open (format nil "~a/~a/Logs/~a-compilation.log"
				  parent temp-actual-name lisp)
			  :direction :output :if-exists :supersede))))
	   (let* ((*terminal-io* dribble-stream)
		  (*standard-output* dribble-stream)
		  (*error-output* dribble-stream)
		  (*trace-output* dribble-stream)
		  (*query-io* dribble-stream)
		  (*debug-io* dribble-stream)
		  #+(or explorer symbolics)
		  (*features* (cons :lm-unix *features*))
		  (*load-verbose* t)
		  #+lucid
		  (*redefinition-action* nil)
		  #+(or explorer symbolics)
		  (si:inhibit-fdefine-warnings t)
		  )
	     (setq *sneps-directory*
		   (format nil "~a/~a" parent temp-actual-name))
	     (setq *sneps-noquery* t)
	     (setq *sneps-make-option* :recompile)
	     #+(or explorer symbolics)
	     (progn
	       ;; make sure these files are compiled before we start (otherwise
	       ;; TIs have stack-overflow problems in TELNET connections):
	       (unless (find-package :LOGICAL-PATHNAME)
		 (make-package :LOGICAL-PATHNAME :nicknames '(:LP)))
	       (compile-file
		(format nil "~a/logical-pathnames.lisp" *sneps-directory*))
	       (compile-file
		(format nil "~a/system-utils.lisp" *sneps-directory*))
	       )
	     (load (format nil "~a/load-sneps" *sneps-directory*))
	     ;; Compile various optional stuff:
	     (load "sneps:snactor")
	     (load "sneps:xginseng;load-xginseng")
	     (load "sneps:demo;snactor;blocksworld;load-blocks-snactor")
	     (load "sneps:demo;snactor;arcinfo;load-arc-snactor")
	     (load "sneps:demo;activation;load-activation")
	     ;; Check whether it works:
	     (let* ((*terminal-io*
		    (make-two-way-stream
		     (make-string-input-stream
		      (format nil "(demo \"sneps:demo;snactor;arcinfo;arcdemo.sneps\")~%~
                                   y~%y~%y~%~
                                   (lisp)~%"))
		     *terminal-io*))
		    (*standard-input* *terminal-io*)
		    (*standard-output* *terminal-io*)
		    (*query-io* *terminal-io*))
	       ;; Print result so it will also
	       ;; show up on the dribble file
	       (print (sneps)))
	     ))
      ;; Cleanup forms
      (and dribble-on
	   (streamp dribble-stream)
	   (close dribble-stream)))
    ))

