/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
%token name_tok
%token number_tok

%token abstract_tok
%token class_tok
%token definite_tok
%token enum_tok
%token extern_tok
%token friend_tok
%token local_tok
%token operator_tok
%token private_tok
%token protected_tok
%token public_tok
%token schema_tok
%token set_tok
%token static_tok
%token typedef_tok
%token union_tok
%token with_tok

%token l_abr_tok
%token r_abr_tok
%token l_br_tok
%token r_br_tok
%token l_brc_tok
%token r_brc_tok
%token l_par_tok
%token r_par_tok

%token ampersand_tok
%token ampersand_assign_tok
%token and_tok
%token assign_tok
%token bar_tok
%token bar_assign_tok
%token circumflex_tok
%token circumflex_assign_tok
%token colon_tok
%token comma_tok
%token equal_tok
%token exclam_tok
%token greater_equal_tok
%token less_equal_tok
%token minus_tok
%token minus_assign_tok
%token not_equal_tok
%token or_tok
%token percent_tok
%token percent_assign_tok
%token plus_tok
%token plus_assign_tok
%token rshift_assign_tok
%token lshift_assign_tok
%token slash_tok
%token slash_assign_tok
%token star_tok
%token star_assign_tok
%token semicolon_tok

%type <imp>	imports
%type <imp>	import_names
%type <s>	name_tok
%type <s>	name_tok_or_keyword
%type <str>	name
%type <str>	name1
%type <str_l>	names
%type <etd>	enumeration_declaration
%type <ctd>	class_declaration
%type <sc_l>	super_classes
%type <utd>	union_declaration
%type <ttd>	typedef_declaration
%type <xtd>	extern_declaration
%type <i>	extern_size
%type <gp_l>	gen_params
%type <gp_l>	gen_params_1
%type <gp>	gen_param
%type <sc>	super_class
%type <mk>	method_kind_spec
%type <md>	function_method
%type <str>	function_name
%type <str>	operator
%type <str>	operator_string
%type <par_l>	opt_parameters
%type <par_l>	parameters
%type <par_l>	parameters_1
%type <par>	parameter
%type <exp>	default_expr
%type <td>	super_class_type_name
%type <td>	type_name
%type <sc_l>	super_class_list
%type <tp_l>	types
%type <td>	type_name1
%type <td_l>	type_names
%type <exp>	expr
%type <exp_l>	exprs
%type <exp_l>	exprs1
%type <i>	number_tok
%type <ie>	number
%type <id>	identifier
%type <td>	generic_instantiation
%type <td>	super_class_generic_instantiation
%type <b>       reference

%{

#define OBST_IMP_STRINGOP
#define OBST_IMP_MALLOC
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"
#include "smg.h"
#include "cfe_err.h"
#include "mta_use.h"
#include "cfe.h"

typedef union {
	  sos_Bool				b;
	  sos_Int				i;
	  sos_Cstring				s;
          sos_Import_List			imp;
          sos_String				str;
          sos_String_List			str_l;
          sos_Enum_type				etd;
          sos_Class_type			ctd;
          sos_Gen_param				gp;
          sos_Gen_param_List			gp_l;
          sos_Param				par;
          sos_Param_List			par_l;
	  sos_Method_kind			mk;
          sos_Method_List			md_l;
          sos_Method				md;
          sos_Union_type			utd;
          sos_Typedef_type			ttd;
          sos_Extern_type			xtd;
	  sos_Type_descr			td;
	  sos_Type_descr_List			td_l;
	  sos_Type_List				tp_l;
	  sos_Super_class_List			sc_l;
	  sos_Super_class			sc;
          sos_Expr				exp;
          sos_Int_expr				ie;
          sos_Identifier			id;
          sos_Expr_List				exp_l;
        } _YYSTYPE;
#define YYSTYPE _YYSTYPE

static sos_Type_descr 	   cfe_fct_or_comp_type;
static sos_Bool		   cfe_is_full_type,
                           cfe_class_is_abstract,
	                   cfe_method_is_abstract,
		           cfe_method_is_definite, 
		           cfe_method_is_local, 
		           cfe_method_is_operator,
                           cfe_method_is_static, 
                           cfe_method_is_value,
			   cfe_super_classes_ok;
static sos_Method_kind 	   cfe_method_kind,
                           cfe_set_method_kind;
static sos_Int 		   cfe_component_offset;
static sos_Type_descr_List cfe_gen_insts;

sos_Class_type cfe_ct;

#include "cfe_lex.h"

static void yyerror (err_msg s) {cfe_error (err_USE, s);}
static void yyecho () {if (cfe_echo_flag) ECHO;}

%}

%%

schema_module
   : {  cfe_cnt       = sos_Container::create ();
	cfe_ct        = sos_Class_type::make (NO_OBJECT);
	cfe_schema    = sos_Schema_module::create (cfe_cnt);
	cfe_gen_insts = sos_Type_descr_List::create (TEMP_CONTAINER);
     }
     imports schema_tok name
     {  cfe_schema.set_imports ($2);
        cfe_schema.set_name ($4);
        cfe_init ($4, $2);
     }
     l_brc_tok type_declarations r_brc_tok opt_semicolon
     {  cfe_complete_forward_insts ();
	cfe_check_schema ();
        cfe_check_generic_instantiations (cfe_gen_insts);
        cfe_finalize();
     }
   | error
   ;

imports
   : extern_import
     {  $$ = sos_Import_List::create (cfe_cnt); }
   | with_tok import_names opt_semicolon extern_import
     {  $$ = $2;
	cfe_complete_imports ($$);
     }
   ;

import_names
   : name1
     {  $$ = sos_Import_List::create (cfe_cnt);
        cfe_import_module ($$, $1);
     }
   | import_names comma_tok name1
     {  $$ = $1;
        cfe_import_module ($$, $3);
     }
   ;

extern_import
   : {  cfe_schema.set_has_external_import (FALSE);  }
   | with_tok extern_tok semicolon_tok
     {  cfe_schema.set_has_external_import (TRUE);  }
   ;

opt_semicolon
   :
   | semicolon_tok
   ;

type_declarations
   :
   | type_declarations type_declaration
   | error
   ;

type_declaration
   : enumeration_declaration				{}
   | class_declaration					{}
   | union_declaration					{}
   | typedef_declaration 	       semicolon_tok	{}
   | extern_declaration 	       semicolon_tok	{}
   | typedef_tok generic_instantiation semicolon_tok	{}
   ;

enumeration_declaration
   : enum_tok name l_brc_tok names r_brc_tok opt_semicolon
     {  cfe_check_type ($2);
        /* Use temporary variable e instead of $$ [matsj] */
        sos_Enum_type e;
        e = sos_Enum_type::create (cfe_cnt);
        e.set_name($2);
        e.set_object_size (cfe_enum_size ($4.card()));
        e.set_literals($4);

        cfe_type_tab.insert ($2, e);
        cfe_types.append (e);
        $$ = e;
     }
   ;

class_declaration
   : class_kind class_tok name
     {
	cfe_ct = cfe_make_class_type($3, cfe_type_tab, cfe_types);
        cfe_ct.set_is_abstract (cfe_class_is_abstract);
	cfe_type_tab.insert ($3, cfe_ct);
	cfe_super_classes_ok = TRUE;
     }
     gen_params
     {  cfe_set_generic_stuff(cfe_ct, $5);
     }
     opt_parameters
     {  cfe_ct.set_create_params ($7);
     }
     super_classes
     {  cfe_ct.set_super_classes ($9);
        cfe_set_super_closure (cfe_ct);
     }
     l_brc_tok
     {  cfe_ct.set_friends (sos_Type_List::make (NO_OBJECT));
	cfe_ct.set_components (sos_Comp_descr_List::create(cfe_cnt));
	cfe_ct.set_has_init_comps (FALSE);
        cfe_init_methods (cfe_ct);
        cfe_component_offset = 0;
     }
     method_declarations r_brc_tok opt_semicolon
     {  $$ = cfe_ct;
        cfe_set_offsets_and_size (cfe_ct, cfe_component_offset);
        cfe_build_methodtable (cfe_ct);
        cfe_complete_methods (cfe_ct);
	cfe_complete_components (cfe_ct);
	cfe_types.append ($$);
	cfe_create_universal_inst (cfe_ct);
	cfe_ct = sos_Class_type::make (NO_OBJECT);
     }
   ;

class_kind
   : { cfe_class_is_abstract = FALSE; }
   | abstract_tok
     { cfe_class_is_abstract = TRUE; }
   ;

gen_params
   : {  $$ = sos_Gen_param_List::make (NO_OBJECT); }
   | l_abr_tok gen_params_1 r_abr_tok
     { if (cfe_is_full_type)
	   cfe_error (err_USE, err_CFE_FULL_GENERIC);
        $$ = $2;
     }
   ;

gen_params_1
   : gen_param
     {  $$ = sos_Gen_param_List::create (cfe_cnt, FALSE);
	$$.append ($1);
     }
   | gen_params_1 comma_tok gen_param
     {  if (cfe_lookup_gen_params ($3.make_type().get_name(), $1) != NO_OBJECT)
           cfe_error (err_USE, err_CFE_AMBIGUOUS_GEN_PARAMS);
        $1.append ($3);
        $$ = $1;
     }
   ;

gen_param
   : name
     {  $$ = sos_Gen_param::create (cfe_cnt);
        $$.set_name ($1);
        $$.set_super_type (sos_Type_descr::make(NO_OBJECT));
     }
   | name colon_tok type_name
     {  $$ = sos_Gen_param::create (cfe_cnt);
        $$.set_name ($1);
        $$.set_super_type ($3);
     }
   ;

opt_parameters
   : {  $$ = sos_Param_List::make (NO_OBJECT); }
   | parameters
   ;

super_classes
   : {  $$ = sos_Super_class_List::create (cfe_cnt, TRUE);
        cfe_enter_object_as_sc (cfe_ct, $$); // if cfe_ct not sos_Object, then
			                // enter sos_Object as only superclass
     }
   | colon_tok super_class_list
     {  cfe_check_super_classes (cfe_ct, $2);
	$$ = $2;
     }
   ;

super_class_list
   : super_class
     {  $$ = sos_Super_class_List::create (cfe_cnt, TRUE);
	$$.append ($1);
     }
   | super_class_list comma_tok super_class
     {  // check for multiple occurrence: generic instantiations are accounted
	// for correctly, since equal generic instantiations in the sc-list
	// become the same object by use of cfe_get_instantiation.
	if (super_class_in_list ($$, $3.get_super_class()) != NO_OBJECT)
	   cfe_error(err_USE, err_CFE_MULTIPLE_SUPERCLASS,
		     $3.make_type().get_name());
	$1.append ($3);
	$$ = $1;
     }
   ;

super_class
   : super_class_type_name
     {
	sos_Super_class sc = sos_Super_class::create (cfe_cnt);
	sc.set_super_class ($1);
	sc.set_offset (0);
	sc.set_create_params(sos_Expr_List::make(NO_OBJECT));
	sc.set_is_direct (TRUE);
	$$ = sc;
     }
   | super_class_type_name l_par_tok exprs r_par_tok
     {  sos_Super_class sc = sos_Super_class::create (cfe_cnt);
	sc.set_super_class ($1);
	sc.set_create_params ($3);
	sc.set_is_direct (TRUE);
	$$ = sc;
     }
   ;

method_declarations
   : {  cfe_method_kind     = sos_PRIVATE;
	cfe_set_method_kind = sos_PRIVATE;
     }
   | method_declarations
     {  cfe_method_is_abstract = FALSE;
	cfe_method_is_definite = FALSE;
	cfe_method_is_local    = FALSE;
	cfe_method_is_operator = FALSE;
	cfe_method_is_static   = FALSE;
	cfe_method_is_value    = FALSE;
     }
     method_declaration
  ;

method_declaration
   : fct_or_comp_type function_method
   | fct_or_comp_type comp_methods
   | friend
   | method_kind_spec
     {  cfe_method_kind = $1; }
     set_method_kind_spec colon_tok
   | error
   ;

/* The following nonterminal covers both functions and components because
   dividing it into function and component part causes the grammar to be
   no longer LALR(1) (the reason is that both method types use definite
   and static type. */

fct_or_comp_type
   : fct_or_comp_kind type_name
     {  cfe_fct_or_comp_type = $2; }
   ;

fct_or_comp_kind
   : abstract_tok
     {  cfe_method_is_abstract = TRUE; }
   | definite_tok local_or_value_spec
     {  cfe_method_is_definite = TRUE; }
   | static_tok
     {  cfe_method_is_static = TRUE; }
   | local_or_value_spec
   ;

local_or_value_spec 
   :
   | local_tok
     {  cfe_method_is_local = TRUE; }
   | exclam_tok
     {  cfe_method_is_value = TRUE; }
   ;

method_kind_spec
   : private_tok
     {  $$ = sos_PRIVATE; }
   | protected_tok
     {  $$ = sos_PROTECTED; }
   | public_tok
     {  $$ = sos_PUBLIC; }
   ;

set_method_kind_spec
   : {  cfe_set_method_kind = cfe_method_kind; }
   | comma_tok method_kind_spec set_tok
     {  cfe_set_method_kind = $2; }
   ;

function_method
   : function_name parameters semicolon_tok
     {
	if (cfe_method_is_local)
	   cfe_error(err_USE, err_CFE_NO_LOCAL_FUNCS);
	if (cfe_method_is_value)
	   cfe_error(err_USE, err_CFE_NO_VALUE_FUNCS);
	   
        sos_Method m = sos_Method::create (cfe_cnt);
        m.set_name ($1);
        m.set_is_abstract (cfe_method_is_abstract);
        if (cfe_method_is_abstract)
        {
           cfe_ct.set_is_abstract (TRUE);
           // Now check: private methods must not be abstract
           if (cfe_method_kind == sos_PRIVATE)
              cfe_error(err_USE, err_CFE_PRIVATE_METHOD_ABSTRACT);
        }
        m.set_is_definite (cfe_method_is_definite);
        m.set_is_static (cfe_method_is_static);
        m.set_is_operator (cfe_method_is_operator);
        m.set_is_generated (FALSE);
        m.set_params ($2);
        m.set_result_type (cfe_fct_or_comp_type);
        m.set_kind (cfe_method_kind);
        m.set_defined_in (cfe_ct);
        m.set_generated_from (sos_Method::make(NO_OBJECT));
        m.set_impls (sos_Method_impl_List::make (NO_OBJECT));
        cfe_ct.get_local_methods().append(m);
        $$ = m;
     }
   ;

function_name
   : name
     {  $$ = $1;
     }
   | operator
     {  $$ = $1;
        cfe_method_is_operator = TRUE;
     }
   ;

operator
   : operator_tok operator_string
     {  $$ = $2; }
   ;

operator_string
   : star_tok		   { $$ = sos_String::create (cfe_cnt, "*"); }
   | slash_tok		   { $$ = sos_String::create (cfe_cnt, "/"); }
   | percent_tok	   { $$ = sos_String::create (cfe_cnt, "%"); }
   | plus_tok		   { $$ = sos_String::create (cfe_cnt, "+"); }
   | minus_tok		   { $$ = sos_String::create (cfe_cnt, "-"); }
   | r_abr_tok r_abr_tok   { $$ = sos_String::create (cfe_cnt, ">>"); }
   | l_abr_tok l_abr_tok   { $$ = sos_String::create (cfe_cnt, "<<"); }
   | r_abr_tok 		   { $$ = sos_String::create (cfe_cnt, ">"); }
   | l_abr_tok 		   { $$ = sos_String::create (cfe_cnt, "<"); }
   | equal_tok 		   { $$ = sos_String::create (cfe_cnt, "=="); }
   | not_equal_tok 	   { $$ = sos_String::create (cfe_cnt, "!="); }
   | less_equal_tok 	   { $$ = sos_String::create (cfe_cnt, "<="); }
   | greater_equal_tok 	   { $$ = sos_String::create (cfe_cnt, ">="); }
   | ampersand_tok 	   { $$ = sos_String::create (cfe_cnt, "&"); }
   | circumflex_tok 	   { $$ = sos_String::create (cfe_cnt, "^"); }
   | bar_tok	 	   { $$ = sos_String::create (cfe_cnt, "|"); }
   | and_tok	 	   { $$ = sos_String::create (cfe_cnt, "&&"); }
   | or_tok	 	   { $$ = sos_String::create (cfe_cnt, "||"); }
   | assign_tok 	   { $$ = sos_String::create (cfe_cnt, "="); }
   | plus_assign_tok 	   { $$ = sos_String::create (cfe_cnt, "+="); }
   | minus_assign_tok 	   { $$ = sos_String::create (cfe_cnt, "-="); }
   | star_assign_tok 	   { $$ = sos_String::create (cfe_cnt, "*="); }
   | slash_assign_tok 	   { $$ = sos_String::create (cfe_cnt, "/="); }
   | percent_assign_tok    { $$ = sos_String::create (cfe_cnt, "%="); }
   | circumflex_assign_tok { $$ = sos_String::create (cfe_cnt, "^="); }
   | ampersand_assign_tok  { $$ = sos_String::create (cfe_cnt, "&="); }
   | bar_assign_tok 	   { $$ = sos_String::create (cfe_cnt, "|="); }
   | rshift_assign_tok     { $$ = sos_String::create (cfe_cnt, ">>="); }
   | lshift_assign_tok     { $$ = sos_String::create (cfe_cnt, "<<="); }
   | l_par_tok r_par_tok   { $$ = sos_String::create (cfe_cnt, "()"); }
   | l_br_tok  r_br_tok    { $$ = sos_String::create (cfe_cnt, "[]"); }
   ;

parameters
   : l_par_tok r_par_tok
     {  $$ = sos_Param_List::make (NO_OBJECT); }
   | l_par_tok parameters_1 r_par_tok
     {  $$ = $2; }
   ;

parameters_1
   : parameter
     {  $$ = sos_Param_List::create (cfe_cnt, FALSE);
	$$.append ($1);
     }
   | parameters_1 comma_tok parameter
     {  $1.append ($3);
	$$ = $1;
     }
   ;

parameter
   : type_name reference name default_expr
     {  if ($2 && $4 != NO_OBJECT)
	   cfe_error(err_USE, err_CFE_DEFAULT_FOR_REFERENCE);
	$$ = sos_Param::create (cfe_cnt);
	$$.set_name ($3);
	$$.set_type ($1);
	$$.set_default_expr ($4);
	$$.set_is_ref ($2);
     }
   | type_name reference default_expr
     {  if ($2 && $3 != NO_OBJECT)
	   cfe_error(err_USE, err_CFE_DEFAULT_FOR_REFERENCE);
        $$ = sos_Param::create (cfe_cnt);
	$$.set_name (sos_String::make (NO_OBJECT));
	$$.set_type ($1);
	$$.set_default_expr ($3);
	$$.set_is_ref ($2);
     }
  ;

reference
   : {  $$ = FALSE; }
   | ampersand_tok
     {  $$ = TRUE; }
   ;


default_expr
   : {  $$ = sos_Expr::make (NO_OBJECT); }
   | assign_tok expr
     {  $$ = $2; }
   ;

comp_methods
   : comp_names semicolon_tok
   ;

comp_names
   : comp_name
   | comp_names comma_tok comp_name
   ;

comp_name
   : name1 default_expr
     {
        if (cfe_method_is_static)
	   cfe_error(err_USE, err_CFE_NO_STATIC_COMPS);
        if (cfe_method_is_value)
	   cfe_error(err_USE, err_CFE_NO_VALUE_COMPS);
	if (cfe_method_is_abstract)
	   cfe_error(err_USE, err_CFE_ABSTRACT_COMP);
        cfe_append_comp_methods (cfe_ct, cfe_fct_or_comp_type, $1, $2,
				 cfe_method_kind, cfe_set_method_kind,
				 cfe_method_is_value, cfe_method_is_local,
				 cfe_component_offset);
        if ($2 != NO_OBJECT)
	   cfe_ct.set_has_init_comps (TRUE);
     }
   ;

friend
   : friend_tok class_tok type_name1 semicolon_tok
     {  sos_Type_List fl = cfe_ct.get_friends();
	if (fl == NO_OBJECT)
	   cfe_ct.set_friends (fl = sos_Type_List::create (cfe_cnt));
	fl.append ($3.make_type());
     }
   ;

union_declaration
   : union_tok name
     {  cfe_check_type ($2); }
     l_brc_tok types r_brc_tok opt_semicolon
     {  sos_Union_type u = sos_Union_type::create (cfe_cnt);
        u.set_name ($2);
        u.set_united ($5);
        u.set_object_size (0);

        cfe_type_tab.insert ($2, u);
        cfe_types.append (u);
        $$ = u;
     }
   ;

typedef_declaration
   : typedef_tok type_name name
     {  sos_Typedef_type t = sos_Typedef_type::create (cfe_cnt);
        t.set_name ($3);
        t.set_named_type ($2.make_type());
        cfe_check_type ($3);

        cfe_type_tab.insert ($3, t);
        cfe_types.append (t);
        $$ = t;
     }
   ;

extern_declaration
   : extern_tok name extern_size
     {  cfe_check_type ($2);
        sos_Extern_type e = sos_Extern_type::create (cfe_cnt);
        e.set_name ($2);
        e.set_object_size ($3);
        cfe_schema.set_has_external_types (TRUE);

        cfe_type_tab.insert ($2, e);
        cfe_types.append (e);
        $$ = e;
     }
   ;

extern_size
   : {  $$ = 4; }
   | l_par_tok number_tok r_par_tok
     {  $$ = $2;
	if ($2 > SOS_ID_SIZE)
	   cfe_error (err_USE, err_CFE_INVALID_EXT_SIZE);
     }
   ;

super_class_type_name
   : name1
     {  $$ = cfe_lookup_type_name (cfe_ct, $1, sos_IMP_SUPERCLASS); 
	cfe_check_no_generic ($$);
     }
   | super_class_generic_instantiation
     {  $$ = $1; }
   ;

type_name
   : name1
     {  $$ = cfe_lookup_type_name (cfe_ct, $1, sos_IMP_TYPE); 
	cfe_check_no_generic ($$);
     }
   | generic_instantiation
     {  $$ = $1; }
   ;

type_name1
   : name1
     {  $$ = cfe_lookup_type_name (cfe_ct, $1, sos_IMP_TYPE); }
   | generic_instantiation
     {  $$ = $1; }
   ;

exprs
   : {  $$ = sos_Expr_List::create (cfe_cnt, FALSE); }
   | exprs1
   ;

exprs1
   : expr
     {  $$ = sos_Expr_List::create (cfe_cnt, FALSE);
        $$.append ($1);
     }
   | exprs1 comma_tok expr
     {  $1.append ($3);
        $$ = $1;
     }
   ;

expr
   : identifier { $$ = $1; }
   | number     { $$ = $1; }
   ;

identifier
   : name
     {  $$ = sos_Identifier::create (cfe_cnt);
        $$.set_id ($1);
     }
   ;

number
   : number_tok
     {  $$ = sos_Int_expr::create (cfe_cnt);
	$$.set_value ($1);
     }
   ;

super_class_generic_instantiation
   : name1 l_abr_tok type_names r_abr_tok
     {  sos_Type_descr gi = cfe_lookup_generic_instantiation ($1, $3,
                               sos_IMP_SUPERCLASS, cfe_types);
        cfe_gen_insts.append (gi);
        $$ = gi;
     }
   ;

generic_instantiation
   : name1 l_abr_tok type_names r_abr_tok
     {  sos_Type_descr gi = cfe_lookup_generic_instantiation ($1, $3,
                               sos_IMP_GENERIC, cfe_types);
        cfe_gen_insts.append (gi);
        $$ = gi;
     }
   ;

types
   : type_name
     {  $$ = sos_Type_List::create (cfe_cnt, FALSE);
	$$.append ($1.make_type());
     }
   | types comma_tok type_name
     {  $1.append ($3.make_type());
	$$ = $1;
     }
   ;

type_names
   : type_name
     {  $$ = sos_Type_descr_List::create (cfe_cnt, FALSE);
	$$.append ($1);
     }
   | type_names comma_tok type_name
     {  $1.append ($3);
	$$ = $1;
     }
   ;

name1
   : name_tok_or_keyword
     {  $$ = sos_String::create (TEMP_CONTAINER, $1);
	delete $1;
     }
   ;

names
   : name
     {  $$ = sos_String_List::create (cfe_cnt, FALSE);
	$$.append ($1);
     }
   | names comma_tok name
     {  $1.append ($3);
	$$ = $1;
     }
   ;

name
   : name_tok_or_keyword
     {  $$ = sos_String::create (cfe_cnt, $1);
        delete $1;
     }
   ;

name_tok_or_keyword
   : name_tok { $$ = $1; }
   | set_tok  { $$ = obst_strdup ("set"); }
   ;

%%

