/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// Module graphical tools - bundle_main
// **************************************************************************

#define OBST_IMP_STRINGOP
#include "obst_stdinc.h"
#include "obst_progstd.h"
#include "obst.h"
#include "obst_err.h"
#include "obst_trc.h"


extern int demo_main  (int argc, char* argv[]);

#ifdef HAVE_XTOOLS
extern int gsh_main   (int argc, char* argv[]);
extern int dir_main   (int argc, char* argv[]);

#  define XTOOL(main) main(argc,argv)
#else
#  define XTOOL(main) (err_raise(err_USE,"X11-tool not installed",argv[0]),1)
#endif

// --------------------------------------------------------------------------

int main (int argc, char *argv[])
{  obst_init (argc, argv);

   int status = 0;

   char *basename, *ptr;
   basename = ptr = argv[0];
   while (*ptr)
      if (*(ptr ++) == '/')
	 basename = ptr;

   if	   (streql (basename, "demo")) status = demo_main (argc, argv);
   else if (streql (basename, "dir"))  status = XTOOL(dir_main);
   else if (streql (basename, "gsh"))  status = XTOOL(gsh_main);
   else
   {  err_raise (err_USE, "unknown main routine", argv[0]);
      status = 1;
   }

   T_EXIT ();
   return status;
}
