/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */
// **************************************************************************
// Module Set                       03/07/89           Bernhard Schiefer (bs)
//                                                     modified: 23/7/90 (ja)
//                                                              24/10/91 (bs)
//                                                              24/10/92 (ja)
// **************************************************************************
// implements methods of classes: Set
// **************************************************************************

#include "agg.h"
  

// *** Sets are based on Object_sos_Bool_Mappings ***

// **************************************************************************
void sos_Object_Set::change_impl_type (agg_Impl impl)
// **************************************************************************
{   self.get_m().change_impl_type (impl);
} // ** Set::change_impl_type ***

// **************************************************************************
void sos_Object_Set::change_list_cursor (sos_Bool list_cursor)
// **************************************************************************
{  self.get_m().change_list_cursor (list_cursor);
   self.set_list_cursor (list_cursor);
} // ** Set::change_list_cursor ***
 

// **************************************************************************
void sos_Object_Set::local_initialize (sos_Object_Set set)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_initialize");
   TT (agg_H, T_ENTER);

   set.set_m (sos_Object_sos_Object_Mapping::create
		 (set.container(),
		  set.get_list_cursor(),
		  set.get_based_on_equal(),
		  FALSE,
		  set.get_impl_type()));

   TT (agg_H, T_LEAVE);
} // ** local_initialize **

// **************************************************************************
void sos_Object_Set::local_finalize (sos_Object_Set set)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_finalize");
   TT (agg_H, T_ENTER);

   set.get_m().destroy();

   TT (agg_H, T_LEAVE);
} // ** local_finalize **

// **************************************************************************
void sos_Object_Set::insert (sos_Object o)
// **************************************************************************
// fuege das Objekt o in das Set ein, es wird die Anzahl der danach im
// Set vorhandenen Exemplare geliefert.
{
   T_PROC ("sos_Object_Set::insert");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping m = self.get_m();
   m.insert (o, NO_OBJECT); // don't care for the Mapping-Entity

   TT (agg_H, T_LEAVE);
} // ** insert **

// **************************************************************************
void sos_Object_Set::remove (sos_Object o)
// **************************************************************************
// loesche ein Objekt o, es wird TRUE,geliefert, falls es drin war
{  
   T_PROC ("sos_Object_Set::remove");
   TT (agg_H, T_ENTER);

   self.get_m().remove (o);

   TT (agg_H, T_LEAVE);
} // ** remove **

// **************************************************************************
void sos_Object_Set::operator+= (sos_Object_Set aset)
// **************************************************************************
// Nach A += B wurden alle Elemente in B zu A aufaddiert
{
   T_PROC ("sos_Object_Set::operator+=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping this_m = self.get_m();
   sos_Object_sos_Object_Mapping aset_m = aset.get_m();

   sos_Cursor cur = aset_m.open_cursor ();
   for (;aset_m.is_valid (cur); aset_m.to_succ (cur))
   {  sos_Object o = aset_m.get_key (cur);
      this_m.insert (o, NO_OBJECT);
   } // for
   aset_m.close_cursor (cur);

   TT (agg_H, T_LEAVE);
} // ** operator+= **

// **************************************************************************
void sos_Object_Set::operator-= (sos_Object_Set aset)
// **************************************************************************
// Nach A -= B wurden aus A alle Elemente, die in B sind, entfernt
{  
   T_PROC ("sos_Object_Set::operator-=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping this_m = self.get_m();
   sos_Object_sos_Object_Mapping aset_m = aset.get_m();

   sos_Cursor cur = aset_m.open_cursor();
   for (;aset_m.is_valid (cur);aset_m.to_succ (cur))
   {  sos_Object o = aset_m.get_key (cur);
      this_m.remove (o);
   } // for
   aset_m.close_cursor (cur);

   TT (agg_H, T_LEAVE);
} // ** operator-= **

// **************************************************************************
void sos_Object_Set::operator*= (sos_Object_Set aset)
// **************************************************************************
// Liefert die Schnittmenge von A und B in A,
// Also entferne aus self alle Elemente, die nicht in aset sind
{
   T_PROC ("sos_Object_Set::operator*=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping aset_m = aset.get_m();
   sos_Object_sos_Object_Mapping this_m = self.get_m();

   sos_Cursor cur = this_m.open_cursor();
   for (;this_m.is_valid (cur);)
   {  sos_Object o = this_m.get_key (cur);
      if (NOT aset_m.is_key (o))
         this_m.remove_at (cur);
      else
         this_m.to_succ (cur);
   } // for 
   this_m.close_cursor (cur);

   TT (agg_H, T_LEAVE);
} // ** operator*= **

// **************************************************************************
sos_Bool sos_Object_Set::operator< (sos_Object_Set aset)
// **************************************************************************
// Liefert TRUE zurueck, wenn jedes Element aus this auch in aset ist
// und aset mindestens ein Element mehr enthaelt
{ 
   T_PROC ("sos_Object_Set::operator<");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping aset_m = aset.get_m();
   sos_Object_sos_Object_Mapping this_m = self.get_m();
   sos_Bool result = TRUE;

   if (this_m.card() >= aset_m.card())
      result = FALSE;
   else
   {  sos_Cursor cur = this_m.open_cursor();
      for (;this_m.is_valid (cur);this_m.to_succ (cur))
      {  sos_Object o = this_m.get_key (cur);
         if (NOT aset_m.is_key (o))
         {  result = FALSE;
            break;
         }
      } // for
      this_m.close_cursor (cur);
   }

   TT (agg_H, T_LEAVE);
   return result;
} // ** operator< **

// **************************************************************************
sos_Bool sos_Object_Set::operator<= (sos_Object_Set aset)
// **************************************************************************
// Liefert TRUE zurueck, wenn jedes Element aus this auch in aset ist
{ 
   T_PROC ("sos_Object_Set::operator<=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping aset_m = aset.get_m();
   sos_Object_sos_Object_Mapping this_m = self.get_m();
   sos_Bool result = TRUE;

   // pruefe zuerst, ob die Anzahl der Elemente schon ein Ergebnis liefert
   if (this_m.card() > aset_m.card())
      result = FALSE;
   else
   {  sos_Cursor cur = this_m.open_cursor();
      for (;this_m.is_valid (cur); this_m.to_succ (cur))
      {  sos_Object o = this_m.get_key (cur);
         if (NOT aset_m.is_key (o))
         {  result = FALSE;
            break;
         }
      } // for
      this_m.close_cursor (cur);
   }
   TT (agg_H, T_LEAVE);
   return result;
} // ** operator<= **

// **************************************************************************
sos_Bool sos_Object_Set::operator> (sos_Object_Set aset)
{ return sos_Bool (aset < self); }
// **************************************************************************

// **************************************************************************
sos_Bool sos_Object_Set::operator>= (sos_Object_Set aset)
{ return sos_Bool (aset <= self); }
// **************************************************************************

// **************************************************************************
void sos_Object_Set::local_assign (sos_Object_Set x, sos_Object o)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_assign");
   TT(agg_H, T_ENTER);

   sos_Object_Set y = sos_Object_Set::make (o);
   x.get_m().assign (y.get_m());

   TT(agg_H, T_LEAVE);
} // local_assign

// **************************************************************************
sos_Bool sos_Object_Set::local_equal (sos_Object_Set x,
				      sos_Object     o,
	 			      sos_Eq_kind    eq_kind)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_equal")
   TT(agg_H, T_ENTER);
   
   sos_Object_Set y = sos_Object_Set::make (o);
   sos_Bool result = x.get_m().equal (y.get_m(), eq_kind);

   TT(agg_H, T_LEAVE);
   return result;
} // local_equal

// **************************************************************************
sos_Int sos_Object_Set::local_hash_value (sos_Object_Set x)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_hash_value");
   TT(agg_H, T_ENTER);
   
   sos_Int result = x.get_m().hash_value ();

   TT(agg_H, T_LEAVE);

   return result;
} // local_hash_value

// **************************************************************************
sos_Bool sos_Object_Set::is_element (sos_Object o)
// **************************************************************************
{  T_PROC ("sos_Object_Set::is_element");
   TT (agg_H, T_ENTER);

   sos_Bool result = self.get_m().is_key (o);
 
   TT (agg_H, T_LEAVE);
   return result;
} // ** is_element(sos_Object)

// **************************************************************************
sos_Object sos_Object_Set::get (sos_Cursor c)
// **************************************************************************
{  T_PROC ("sos_Object_Set::get");
   TT (agg_H, T_ENTER);

   sos_Object o = self.get_m().get_key (c);

   TT (agg_H, T_LEAVE);
   return o;
} // ** get **

// **************************************************************************
void sos_Object_Set::remove_at (sos_Cursor c)
// **************************************************************************
{  T_PROC ("sos_Object_Set::remove_at");
   TT (agg_H, T_ENTER);

   self.get_m().remove_at (c);

   TT (agg_H, T_LEAVE);
} // ** remove_at **

// **************************************************************************
void sos_Object_Set::clear()
// **************************************************************************
{  T_PROC ("sos_Object_Set::clear");
   TT (agg_H, T_ENTER);
   
   self.get_m().clear();

   TT (agg_H, T_LEAVE);
} // ** clear

// **************************************************************************
sos_Int sos_Object_Set::card ()
// **************************************************************************
{  return self.get_m().card ();
} // card

// **************************************************************************
sos_Cursor sos_Object_Set::open_cursor (sos_Container Cursor_ct)
// **************************************************************************
{  return self.get_m().open_cursor (Cursor_ct);
} // open_cursor

// **************************************************************************
void sos_Object_Set::close_cursor (sos_Cursor c)
// **************************************************************************
{  self.get_m().close_cursor (c);
} // close_cursor
 
// **************************************************************************
sos_Cursor sos_Object_Set::duplicate (sos_Cursor c, 
				      sos_Container cnt /*= TEMP_CONTAINER */)
// **************************************************************************
{  return self.get_m().duplicate (c,cnt);
} // duplicate

// **************************************************************************
sos_Bool sos_Object_Set::is_valid (sos_Cursor c)
// **************************************************************************
{  return self.get_m().is_valid (c);
} // ** is_valid **
 
// **************************************************************************
sos_Bool sos_Object_Set::to_first (sos_Cursor c)
// **************************************************************************
{  return self.get_m().to_first (c);
} // to_first

// **************************************************************************
sos_Bool sos_Object_Set::to_last (sos_Cursor c)
// **************************************************************************
{  return self.get_m().to_last (c);
} // to_last
 
// **************************************************************************
sos_Bool sos_Object_Set::to_succ (sos_Cursor c, sos_Int steps)
// **************************************************************************
{  T_PROC ("sos_Object_Set::to_succ");
   TT (agg_H, T_ENTER);

   sos_Bool result = self.get_m().to_succ (c, steps);
 
   TT (agg_H, T_LEAVE);
   return result;
} // ** to_succ**

// **************************************************************************
sos_Bool sos_Object_Set::to_pred (sos_Cursor c, sos_Int steps)
// **************************************************************************
{  T_PROC ("sos_Object_Set::to_pred");
   TT (agg_H, T_ENTER);

   sos_Bool result = self.get_m().to_pred (c, steps);
   
   TT (agg_H, T_LEAVE);
   return result;
} // ** to_pred **
