#ifndef _KNL_EXT_H
#define _KNL_EXT_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include "psm.h"

typedef double	_obst_maxalign_t;


// ***********************  C++ Binding Customization Macros  **************

#ifdef NULL_CONVERSION_BUG
#  define OBST_BASECONV(dp,b) ((dp)?(dp):(b*)0)
#else
#  define OBST_BASECONV(dp,b) (dp)
#endif

#ifdef CALL_STATIC_BUG
#  define OBST_CALLSTATIC(nm,args,decls) (* ((void(*)decls) &nm) )args
#else
#  define OBST_CALLSTATIC(nm,args,decls) nm args
#endif

#ifdef OBST_USEPURE
#  define OBST_ISPURE	const=0;
#else
#  define OBST_ISPURE	const;
#endif

#define OBST_CREATE_START int _ic=(int)obst_in_create;obst_in_create=TRUE;
#define OBST_CREATE_END   obst_in_create=(sos_Bool)_ic;
#define OBST_COPY_START   int _ic=(int)obst_in_create;obst_in_create=FALSE;
#define OBST_COPY_END	  obst_in_create=(sos_Bool)_ic;

#ifdef OBST_FLOAT_BUG
#  define OBST_FLOATDECL(tp)	 const tp&
#  define _OBST_FLOATDECL(tp)	 const tp&
#  define OBST_FLOATMAKEDECL(tp) const tp&
#else
#  define OBST_FLOATDECL(tp)	 tp
#  define _OBST_FLOATDECL(tp)	 OBST_PARDECL(tp)
#  define OBST_FLOATMAKEDECL(tp) const tp
#endif

#ifdef OBST_EXPLCAST_BUG
#  define OBST_CAST(tp,val) ((tp)(val))
#  define OBST_PARDECL(tp)  tp
#else
#  define OBST_CAST(tp,val) (val)
#  define OBST_PARDECL(tp)  const tp&
#endif

#ifdef OBST_CPLXARG_BUG
#  define OBST_TMPDEF(_x,_tp,_var) _x _tp _var;
#  define OBST_CPLXARG(_var,_val)  (_var=(_val),_var)
#else
#  define OBST_TMPDEF(_x,_tp,_var)
#  define OBST_CPLXARG(_var,_val)  (_val)
#endif
#define OBST_MAKE_ARG(_tp,_var,_v) OBST_CPLXARG(_var,_tp::make(_v))

// ****************************  sos_Cstring  *******************************

typedef char *sos_Cstring;

#define SOS_CSTRING_SIZE 4
inline void bcopy_from_sos_Cstring (register void* s, register void* c)
{  *(sos_Cstring *)c = *(sos_Cstring *)s; }
inline void bcopy_to_sos_Cstring (register void* s, register void* c)
{  *(sos_Cstring *)s = *(sos_Cstring *)c; }
sos_Cstring make_string_from_sos_Cstring_object (const sos_Object&);
sos_Object  make_sos_Cstring_object_from_string (const sos_Cstring);

// *****************************  sos_Short  *********************************

// sos_Short is declared in "psm.h"

// *****************************  sos_Int  *********************************

// sos_Int is declared in "psm.h"

inline void bcopy_from_sos_Int (register void* i, register void* c)
{  *(sos_Int *)c = *(sos_Int *)i; }
inline void bcopy_to_sos_Int (register void* i, register void* c)
{  *(sos_Int *)i = *(sos_Int *)c; }
sos_Cstring make_string_from_sos_Int_object (const sos_Object&);
sos_Object  make_sos_Int_object_from_string (const sos_Cstring);

// *****************************  sos_Char  ********************************

typedef char sos_Char;

#define SOS_CHAR_SIZE 1
inline void bcopy_from_sos_Char (register void* ch, register void* c)
{  *(sos_Char*)c = *(sos_Char*)ch; }
inline void bcopy_to_sos_Char (register void* ch, register void* c)
{  *(sos_Char*)ch = *(sos_Char*)c; }
sos_Cstring make_string_from_sos_Char_object (const sos_Object&);
sos_Object  make_sos_Char_object_from_string (const sos_Cstring);

// **************************  sos_Pointer  ****************************

// sos_Pointer is declared in "psm.h"

inline void bcopy_from_sos_Pointer (register void* p, register void* c)
{  *(sos_Pointer *)c = *(sos_Pointer *)p; }
inline void bcopy_to_sos_Pointer (register void* p, register void* c)
{  *(sos_Pointer *)p = *(sos_Pointer *)c; }
sos_Cstring make_string_from_sos_Pointer_object (const sos_Object&);
sos_Object  make_sos_Pointer_object_from_string (const sos_Cstring);

// **************************  sos_Float  ****************************

typedef float sos_Float;

#define SOS_FLOAT_SIZE 4
inline void bcopy_from_sos_Float (register void *f, register void *c)
{  *(sos_Float*)c = *(sos_Float*)f; }
inline void bcopy_to_sos_Float (register void *f, register void *c)
{  *(sos_Float*)f = *(sos_Float*)c; }
sos_Cstring make_string_from_sos_Float_object (const sos_Object&);
sos_Object  make_sos_Float_object_from_string (const sos_Cstring);


// **************************  sos_CppFctPtr  ****************************

typedef void (*sos_CppFctPtr)();

inline void bcopy_from_sos_CppFctPtr (register void* p, register void* c)
{  *(sos_CppFctPtr *)c = *(sos_CppFctPtr *)p; }
inline void bcopy_to_sos_CppFctPtr (register void* p, register void* c)
{  *(sos_CppFctPtr *)p = *(sos_CppFctPtr *)c; }
sos_Cstring make_string_from_sos_CppFctPtr_object (const sos_Object&);
sos_Object  make_sos_CppFctPtr_object_from_string (const sos_Cstring);

// ****************************  sos_Offset ********************************

// sos_Offset is declared in "psm.h"

inline void bcopy_from_sos_Offset (register void* o, register void* c)
{  *(sos_Offset *)c = *(sos_Offset *)o; }
inline void bcopy_to_sos_Offset (register void* o, register void* c)
{  *(sos_Offset *)o = *(sos_Offset *)c; }
sos_Cstring make_string_from_sos_Offset_object (const sos_Object&);
sos_Object  make_sos_Offset_object_from_string (const sos_Cstring);

// ***************************  sos_Container  *****************************

// sos_Container is declared in "psm.h"

inline void bcopy_from_sos_Container (register void* ct, register void* c)
{  *(sos_Container *)c = *(sos_Container *)ct; }
inline void bcopy_to_sos_Container (register void* ct, register void* c)
{  *(sos_Container *)ct = *(sos_Container *)c; }
sos_Cstring make_string_from_sos_Container_object (const sos_Object&);
sos_Object  make_sos_Container_object_from_string (const sos_Cstring);


// ******************************  sos_Id **********************************

class sos_Id		// must not have a vtable!
{
   sos_Offset    os;
   sos_Container ct;
public:
   sos_Container container () const { return ct; }
   sos_Offset    offset ()    const { return os; }

   static sos_Id make (sos_Container ct, sos_Offset os)
      { sos_Id id; id.ct=ct; id.os=os; return id; }


   sos_Bool operator== (const sos_Id& id) const
#ifdef INLINE_sos_Id_OP_equal
      { return (sos_Bool) (os == id.os && ct == id.ct); }
#else
   ;
#endif

   sos_Bool operator!= (const sos_Id& id) const
      { return (sos_Bool) (os != id.os || ct != id.ct); }

   sos_Id get_type_id () const;
   void   set_type_id (const sos_Id& tp) const;
};

#define SOS_ID_SIZE 8
inline void bcopy_from_sos_Id (register void* i, register void* c)
{  *(sos_Id *)c = *(sos_Id *)i; }
inline void bcopy_to_sos_Id (register void* i, register void* c)
{  *(sos_Id *)i = *(sos_Id *)c; }
sos_Cstring make_string_from_sos_Id_object (const sos_Object&);
sos_Object  make_sos_Id_object_from_string (const sos_Cstring);


// ***************************  sos_Typed_id *******************************

class sos_Type;

class sos_Typed_id
{  sos_Id id;
   sos_Id tp;
public:
   static sos_Typed_id make (const sos_Id& id, const sos_Id& tp)
   { sos_Typed_id tpid; tpid.id=id; tpid.tp=tp; return tpid; }

   sos_Id       get_id () const { return id; }
   sos_Id       get_tp () const { return tp; }

   sos_Container container () const { return id.container(); }
   sos_Offset    offset ()    const { return id.offset(); }

   sos_Bool operator== (const sos_Typed_id& tpid) const
   { return (sos_Bool) (id == tpid.id && tp == tpid.tp); }
   sos_Bool operator!= (const sos_Typed_id& tpid) const
   { return (sos_Bool) (id != tpid.id || tp != tpid.tp); }

   static sos_Typed_id allocate (const sos_Type&, sos_Container);
   static sos_Typed_id allocate (const sos_Id&, sos_Container, sos_Int);
   static sos_Typed_id make (const sos_Id&);

}; // ** sos_Typed_id **

#define SOS_TYPED_ID_SIZE 16
inline void bcopy_from_sos_Typed_id (register void* tpid, register void* c)
{ *(sos_Typed_id *)c = *(sos_Typed_id *)tpid; }
inline void bcopy_to_sos_Typed_id (register void* tpid, register void* c)
{ *(sos_Typed_id *)tpid = *(sos_Typed_id *)c; }


// *************************** obst_Root_class *****************************

class obst_Root_class
{
protected:
   sos_Typed_id _self;
public:
   sos_Typed_id    _typed_id() const { return _self; }
   sos_Id	   _self_id()  const { return _self.get_id(); }
   sos_Id	   _type_id()  const { return _self.get_tp(); }

   sos_Container   container() const { return _self.container(); }
   sos_Offset      offset()    const { return _self.offset(); }
   sos_Bool	   identical   (const obst_Root_class&) const;
   sos_Bool	   operator==  (const obst_Root_class&) const;
   sos_Bool	   operator!=  (const obst_Root_class&) const;
   sos_Comp_result compare_ids (const obst_Root_class&) const;
};

class _obst_Root_class
{
protected:
   int _size;
};


// *********************** scalar object representation ********************

extern sos_Object _obst_object_from_extern (void* addr,
					    void bcopy_from(void*,void*),
					    const sos_Id& tp);
extern void       _obst_extern_from_object (void* addr,
					    const sos_Object& o,
					    void bcopy_to (void*,void*),
					    const sos_Id& tp);

extern sos_Scalar_object _obst_enum_from_sos_Int (sos_Int, const sos_Type&);
extern sos_Int	         _obst_Int_from_enum (const sos_Object&,
					      const sos_Type&);


// ************************** type representation **************************

enum _obst_knl_types { _THE_VOID_TYPE,   _THE_BOOL_TYPE, _THE_EQKIND_TYPE,
		       _THE_INT_TYPE,    _THE_CNT_TYPE,
		       _THE_OBJECT_TYPE, _THE_SCALAR_TYPE };

extern sos_Type     _obst_knl_type (_obst_knl_types);
extern sos_Type     _obst_type_object (const sos_Id&, const sos_Id&);
extern sos_Typed_id _obst_make_local_typed_id (sos_Offset, sos_Container);
extern sos_Offset   _obst_local_offset (OBST_PARDECL(sos_Object), sos_Container);


// ***********************  auxiliary declarations *************************

extern sos_Object NO_OBJECT;
extern sos_Bool   obst_in_create;

// ***********************  auxiliary methods ******************************

extern void		   _obst_basic_init();
extern void                _obst_initcore();
extern sos_Existing_status obst_ID_valid (const sos_Typed_id&);
extern sos_Bool            obst_is_temporary (const sos_Object&);


#endif
