dnl--------------------------------------------------------------------
dnl Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
dnl
dnl You can use and distribute this software under the terms of the license
dnl you should have received along with this software.
dnl If not or if you want additional information, write to
dnl Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
dnl D-76131 Karlsruhe, Germany.
dnl--------------------------------------------------------------------
dnl aclocal.m4 - dietmar theobald - 11/9/93
dnl
dnl OBST autoconf: additional macros
dnl--------------------------------------------------------------------
dnl	This file is an input file used by the GNU "autoconf" program to
dnl	generate the file "configure", which is run during installation
dnl	to configure the system for the local environment.
dnl
dnl	Although the generated configure script is under the GNU Public
dnl	License, this file and the other OBST sources are treated by
dnl	the OBST license (see above).
dnl--------------------------------------------------------------------
dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_USAGE(<module>,<inner>)
dnl	Expanded to the "-quoted definition of a (shell) variable 'usage'
dnl	which contains a help text for an OBST configure.in spec.
dnl	<inner> is expected to describe additional options.
dnl	AC_PROVIDE(OBST_ITSELF) is invoked, iff this is the configuration
dnl	file for the OBST core distribution itself.
dnl....................................................................
define(OBST_USAGE,[dnl
usage="
usage: configure [[--<option>[=<value>]]] ...

Set compilation and installation parameters for $1 using the GNU
autoconf system.
Besides the standard GNU configure options, the following options are
recognized (there must be no white space in an option spec):
ifelse($1,OBST,[AC_PROVIDE([OBST_ITSELF])],[
  --obst-includes=<d>   Search for OBST header files foremost in <d>.
  --obst-libraries=<d>  Search for OBST libraries formost in <d>.])dnl
ifelse($2,,,[  ][$2])dnl
  --subst:<nm>=<txt>    Define <txt> as value for @<nm>@ in configured files.
  --[define]:<nm>=<txt>   Set <txt> as value for #define <nm> in configured
                        header files.
  --prevent:<nm>        Prevent a later '--subst' or '--[define]' declaration
                        from taking effect.
  --conf-file=<file>    Similar to '--subst', '--[define]', or '--prevent' but
                        the declarations are taken from <file> instead of
                        listing them individually on the command line.
                        <file> is expected to contain specifications in the
                        form <nm>=<txt> for substitutions, <nm>:<txt> for
                        definitions, and !<nm> for a 'prevent' declaration,
                        any other lines are ignored.

                        Only the first definition/substitution for a given
                        <nm> will be performed.

  --usage,--help        Print this text and exit.
"])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_REPORT_ASSIGN(<variable-name>,<value>==$<variable_name>)
dnl	Report the assignment <variable-name>=$<value>.
dnl	<value> defaults to $<variable-name> if omitted.
dnl
dnl OBST_WARN(<msg>)
dnl	Print the given warning.
dnl....................................................................
define(OBST_REPORT_ASSIGN,
echo "	setting $1 to \"[ifelse($2,,[$]$1,$2)]\"")dnl
define(OBST_WARN,echo >&2 "*** WARNING:" $1)dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_WS(), OBST_ID(), OBST_SHID()
dnl 	Utility constants for sed expressions: white space, identifier,
dnl 	shell variable name.
dnl....................................................................
define(OBST_WS,[[[ 	]*]])dnl
define(OBST_ID,[[[-+_.A-Za-z][-+_.A-Za-z0-9]*]])dnl
define(OBST_SHID,[[[_A-Za-z][_A-Za-z0-9]*]])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_GETVAL(<assgn>,<assgn-char>=='=')
dnl	Parses an "...<assgn-char><value>" string and yields <value>.
dnl
dnl OBST_GET_DEFINE(<name>,<file>)
dnl	Parses <file> and yields the value of '#define <name>'.
dnl
dnl OBST_GET_MACRO(<name>,<file>)
dnl	Parses <file> and yields the value of '<name> = <val>'.
dnl
dnl OBST_LSTRIP(<str>,<strip-expr>,<add-sed-cmds>==NULL)
dnl	Yields <str> after stripping the leftmost part (optionally)
dnl	matched by <strip-expr>.
dnl	If present, the additional sed expressions are applied before
dnl	returning <str>.
dnl
dnl OBST_VARPREFIX()
dnl	Yields a prefix which is employed to create a `separate` name space,
dnl	in particular for the variables used in OBST_SUBST, OBST_DEFINE.
dnl
dnl OBST_VAR(<name>)
dnl	Prepends OBST_VARPREFIX to <name>.
dnl
dnl OBST_VARNAME(<name>)
dnl	yields <name> where all characters except for A-Z,a-z,0-9 are
dnl	replaced by '_'.
dnl
dnl OBST_VAR_DEFINED(<name>)
dnl	Tests whether the shell variable <name> is already defined.
dnl
dnl OBST_WITHOPT(<opt>,<val>)
dnl	Transforms an option '--with*-<nm>' into the assignment of
dnl	<val> to the (shell) variable 'with_<nm>', whereby all
dnl	occurences of '-' in <nm> have been replaced by '_'.
dnl
dnl OBST_DO_OPTS(<arglist>,<curr_opt>,<inner>)
dnl	The macro takes the standard OBST configuration options from
dnl	<arglist> and processes them. Each option is assigned to <curr_opt>
dnl	before processing it.
dnl	In particular, any substitution option contained in <arglist>
dnl	is processed via OBST_CONFFILE_OPT, OBST_SUBST_OPT, OBST_DEFINE_OPT,
dnl	and OBST_PREVENT_OPT, respectively.
dnl	<inner> is code to process additional options, whereby <inner> is
dnl	inside a `case' statement switching by '$<curr_opt>'.
dnl	It defines the variables '<.>defaultdirs' (as '$srcdir/include/etc'),
dnl	'<.>tmpf', and 'srcdir_abs' (absolute path of $srcdir).
dnl	If their counterparts $prefix and $exec_prefix are non-empty, the
dnl	variables $OBST_VAR(prefix) and $OBST_VAR(exec_prefix) are set to a
dnl	non-empty value.
dnl	In OBST applications, a rule for searching an installed OBST version
dnl	is added.
dnl
dnl OBST_CONFFILE_OPT(<opt>)
dnl	Invokes OBST_CONFFILE(<file>) for an option '*=<file>'.
dnl
dnl OBST_CONF_OPT(<opt>,<macro>)
dnl	Auxiliary definition for performing OBST_DEFINE_OPT, OBST_SUBST_OPT.
dnl
dnl OBST_DEFINE_OPT(<opt>)
dnl	Parses an '--define:<nm>=<txt>' option and issues
dnl	OBST_DEFINE(<nm>,<txt>).
dnl
dnl OBST_SUBST_OPT(<opt>)
dnl	Parses an '--subst:<nm>=<txt>' option and issues
dnl	OBST_SUBST(<nm>,<txt>).
dnl
dnl OBST_PREVENT_OPT(<opt>)
dnl	Parses an '--prevent:<nm>' option and issues OBST_PREVENT(<nm>).
dnl....................................................................
define(OBST_GETVAL,[`echo "$1" | sed 's|[[[^=]]]*=\(.*\)|\1|'`])dnl
define(OBST_GET_DEFINE,[dnl
`sed -n -e 's|^[#]OBST_WS[define]OBST_WS[$1]OBST_WS\(.*\)|\1|p' $2`])dnl
define(OBST_GET_MACRO,[dnl
`sed -n -e 's|^OBST_WS[$1]OBST_WS=OBST_WS\(.*\)|\1|p' $2`])dnl
define(OBST_LSTRIP,`echo "$1" | sed 's|^$2||[ifelse($3,,,;[$3])]'`)dnl
define(OBST_VARPREFIX,__)dnl
define(OBST_VAR,OBST_VARPREFIX$1)dnl
define(OBST_VARNAME,`[echo "$1" | sed 's|[[[^A-Za-z0-9]]]|_|g'`])dnl
define(OBST_VAR_DEFINED,[changequote(,)dnl
[ -n "`eval echo '${'"$1"'+.}'`" ]changequote([,])])dnl
define(OBST_WITHOPT,[dnl
OBST_VAR(o)="OBST_LSTRIP($1,--[[[a-z]]]*-,s|[[[^A-Za-z0-9]]]|_|g)"
eval "with_[$]OBST_VAR(o)='$2'"])dnl
define(OBST_DO_OPTS,[dnl
test -z "$prefix" || OBST_VAR(prefix)=x
test -z "$exec_prefix" || OBST_VAR(exec_prefix)=x
OBST_IF_PROVIDED([OBST_ITSELF],,ADD_obstINCS=;ADD_obstLIBS=;)dnl
srcdir_abs="`(cd $srcdir; pwd | sed 's|/tmp_mnt||')`" AC_SUBST(srcdir_abs)
OBST_VAR(defaultdirs)="$srcdir/include/etc";OBST_VAR(tmpf)=/tmp/conf$$ig
for $2 in $1 ""
do
   case "[$]$2" in
      --without-*)    OBST_WITHOPT([$]$2,0)	;;
      --usage|--help) echo "[$]usage"; exit 0	;;
      --[define]:*=*) OBST_DEFINE_OPT([$]$2)	;;
      --subst:*=*)    OBST_SUBST_OPT([$]$2)	;;
      --prevent:*)    OBST_PREVENT_OPT([$]$2)	;;
      --conf-file=*)  OBST_CONFFILE_OPT([$]$2)	;;
OBST_IF_PROVIDED([OBST_ITSELF],,
   --obst-includes=*[)]  ADD_obstINCS="$ADD_obstINCS OBST_GETVAL($opt)" ;;
   --obst-libraries=*[)] ADD_obstLIBS="$ADD_obstLIBS OBST_GETVAL($opt)" ;;
)dnl
$3
   esac
done
OBST_IF_PROVIDED([OBST_ITSELF],,[OBST_FIND_OBST(ADD_obstINCS,ADD_obstLIBS)])])dnl
define(OBST_CONFFILE_OPT,
[OBST_CONFFILE(OBST_GETVAL($1))])dnl
define(OBST_CONF_OPT,[dnl
eval "`echo "$1" | [sed -n 's|^[^:]*:\([^=]*\)=\(.*\)|]OBST_VAR(n)="\1";OBST_VAR(v)="\2"|p'`"
$2([$]OBST_VAR(n),[$]OBST_VAR(v))dnl
])dnl
define(OBST_SUBST_OPT,[OBST_CONF_OPT([$1],[OBST_SUBST])])dnl
define(OBST_DEFINE_OPT,[OBST_CONF_OPT([$1],[OBST_DEFINE])])dnl
define(OBST_PREVENT_OPT,[changequote(,)dnl
eval "`echo "$1" | sed -n 's|^[^:]*:\(.*\)|OBST_VAR(n)="\1"|p'`"
changequote([,])dnl
OBST_PREVENT([$]OBST_VAR(n))])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_FILE_SEARCH(<variable>, <file>, <dirs>, <pref> = "", <suff> = "")
dnl	Search <file> in the whitespace separated list of directories
dnl	<dirs>.
dnl	<variable> is initialized to "" and set to "<pref><dir><suff>"
dnl	for the first directory <dir> containing <file>.
dnl	<pref> and <suff> must be quoted if these are literal strings.
dnl	If no such directory can be found, a warning message is issued.
dnl....................................................................
define(OBST_FILE_SEARCH,[dnl
$1=;for OBST_VAR(d) in $3
changequote(,)dnl
do for OBST_VAR(f) in $OBST_VAR(d)/$2
   do [ -r "$OBST_VAR(f)" ] && { $1=$4"$OBST_VAR(d)"$5; break 2; }
   done
done
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_FILE_CHECK(<variable>, <file>, <dirs>, <pref> = "", <suff> = "")
dnl
dnl Like OBST_FILE_SEARCH, plus:
dnl  o a warning message is issued, if <file> is not found.
dnl  o an OBST_SUBST call is issued for <variable>.
dnl....................................................................
define(OBST_FILE_CHECK,[dnl
OBST_FILE_SEARCH($1,$2,$3,$4,$5)
changequote(,)dnl
[ -n "$$1" ] || changequote([,])OBST_WARN("couldn't find \"$2\" in \"$3\"")
OBST_SUBST($1,$$1)dnl
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_IF_PROVIDED(<macro>,<if-true>,<if-false>)
dnl	Variant of `ifdef' which tests, if AC_PROVIDE(<macro>) has been
dnl	executed.
dnl....................................................................
define(OBST_IF_PROVIDED,[ifdef([AC_PROVIDE_$1],[$2],[$3])])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_SUBST(<original>,<replacement>,no_check==NULL)
dnl	Variant of AC_SUBST for the case when <original> is not known
dnl	until `configure' gets executed.
dnl	If the third argument is null, the substitution is only
dnl	performed if the shell variable <original'> is not yet defined,
dnl	whereby <original'> is <original> with all characters except for
dnl	A-Z,a-z,0-9 replaced by '_' and prepended by OBST_VARPREFIX.
dnl	In case the substitution is performed, <original'> is set to
dnl	<replacement>.
dnl	If required, '-quotes must be used for <replacement> (no "-quotes).
dnl
dnl OBST_DEFINE(<name>,<value>,no_check==NULL)
dnl	Variant of AC_DEFINE_UNQUOTED analogous to OBST_SUBST: if the
dnl	third argument is null, the definition is only performed if
dnl	<name'> is not yet set and <name'> is then set to <value>.
dnl
dnl *** note: substitutions defined earlier take precedence over later ones!
dnl
dnl OBST_PREVENT(<name>,no_check==NULL)
dnl	Prevents a later definition for <name> by setting <name'> to an
dnl	arbitrary non-empty string. If the 2nd argument is null, this is
dnl	only done if <name'> is not yet set.
dnl....................................................................
define(OBST_QUOTE,
`echo "$1='$2'"|sed "s%=''\(.\)%=\"'\"'\1%;s%\([[[^=]]]\)''\[$]%\1'\"'\"%"`)dnl
define(OBST_SUBST_VAR,OBST_VAR(addsubst))dnl
define(OBST_SUBST,[dnl
ifelse($3,,[dnl
OBST_VAR(vnm)="OBST_VAR(OBST_VARNAME($1))";OBST_VAR_DEFINED([$]OBST_VAR(vnm))||])dnl
changequote(`,')dnl
{ [ -z "$OBST_SUBST_VAR`_'" ] || OBST_SUBST_VAR="$OBST_SUBST_VAR
"
OBST_SUBST_VAR="${OBST_SUBST_VAR}s%@$1@%$2%g";OBST_SUBST_VAR`_'=+
[ -z "$verbose" ] || changequote([,])OBST_REPORT_ASSIGN($1,$2)
ifelse($3,,eval [OBST_QUOTE([$]OBST_VAR(vnm),$2)];)}
AC_PROVIDE([$0])])dnl
define(OBST_DEFINE,
[ifelse($3,,[dnl
OBST_VAR(vnm)="OBST_VAR(OBST_VARNAME($1))";OBST_VAR_DEFINED([$]OBST_VAR(vnm))||])dnl
{ AC_DEFINE_UNQUOTED($1,$2)
ifelse($3,,eval [OBST_QUOTE([$]OBST_VAR(vnm),$2)];)}])dnl
define(OBST_PREVENT,[dnl
ifelse($2,,[dnl
OBST_VAR(vnm)="OBST_VAR(OBST_VARNAME($1))";OBST_VAR_DEFINED([$]OBST_VAR(vnm))|| ])dnl
eval "[$]OBST_VAR(vnm)=_"])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_CONFFILE(<file>...)
dnl	If <name'> (see below) is not yet defined, <name>=<value>,
dnl	<name>:<value> pairs are read from the given files and the
dnl	according substitutions/definitions are defined via OBST_SUBST,
dnl	OBST_DEFINE, and OBST_PREVENT, respectively.
dnl	Additionally, the shell variable <name'> is set to <value>,
dnl	whereby <name'> is <name> with all characters except for A-Z,a-z,0-9
dnl	replaced by '_' and prepended by OBST_VARPREFIX.
dnl	Files which are not readable are reported and then discarded.
dnl	If a file is not found, it is searched in $<.>defaultdirs.
dnl
dnl *** note: substitutions/definitions defined earlier take precedence!
dnl....................................................................
define(OBST_CONFFILE,[dnl
OBST_VAR(fs)=
for OBST_VAR(f) in $1 ""
changequote(,)dnl
do if [ -r "$OBST_VAR(f)" ]; then
      OBST_VAR(fs)="$OBST_VAR(fs) $OBST_VAR(f)"
   elif [ "$OBST_VAR(f)" != "" ]; then
      OBST_VAR(_f)=
      for OBST_VAR(d) in $OBST_VAR(defaultdirs)
      do [ -r "$OBST_VAR(d)/$OBST_VAR(f)" ] && OBST_VAR(_f)="$OBST_VAR(d)/$OBST_VAR(f)"
      done
      if [ -n "$OBST_VAR(_f)" ]; then
changequote([,])dnl
	 OBST_VAR(fs)="[$]OBST_VAR(fs) [$]OBST_VAR(_f)"
      else
	 OBST_WARN("file \"[$]OBST_VAR(f)\" not found")
      fi
   fi
done
echo "processing configuration file(s)[$]OBST_VAR(fs)"
sed -n "s|^OBST_WS\(!\)OBST_WS\(OBST_ID\).*|\2 \1 _|p
s|^OBST_WS\(OBST_ID\)OBST_WS\([[=:]]\)OBST_WS\(.*\)|\1 \2 \3|p" $OBST_VAR(fs) /dev/null\
| { while read name sep val
    do
       vname="OBST_VAR(OBST_VARNAME([$]name))"
       OBST_VAR_DEFINED([$]vname) || {
	  case "$sep" in
	     =) OBST_SUBST([$]name,[$]val,__no-check__) ;;
	     :) OBST_DEFINE([$]name,[$]val,__no-check__);;
	  esac
	  OBST_VAR(c)=OBST_QUOTE([$]vname,[$]val)
	  echo "[$]OBST_VAR(c)" >> [$]OBST_VAR(tmpf); eval "[$]OBST_VAR(c)"
       }
    done
    echo "OBST_SUBST_VAR='[$]OBST_SUBST_VAR'
OBST_SUBST_VAR[_]=[$]OBST_SUBST_VAR[_]
DEFS='$DEFS'
SEDDEFS='$SEDDEFS'" >> [$]OBST_VAR(tmpf)
  }
eval "`cat [$]OBST_VAR(tmpf)`"
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_EXPAND_INSTMACROS()
dnl	Defines substitutions for the expanded versions of @libdir@,
dnl	@cntdir@, @tcllibdir@, and @includedir@, which are named @libdir_exp@,
dnl	@cntdir_exp@, @tcllibdir_exp@, and @includedir_exp@, respectively.
dnl....................................................................
define(OBST_EXPAND_INSTMACROS,[dnl
test -n "$exec_prefix" || exec_prefix="$OBST_VAR(exec_prefix)"
test -n "$prefix" || prefix="$OBST_VAR(prefix)"
echo > $OBST_VAR(tmpf) "
prefix=$prefix
exec_prefix=$exec_prefix
cntdir=$OBST_VAR(cntdir)
libdir=$OBST_VAR(libdir)
tcllibdir=$OBST_VAR(tcllibdir)
includedir=$OBST_VAR(includedir)
_dummy_target: ;@echo 'OBST_VAR(libdir_exp)=\$(libdir);OBST_VAR(cntdir_exp)=\$(cntdir);OBST_VAR(tcllibdir_exp)=\$(tcllibdir);OBST_VAR(includedir_exp)=\$(includedir)'"
eval `make -f $OBST_VAR(tmpf)`
OBST_SUBST(libdir_exp,$OBST_VAR(libdir_exp),__no-check__)dnl
OBST_SUBST(cntdir_exp,$OBST_VAR(cntdir_exp),__no-check__)dnl
OBST_SUBST(tcllibdir_exp,$OBST_VAR(tcllibdir_exp),__no-check__)dnl
OBST_SUBST(includedir_exp,$OBST_VAR(includedir_exp),__no-check__)])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_OUTPUT(<file>...,<add_commands>=NULL)
dnl	Variant of AC_OUTPUT(<file>...) which accounts for OBST_SUBST.
dnl	If the 2nd argument is defined, its contents are appended to
dnl	config.status.
dnl	Any files with pathprefix $<.>tmpf are removed.
dnl	If OBST_OUTPUT_NAMES is defined, then the first argument is ignored
dnl	and the value of OBST_OUTPUT_NAMES is used instead.
dnl
dnl OBST_SPLIT_AT(<file>,<regexpr>,<file2>)
dnl	Splits <file> at the first line matching <regexpr>, writes
dnl	the first part back to <file> and the remainder to <file2>.
dnl
dnl OBST_UNDEF(<file>)
dnl	Replaces all occurences of UNDEF by undef in <file>.
dnl
dnl OBST_SCRIPTS(<file>...)
dnl	For all files in the (whitespace separated) argument list: they are
dnl	made executable and a first line '#!/bin/sh' gets prepended.
dnl
dnl	*** OBST_SPLIT_AT, OBST_UNDEF must be used as arguments to
dnl	    OBST_APPEND_CMDS.
dnl....................................................................
define(OBST_OUTPUT,[dnl
test -n "$exec_prefix" || exec_prefix="$OBST_VAR(exec_prefix)"
test -n "$prefix" || prefix="$OBST_VAR(prefix)"
OBST_IF_PROVIDED([OBST_SUBST],
[divert(1)dnl
[$]OBST_SUBST_VAR
divert(2)dnl
OBST_SUBST_VAR='[$]OBST_SUBST_VAR'
divert(0)dnl
])dnl
AC_OUTPUT(ifdef([OBST_OUTPUT_NAMES],[OBST_OUTPUT_NAMES],[$1]),[$2])dnl
rm -rf [$]OBST_VAR(tmpf)*
])dnl
define(OBST_SPLIT_AT,[dnl
OBST_VAR(tmpf)=/tmp/conf$$ig
echo "creating $3"
sed -e '$2[[,]]\[$]w $3' -e '$2[[,]]\[$]d' $1 >[$]OBST_VAR(tmpf)
rm -f $1;cp [$]OBST_VAR(tmpf) $1;rm -f [$]OBST_VAR(tmpf)
])dnl
define(OBST_UNDEF,[dnl
OBST_VAR(tmpf)=/tmp/conf$$ig
cp $1 [$]OBST_VAR(tmpf);rm -f $1;sed 's|UNDEF|undef|' [$]OBST_VAR(tmpf) >$1
rm -f [$]OBST_VAR(tmpf)
])dnl
define(OBST_SCRIPTS,[dnl
OBST_VAR(tmpf)=/tmp/conf$$ig
for OBST_VAR(f) in $1 ""
do test -f "$OBST_VAR(f)" && {
      cp "$OBST_VAR(f)" [$]OBST_VAR(tmpf);rm -f "$OBST_VAR(f)"
      echo '[#]!/bin/sh' | cat - [$]OBST_VAR(tmpf) > "$OBST_VAR(f)"
      chmod a+x "$OBST_VAR(f)"
   }
done
rm -f [$]OBST_VAR(tmpf)
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_DIRNAME(<path>)
dnl	Strips the last part from <path>.
dnl....................................................................
define(OBST_DIRNAME,[changequote(,)dnl
`echo $1|sed 's|/[^/]*$||'`dnl
changequote([,])])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_SHAREDOBJ(<defnm>,<deffile>,<lib.sa>,<rtlpath>)
dnl	Sets those options wrt. shared objects which are unique to each
dnl	OBST application.
dnl	<defnm> and <deffile> are the name of the #define giving a version
dnl	number, and its file, respectively.
dnl	<lib.sa> gives the name of the static addendum to the shared
dnl	object if such an archive is to exist.
dnl	<rtlpath> gives the path to register for the run time linker.
dnl	The directory $(srcdir)/lib/pic is created if it does not yet exist.
dnl....................................................................
define(OBST_SHAREDOBJ,[dnl
OBST_IF_PROVIDED([OBST_ITSELF],,
OBST_VAR(f)=$OBST_VAR(OBSTINC)/etc/obst_common.mk
if test -r "$OBST_VAR(f)"; then
   OBST_VAR(shSUFF_sa)="[OBST_GET_MACRO(shSUFF.sa,$OBST_VAR(f))]"
   OBST_VAR(LD_DO_RTLPATH)="[OBST_GET_MACRO(LD_DO_RTLPATH,$OBST_VAR(f))]"
   OBST_VAR(shVERSIONSEP)="[OBST_GET_MACRO(shVERSIONSEP,$OBST_VAR(f))]"
else
   OBST_WARN("can't read file \"$OBST_VAR(f)\"")
fi
)changequote(,)dnl
[ -n "$OBST_VAR(shVERSION)" ] || {
   v=
   [ -z "$OBST_VAR(shVERSIONSEP)" ] || \
changequote([,])dnl
      v="$OBST_VAR(shVERSIONSEP)[]OBST_GET_DEFINE($1,$2)$OBST_VAR(shVERSIONSEP)"0
   OBST_SUBST(shVERSION,$v,__no-check__)dnl
}
changequote(,)dnl
[ -n "$OBST_VAR(localLIB_sa)" ] || {
   v=
   [ -z "$OBST_VAR(shSUFF_sa)" ] || v='$3'
changequote([,])dnl
   OBST_SUBST(localLIB.sa,$v,__no-check__)dnl
}
changequote(,)dnl
[ -n "$OBST_VAR(shLDFLAGS)" ] || {
   v=
   [ -z "$OBST_VAR(LD_DO_RTLPATH)" ] || v='$(LD_DO_RTLPATH)$4'
changequote([,])dnl
   OBST_SUBST(shLDFLAGS,$v,__no-check__)dnl
}
test -d "$srcdir/lib/pic" || mkdir "$srcdir/lib/pic"
])dnl
dnl
dnl--------------------------------------------------------------------
dnl OBST_FIND_OBST(<inc.var> = NULL,<lib.var> = NULL)
dnl	Searches for OBST and defines substitutions for OBSTINC, OBSTLIB
dnl	accordingly - if there are currently no such substitutions.
dnl	If the respective arguments are non-empty, the are to contain
dnl	the names of shell variables which hold additional paths to check
dnl	for locating OBSTINC and OBSTLIB, respectively.
dnl....................................................................
define(OBST_FIND_OBST,[AC_PROVIDE([$0])dnl
echo 'checking for OBST'
test -n "$OBST_VAR(OBSTINC)" || {
   if test -n "$SOSV_VERSION_PATH"; then
      OBST_VAR(op)=$SOSV_VERSION_PATH
ifelse([$1],,else,   elif test -z "[$]$1"; then)
      AC_PROGRAM_CHECK(OBST_VAR(op), bundle, [OBST_DIRNAME($dir)])
   fi
   OBST_FILE_CHECK(OBST_VAR(OBSTINC),obst.h,ifelse([$1],,,[$]$1 )$OBST_VAR(op)/include)
   OBST_SUBST(OBSTINC,$OBST_VAR(OBSTINC),__no-check__)dnl
}
test -n "$OBST_VAR(OBSTLIB)" || {
   if test -n "$SOSV_VERSION_PATH"; then
      OBST_VAR(op)="$SOSV_VERSION_PATH/lib/*"
   elif test -n "$OBST_VAR(OBSTINC)"; then
      OBST_VAR(op)="OBST_DIRNAME($OBST_VAR(OBSTINC))/lib"
ifelse([$2],,else,   elif test -z "[$]$2"; then)
      AC_PROGRAM_CHECK(OBST_VAR(op), bundle, [OBST_DIRNAME($dir)])
      OBST_VAR(op)="$OBST_VAR(op)/lib"
   fi
   OBST_FILE_CHECK(OBST_VAR(OBSTLIB),libOBST.*,ifelse([$2],,,[$]$2 )$OBST_VAR(op))
   OBST_SUBST(OBSTLIB,$OBST_VAR(OBSTLIB),__no-check__)dnl
}])dnl
