#ifndef _CCI_EXT_H
#define _CCI_EXT_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include "knl_ext.h"

// *****************************  cci_Fun  *********************************

typedef sos_Object  (*cci_str2obj_fun)(const sos_Cstring);
typedef sos_Cstring (*cci_obj2str_fun)(const sos_Object&);

typedef sos_Object (*cci_Fun)(const sos_Object&, const sos_Object_Array&);

#define CCI_FUN_SIZE 4
inline void bcopy_from_cci_Fun (register void* f, register void* c)
{  *(cci_Fun *)c = *(cci_Fun *)f; }
inline void bcopy_to_cci_Fun (register void* f, register void* c)
{  *(cci_Fun *)f = *(cci_Fun *)c; }
sos_Cstring make_string_from_cci_Fun_object (const sos_Object&);
sos_Object  make_cci_Fun_object_from_string (const sos_Cstring);


// ****************** general universal accessor functions *****************

sos_Object _cci_univ_assign     (const sos_Object&, const sos_Object_Array&);
sos_Object _cci_univ_clone      (const sos_Object&, const sos_Object_Array&);
sos_Object _cci_univ_destroy    (const sos_Object&, const sos_Object_Array&);
sos_Object _cci_univ_equal      (const sos_Object&, const sos_Object_Array&);
sos_Object _cci_univ_hash_value (const sos_Object&, const sos_Object_Array&);


// ********************** function table management ************************

#define _cci_ext2obj_key(id)	sos_Id::make((id).container(),(id).offset()+2)
#define _cci_obj2ext_key(id)	sos_Id::make((id).container(),(id).offset()+3)
#define _cci_str2obj_key(id)	(id)
#define _cci_obj2str_key(id)	sos_Id::make((id).container(),(id).offset()+1)

extern cci_Impl_obj _cci_lookup_impl_obj(const sos_Id&, const sos_Id&);
extern cci_Impl_obj _cci_get_impl_obj   (const sos_Id&, const sos_Id&);
extern void	    _cci_enter_impl_obj (const sos_Id&, const sos_Id&,
					 cci_Impl_obj);
extern cci_Fun	    _cci_get_fun   (const sos_Id&);
extern void	    _cci_enter_fun (const sos_Id&, cci_Fun);

#endif
