/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#include "timer.h"

extern Timer_t _null, _one, _one_2, _one_8, _two_3, _two_8;

#define PR(t) tmr_print(t)

void test_ops_C()
{  printf ("0.0: ");		     PR (_null);
   printf ("\n-0.0: ");		     PR (tmr_negate (_null));
   printf ("\n1.2: ");		     PR (_one_2);
   printf ("\n-1.2: ");		     PR (tmr_negate (_one_2));

   printf ("\n1.2+2.3 (3.5): ");     PR (tmr_add (_one_2, _two_3));
   printf ("\n1.2+1.8 (3.0): ");     PR (tmr_add (_one_2, _one_8));
   printf ("\n2.3+1.8 (4.1): ");     PR (tmr_add (_two_3, _one_8));

   printf ("\n(-1.2)-2.3 (-3.5): "); PR (tmr_sub (tmr_negate(_one_2), _two_3));
   printf ("\n(-1.2)-1.8 (-3.0): "); PR (tmr_sub (tmr_negate(_one_2), _one_8));
   printf ("\n(-2.3)-1.8 (-4.1): "); PR (tmr_sub (tmr_negate(_two_3), _one_8));

   printf ("\n(-2.3)-1.2 (-3.5): "); PR (tmr_sub (tmr_negate(_two_3), _one_2));
   printf ("\n(-1.8)-1.2 (-3.0): "); PR (tmr_sub (tmr_negate(_one_8), _one_2));
   printf ("\n(-1.8)-2.3 (-4.1): "); PR (tmr_sub (tmr_negate(_one_8), _two_3));

   printf ("\n(-1.2)+2.3 (1.1): ");  PR (tmr_add (tmr_negate(_one_2), _two_3));
   printf ("\n(-1.2)+1.8 (0.6): ");  PR (tmr_add (tmr_negate(_one_2), _one_8));
   printf ("\n(-2.3)+1.8 (-0.5): "); PR (tmr_add (tmr_negate(_two_3), _one_8));

   printf ("\n(-2.3)+1.2 (-1.1): "); PR (tmr_add (tmr_negate(_two_3), _one_2));
   printf ("\n(-1.8)+1.2 (-0.6): "); PR (tmr_add (tmr_negate(_one_8), _one_2));
   printf ("\n(-1.8)+2.3 (0.5): ");  PR (tmr_add (tmr_negate(_one_8), _two_3));

   printf ("\n1.2-2.3 (-1.1): ");    PR (tmr_sub (_one_2, _two_3));
   printf ("\n1.2-1.8 (-0.6): ");    PR (tmr_sub (_one_2, _one_8));
   printf ("\n2.3-1.8 (0.5): ");     PR (tmr_sub (_two_3, _one_8));

   printf ("\n");
}

#define RUNS 100000
void time_timer_C()
{  int i;
   Timer_t start = tmr_new(),
	   end   = tmr_new(),
	   dummy = tmr_new(),
	   pure_loop, duration;
   
   tmr_read_timer (start);
   for (i = RUNS; i > 0; -- i)
      ;
   tmr_read_timer (end);

   pure_loop = tmr_sub (end, start);

   tmr_read_timer (start);
   for (i = RUNS; i > 0; -- i)
      tmr_read_timer (dummy);
   tmr_read_timer (end);

   duration = tmr_sub (tmr_sub (end, start), pure_loop);

   printf ("Timer call: ca. ");
   tmr_print_time (duration, TP_WALLCLOCK);
   printf (" (%d calls)  --> ", (int)RUNS);
   tmr_write_duration (duration, (int)RUNS, " [s/call]\n", TP_WALLCLOCK);
}
