/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include "obst.h"
#include "smg.h"
#include "mta_use.h"

#include "test_use.h"
#include "c2obst.h"
#include "timer.h"
#include "../interface/_tclOBST.h"

externC void print_obj (char*, sos_Object);	// in test_schemas.C

Tcl_Interp* testip;
int	    RUNS;

#ifdef PROFILE
sos_Bool    use_eager_binding = TRUE;

extern "C" int moncontrol (int);
#endif


// --------------------------------------------------------------------------

#ifdef PROFILE
#  define INIT_SEQUENCE()      int i
#  define TIMER_LOOP(var,body) for (i = RUNS;  i --; ){ body }

#else
#  define INIT_SEQUENCE() \
      Timer start, end; int i; \
      start.read_timer(); for (i = RUNS;  i --; ); end.read_timer();\
      Timer pure_loop = (end - start)

#  define TIMER_LOOP(var,body)\
      start.read_timer(); for (i = RUNS;  i --; ){ body } end.read_timer();\
      Timer var = (end - start) - pure_loop

#  define START_OUTPUT() \
   cout << "\nloop, " << RUNS << " runs, pure: " << pure_loop
#endif

void empty_function ()
{
}

inline int EVAL_TclCmd (char* cmd)
{  return TCL_EVAL (testip, cmd);
}

void eval_TclCmd (smg_String _cmd)
{  char *cmd = _cmd.make_Cstring (SMG_BORROW);

   cout << "eval_TclCmd.1: |" << cmd << "|\n";

   int res = EVAL_TclCmd(cmd);

   cout << "eval_TclCmd.2: |" << testip->result << "|\n"
	<< "               |";
   if (res == TCL_OK)
      cout << "TCL_OK|\n";
   else if (res == TCL_ERROR)
      cout << "TCL_ERROR|\n";
   else
      cout << res << "?|\n";
}

void print_process_resources()
{
   struct rusage ru;
   getrusage(RUSAGE_SELF, &ru);

   cout << "RESOURCES: minflt(" << ru.ru_minflt
	<< ") majflt(" << ru.ru_majflt
	<< ") nswap(" << ru.ru_nswap
	<< ") inblock(" << ru.ru_inblock
	<< ") outblock(" << ru.ru_oublock
	<< ") nsignals(" << ru.ru_nsignals
	<< ") nvcsw(" << ru.ru_nvcsw
	<< ") nivcsw(" << ru.ru_nivcsw
	<< ")\n";
}


// --------------------------------------------------------------------------

void test_conversion (sos_Object some_o, char* title)
{  sos_Object some_o_again;
   char*      some_o_str;
   int	      scalar = (some_o != NO_OBJECT  &&  some_o.type().is_scalar());

   print_obj (title, some_o);

   some_o_str = t2o_OBJ2STR (&some_o, NULL, scalar);
   cout << "Codestring: " << some_o_str << "\n";

   t2o_str2obj (&some_o_again, some_o_str);
   print_obj (title, some_o_again);
}

void test_conversions()
{  t2o_current_ip = t2o_get_ipdata (testip, FALSE);

   test_conversion (sos_Directory::root(), "root directory");
   test_conversion (NO_OBJECT,		   "NO_OBJECT");

   sos_Object scalar;
   test_conversion (scalar = make_sos_Int_object (1234), "Int(1234)");
   test_conversion (scalar = make_sos_Int_object (0),    "Int(0)");
}

// --------------------------------------------------------------------------

void test_refparams()
{  sos_Object oargv[3];

   print_obj ("[1.1 / p1]", oargv[0] = make_sos_Int_object (2101));
   print_obj ("[1.1 / p2]", oargv[1] = make_sos_Int_object (2102));
   obst_call_classmethod ("TestC", "ref2_1", 2, oargv);
   print_obj ("[1.2 / p1]", oargv[0]);
   print_obj ("[1.2 / p2]", oargv[1]);

   cout << "\n";
   print_obj ("[2.1 / p1]", oargv[0] = make_sos_Int_object (2201));
   print_obj ("[2.1 / p2]", oargv[1] = make_sos_Int_object (2202));
   obst_call_classmethod ("TestC", "ref2_2", 2, oargv);
   print_obj ("[2.2 / p1]", oargv[0]);
   print_obj ("[2.2 / p2]", oargv[1]);

   cout << "\n";
   print_obj ("[3.1 / p1]", oargv[0] = make_sos_Int_object (31201));
   print_obj ("[3.1 / p2]", oargv[1] = make_sos_Int_object (31202));
   print_obj ("[3.1 / p3]", oargv[2] = make_sos_Int_object (31203));
   obst_call_classmethod ("TestC", "ref3_12", 3, oargv);
   print_obj ("[3.2 / p1]", oargv[0]);
   print_obj ("[3.2 / p2]", oargv[1]);
   print_obj ("[3.2 / p3]", oargv[2]);

   char       *int_101, *int_333, *void_tp, *rootobj;
   smg_String mcpref = "mcall TestC::ref", set_a;
   sos_Object obj;

   t2o_current_ip = t2o_get_ipdata (testip, FALSE);

   obj = make_sos_Int_object(101); int_101 = t2o_OBJ2STR (&obj, NULL, TRUE);
   obj = make_sos_Int_object(333); int_333 = t2o_OBJ2STR (&obj, NULL, TRUE);
   obj = void_type;		   void_tp = t2o_OBJ2STR (&obj, NULL, FALSE);
   obj = sos_Directory::root();	   rootobj = t2o_OBJ2STR (&obj, NULL, FALSE);

   set_a = smg_String("set _a ") + int_333 + "; ";

   cout << "\n\neval_TclCmd.0: set _a `333'; TestC::ref2_1 _a `101'\n";
   eval_TclCmd (set_a + mcpref  + "2_1 _a " + int_101);
   eval_TclCmd ("set _a");

   cout << "\n\neval_TclCmd.0: set _a `333'; TestC::ref2_1 `101' _a\n";
   eval_TclCmd (set_a + mcpref  + "2_1 " + int_101 + " _a");

   cout << "\n\neval_TclCmd.0: set _a `333'; TestC::ref2_2 `101' _a\n";
   eval_TclCmd (set_a + mcpref  + "2_2 " + int_101 + " _a");

   cout << "\n\neval_TclCmd.0: set _a `333'; set _b `rootobj'; "
	<< "TestC::ref3_12 _a `void_type' _b\n";
   eval_TclCmd (set_a + "set _b " + rootobj + "; " 
		+ mcpref  + "3_12 _a " + void_tp + " _b");
   eval_TclCmd ("set _a");
   eval_TclCmd ("set _b");
}

// --------------------------------------------------------------------------

void test_unions()
{  TestU      un = 55555;
   sos_Object oargv[1], res;

   print_obj ("[get_u / p1]", oargv[0] = un);
   res = obst_call_classmethod ("TestC", "get_u", 1, oargv);
   print_obj ("[get_u / res]", res);

   t2o_current_ip = t2o_get_ipdata (testip, FALSE);

   char *i5555 = t2o_OBJ2STR (&un, NULL, FALSE);

   eval_TclCmd (smg_String("set a [mcall TestC::get_u ") + i5555 + "]");
   eval_TclCmd ("mcall [mcall [mcall [set a] type] get_name] make_Cstring");
}

// --------------------------------------------------------------------------

void time_str_conversions()
{  sos_Object scobj;
   char	      *entype = "sos_Container_status",
      	      *enstr  = "DESTROYED",
      	      *extype = "sos_Int",
      	      *exstr  = "1324",
      	      *_str;
   int	      _en, enval = DESTROYED;
   sos_Int    _ex, exval = 1234;

   INIT_SEQUENCE();

   TIMER_LOOP(durSc2Obj,  scobj = obst_scalar2object (entype, &enval););
   TIMER_LOOP(durObj2Sc, 	  obst_object2scalar (&scobj, &_en););

   TIMER_LOOP(durEn2Obj,  scobj = obst_enum2object (entype, enval););
   TIMER_LOOP(durObj2En,  _en   = obst_object2enum (&scobj););

   TIMER_LOOP(durStr2Obj, scobj = obst_string2object (entype, enstr););
   TIMER_LOOP(durObj2Str, _str  = obst_object2string (&scobj););

   TIMER_LOOP(durStr2Sc, 	  obst_string2scalar (entype, enstr, &_en););
   TIMER_LOOP(durSc2Str,  _str  = obst_scalar2string (entype, &enval););


   TIMER_LOOP(durEx2Obj,    scobj = obst_scalar2object (extype, &exval););
   TIMER_LOOP(durObj2Ex, 	    obst_object2scalar (&scobj, &_ex););

   TIMER_LOOP(durExStr2Obj, scobj = obst_string2object (extype, exstr););
   TIMER_LOOP(durObj2ExStr, _str  = obst_object2string (&scobj););

   TIMER_LOOP(durStr2Ex, 	    obst_string2scalar (extype, exstr, &_ex););
   TIMER_LOOP(durEx2Str,    _str  = obst_scalar2string (extype, &exval););

#ifndef PROFILE
   START_OUTPUT() << "\nscalar2object (enum)  : " << durSc2Obj
      		  << "\nobject2scalar (enum)  : " << durObj2Sc
		  << "\nenum2object   (enum)  : " << durEn2Obj
		  << "\nobject2enum   (enum)  : " << durObj2En
		  << "\nstring2object (enum)  : " << durStr2Obj
		  << "\nobject2string (enum)  : " << durObj2Str
		  << "\nstring2scalar (enum)  : " << durStr2Sc
		  << "\nscalar2string (enum)  : " << durSc2Str
		  << "\nscalar2object (extern): " << durEx2Obj
      		  << "\nobject2scalar (extern): " << durObj2Ex
		  << "\nstring2object (extern): " << durExStr2Obj
		  << "\nobject2string (extern): " << durObj2ExStr
		  << "\nstring2scalar (extern): " << durStr2Ex
		  << "\nscalar2string (extern): " << durEx2Str
		  << "\n";
#endif
}

// --------------------------------------------------------------------------

void time_obj_coding ()
{  sos_Object dir  = sos_Schema_module::schema_dir(),
      	      int1 = make_sos_Int_object(1),
      	      dummy;
   char	      buf[100];

   INIT_SEQUENCE();
   t2o_current_ip = t2o_get_ipdata (testip, FALSE);

   TIMER_LOOP(durClStr, t2o_OBJ2STR(&dir,   buf, FALSE););
   TIMER_LOOP(durStrCl, t2o_str2obj(&dummy, buf););

   TIMER_LOOP(durScStr, t2o_OBJ2STR(&int1,  buf, TRUE););
   TIMER_LOOP(durStrSc, t2o_str2obj(&dummy, buf););

   TIMER_LOOP(durCopy, dummy = int1;);

#ifndef PROFILE
   START_OUTPUT() << "\nclass object  --> string: " << durClStr
		  << "\nscalar object --> string: " << durScStr
		  << "\nstring --> class object : " << durStrCl
		  << "\nstring --> scalar object: " << durStrSc
		  << "\ncopy object             : " << durCopy
		  << "\n";
#endif
}

// --------------------------------------------------------------------------

void loop_Cpp ()
{  sos_Schema_module_Directory sdir = sos_Schema_module::schema_dir();

   agg_iterate_association (sdir, sos_String s, sos_Schema_module sm)
      sos_String str = sm.get_name();
   agg_iterate_association_end (sdir, s, sm);
}

void loop_Tcl ()
{  EVAL_TclCmd ("agg loop [mcall sos_Schema_module::schema_dir] {set s [mcall [agg current role2] get_name]}");
}

void loop_C ()
{  sos_Object sdir = obst_vcall_classmethod ("sos_Schema_module",
					     "schema_dir", 0);
   obst_iterate (&sdir)
      sos_Object obj, name;

      obj  = obst_iterate_role2();
      name = obst_vcall_method (&obj, "get_name", 0);
   obst_iterate_end (&sdir);
}


void time_loops ()
{  INIT_SEQUENCE();

   loop_Cpp();   TIMER_LOOP(durCpp,     loop_Cpp(););
   loop_Tcl();   TIMER_LOOP(durTcl_on,  loop_Tcl(););

   t2o_customize (testip, t2o_ObjCmdStr, "FALSE");

   loop_Tcl();   TIMER_LOOP(durTcl_off, loop_Tcl(););

   t2o_customize (testip, t2o_ObjCmdStr, "TRUE");

   loop_C();     TIMER_LOOP(durCon, 	loop_C(););

   c2obst_ctrls.check_args    = FALSE;
   c2obst_ctrls.catch_syserrs = FALSE;

   loop_C();     TIMER_LOOP(durCoff, 	loop_C(););

   c2obst_ctrls.check_args    = TRUE;
   c2obst_ctrls.catch_syserrs = TRUE;

   TIMER_LOOP(durFoo, empty_function(););

#ifndef PROFILE
   START_OUTPUT() << "\nC++ loop                  : " << durCpp
		  << "\nTcl loop, eager binding   : " << durTcl_on
		  << "\nTcl loop, no eager binding: " << durTcl_off
		  << "\nC loop, checks on         : " << durCon
		  << "\nC loop, checks off        : " << durCoff
		  << "\nempty function            : " << durFoo
		  << "\n";
#endif
}

// --------------------------------------------------------------------------

void DoSet_Cpp ()
{  sos_Object_Set os = sos_Object_Set::create (TEMP_CONTAINER);
   os.destroy();
}

void DoSet_TclDflts ()
{  EVAL_TclCmd ("mcall [mcall sos_Object_Set::create 0] destroy");
}

void DoSet_TclNoDflts ()
{  EVAL_TclCmd ("mcall [mcall sos_Object_Set::create 0 TRUE FALSE AGG_AUTOMATIC] destroy");
}

void DoSet_CDflts ()
{  static sos_Object ct = obst_cnt2obj (TEMP_CONTAINER);

   sos_Object obj = obst_vcall_classmethod ("sos_Object_Set", "create", 1, ct);
   obst_vcall_method (&obj, "destroy", 0);
}


void time_sets ()
{  INIT_SEQUENCE();

   DoSet_Cpp();        TIMER_LOOP(durCpp,        DoSet_Cpp(););
   DoSet_TclNoDflts(); TIMER_LOOP(durTcl_on,     DoSet_TclNoDflts(););
   DoSet_TclDflts();   TIMER_LOOP(durTcl_onDflt, DoSet_TclDflts(););

   t2o_customize (testip, t2o_ObjCmdStr, "FALSE");

   DoSet_TclNoDflts();   TIMER_LOOP(durTcl_off, DoSet_TclNoDflts(););

   t2o_customize (testip, t2o_ObjCmdStr, "TRUE");

   DoSet_CDflts();  TIMER_LOOP(durCon, DoSet_CDflts(););

   c2obst_ctrls.check_args    = FALSE;
   c2obst_ctrls.catch_syserrs = FALSE;

   DoSet_CDflts();  TIMER_LOOP(durCoff, DoSet_CDflts(););

   c2obst_ctrls.check_args    = TRUE;
   c2obst_ctrls.catch_syserrs = TRUE;

   TIMER_LOOP(durFoo, empty_function(););

#ifndef PROFILE
   START_OUTPUT() << "\nC++ code                     : " << durCpp
		  << "\nTcl code, eager binding, Dflt: " << durTcl_onDflt
		  << "\nTcl code, eager binding      : " << durTcl_on
		  << "\nTcl code, no eager binding   : " << durTcl_off
		  << "\nC code, checks on            : " << durCon
		  << "\nC code, checks off           : " << durCoff
		  << "\nempty function               : " << durFoo
		  << "\n";
#endif
}

// --------------------------------------------------------------------------

#define access_Cpp() _dummy=named_obj.get_name()
#define access_C()   _dummy=obst_vcall_method (&obj, "get_name", 0)
#define access_Tcl() EVAL_TclCmd (tcl_cmd)
#define init_Tcl()   EVAL_TclCmd ("set dir [mcall sos_Schema_module::schema_dir]"); \
		     smg_String _cmd = smg_String("set s [mcall ") \
				       + Tcl_GetVar (testip, "dir", 0) \
				       + " get_name]"; \
		     char* tcl_cmd = _cmd.make_Cstring(SMG_BORROW)


void time_comp_access ()
{  
   INIT_SEQUENCE();
   init_Tcl();

   sos_Object _dummy;
   sos_Named  named_obj = sos_Schema_module::schema_dir();
   sos_Object obj 	= named_obj;


   access_Cpp();   TIMER_LOOP(durCpp,     access_Cpp(););

   access_Tcl();   TIMER_LOOP(durTcl_on,  access_Tcl(););

   t2o_customize (testip, t2o_ObjCmdStr, "FALSE");

   access_Tcl();   TIMER_LOOP(durTcl_off, access_Tcl(););

   t2o_customize (testip, t2o_ObjCmdStr, "TRUE");

   access_C();     TIMER_LOOP(durCon,	  access_C(););

   c2obst_ctrls.check_args    = FALSE;
   c2obst_ctrls.catch_syserrs = FALSE;

   access_C();     TIMER_LOOP(durCoff,	  access_C(););

   c2obst_ctrls.check_args    = TRUE;
   c2obst_ctrls.catch_syserrs = TRUE;

#ifndef PROFILE
   START_OUTPUT() << "\nC++ access                  : " << durCpp
		  << "\nTcl access, eager binding   : " << durTcl_on
		  << "\nTcl access, no eager binding: " << durTcl_off
		  << "\nC access, checks on         : " << durCon
		  << "\nC access, checks off        : " << durCoff
		  << "\n";
#endif
}

// --------------------------------------------------------------------------

int main (int argc, char *argv[])
{  obst_init (argc, argv);

   t2o_BindDefs (testip = Tcl_CreateInterp(), TRUE);

   int choice;

#ifdef PROFILE
   moncontrol(0);

   choice = atoi (argv[1]);
   RUNS   = atoi (argv[2]);

   if (argc > 3)
      use_eager_binding = (sos_Bool)(argv[3][0] == '+');

   moncontrol(1);
#else
   do
   {  cout << "\n\n\t[1] test conversions\n\t[2] test reference parameters\n\t[3] test unions\n\t[4] time string conversions\n\t[5] time object coding\n\t[6] time loops\n\t[7] time set creation/destruction\n\t[8] time component access\n\t[0] quit\n\n\t--> ";
      cin  >> choice;

      if (choice > 3)
      {  cout << "runs: ";  cin >> RUNS;
      }
#endif
   
      switch (choice)
      {  case 1: test_conversions();	 break;
	 case 2: test_refparams();	 break;
	 case 3: test_unions();		 break;
	 case 4: time_str_conversions(); break;
	 case 5: time_obj_coding();	 break;
         case 6: time_loops();		 break;
	 case 7: time_sets();		 break;
	 case 8: time_comp_access();	 break;
      }

#ifdef PROFILE
   moncontrol(0);
#else
   }
   while (choice);
#endif
   return 0;
}
