/* AppMain.C
 *
 * Modified version of tkAppInit.c from the Tk 3.3b3 distribution.
 * ---------------------------------------------------------------------------
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <math.h>
#include <tcl.h>
#ifdef TK_EXTENDED
#  include <tclExtend.h>
#endif
#ifdef TK
#  include <tk.h>
#endif
#include "t2oShells.h"
#include "obst.h"

/* --------------------------------------------------------------------------
 * Insert the application specific initialization.
 */
#include "t2o_init.h"
/* --------------------------------------------------------------------------
 */

#ifdef TK
#  ifdef TK_EXTENDED
#     define __MAIN 		TkX_Wish
#     define __TKINIT		TkX_Init
#     define __FILE		"~/.tclrc"
#  else
#     define __MAIN 		tkMain
#     define __TKINIT		Tk_Init
#     define __FILE		"~/.wishrc"
#  endif
#else
#  ifdef TK_EXTENDED
#     define __MAIN 		TclX_Shell
#     define __FILE		"~/.tclrc"
#  else
#     define __MAIN 		tclMain
#     define __FILE		"~/.tclshrc"
#  endif
#endif
#ifdef TK_EXTENDED
#  define __TCLINIT		TclX_Init
#  ifdef t2o_TCLX_APPINIT
#     define __INIT_FCT		TclX_AppInit
#  else
#     define __INIT_FCT		Tcl_AppInit
#  endif
#  ifdef t2o_TCLX_intMain
#     define __int_MAIN
#  endif
#else
#  define __TCLINIT		Tcl_Init
#  define __INIT_FCT		Tcl_AppInit
#endif

#if    defined(TK_EXTENDED) && defined(t2o_TCLX_OLDSTYLE)\
    || TCL_MAJOR_VERSION < 7
#  undef __FILE
#  undef __TKINIT
#  undef __TCLINIT
#endif

/*
 * The following variable is a special hack that insures the tcl
 * version of matherr() is used when linking against shared libraries.
 * Only define the matherr if it seems to be in math.h.
 */
#ifdef HAVE_MATHERR
#  ifdef VARARGS
EXTERN int matherr VARARGS;
#  else
EXTERN int matherr ();
#  endif
int *tclDummyMathPtr = (int *) matherr;
#endif


#ifdef __int_MAIN
EXTERN int __MAIN _ANSI_ARGS_((int, char**));
#else
EXTERN void __MAIN _ANSI_ARGS_((int, char**));
#endif

int main (int argc, char* argv[])
{  obst_init (argc, argv);

#ifdef __int_MAIN
   return __MAIN (argc, argv);
#else
   __MAIN (argc, argv);
   return 0;
#endif
}


/*
 *----------------------------------------------------------------------
 *
 * Tcl(X)_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
__INIT_FCT(Tcl_Interp *interp) /* Interpreter for application. */
{
#ifdef __TCLINIT
   if (__TCLINIT(interp) == TCL_ERROR) {
      return TCL_ERROR;
   }
#endif
#ifdef __TKINIT
   if (__TKINIT(interp) == TCL_ERROR) {
      return TCL_ERROR;
   }
#endif
   /*
    * Call Tcl_CreateCommand for application-specific commands, if
    * they weren't already created by the init procedures called above.
    */
   if (t2o_AppInit(interp) == TCL_ERROR)
      return TCL_ERROR;

   /*
    * Specify a user-specific startup file to invoke if the application
    * is run interactively.  Typically the startup file is "~/.apprc"
    * where "app" is the name of the application.  If this line is deleted
    * then no user-specific startup file will be run under any conditions.
    */
#ifdef __FILE
   tcl_RcFileName = __FILE;
#endif
    return TCL_OK;
}
