#ifndef __TCLOBST_H
#define __TCLOBST_H
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 *
 * --------------------------------------------------------------------------
 * Internal interface definitions for the Tcl --> OBST Interface.
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 2/3/93
 * --------------------------------------------------------------------------
 */
#include "tclOBST.h"
#include "_t2oconf.h"

#ifdef __cplusplus
extern "C" {
#endif


/* ----- Compatibility Macros for Tcl Versions ---------------------------- */

#if TCL_MAJOR_VERSION < 7
#  define TCL_EVAL(ip,cmd)		Tcl_Eval(ip,cmd,0,NULL)
#  define TCL_APPEND_ELEMENT(ip,str)	Tcl_AppendElement(ip,str,0)
#else
#  define TCL_EVAL(ip,cmd)		Tcl_Eval(ip,cmd)
#  define TCL_APPEND_ELEMENT(ip,str)	Tcl_AppendElement(ip,str)
#endif


/* ----- Utilities: initialization ---------------------------------------- */

extern void t2o_init();


/* ----- Utilities: Error Handling ---------------------------------------- */

extern const char* t2o_errinfo [/* enum err_class */];
extern const char* t2o_errcode [/* enum err_class */];

extern int	   t2o_error;
extern int	   t2o_handle_errors;


/* ----- Utilities: Memory Management ------------------------------------- */

extern void t2o_manage_block __FSIG_((void*, sos_Bool));


/* ----- String Encodings: Definitions ------------------------------------ */

// No string must be prefix of another string.
// The sole exception is if both strings are elements of the same variant set.

typedef enum {
   t2o_AggCmdC,		/* t2o_AggCmdStr	(The codes in this block */
   t2o_CallCmdC,	/* t2o_CallCmdStr	 must start from 0!)	 */
   t2o_CntCmdC,		/* t2o_CntCmdStr	*/
   t2o_CtrlCmdC,	/* t2o_CtrlCmdStr	*/
   t2o_UtilCmdC,	/* t2o_UtilCmdStr	*/
   t2o_ObjPrefC,	/* t2o_ObjPrefStr	*/
   t2o_ObjCmdC,		/* t2o_ObjCmdStr	*/
   t2o_AllowAbbrC,      /* t2o_AllowAbbrStr	*/
   t2o_AllowDfltC,      /* t2o_AllowDfltStr	*/
   t2o_CpCstrC,      	/* t2o_CpCstrStr	*/

   t2o_AfterC,		/* "after"		*/
   t2o_AggC,		/* "agg"		*/
   t2o_ArgcC,		/* "argc"		*/
   t2o_ArgvC,		/* "argv"		*/
   t2o_BeforeC,		/* "before"		*/
   t2o_FalseC,		/* "FALSE", "false"	*/
   t2o_ForwardC,	/* "forward", "fwd"	*/
   t2o_InsteadC,	/* "instead"		*/
   t2o_NOOBJECT_C,	/* "NO_OBJECT"		*/
   t2o_ReceiverC,	/* "receiver"		*/
   t2o_ReverseC,	/* "reverse", "rev"	*/
   t2o_Role1C,		/* "role1"		*/
   t2o_Role2C,		/* "role2"		*/
   t2o_ROOTcntC,	/* "ROOT_CONTAINER"	*/
   t2o_SYNCcntC,	/* "SYNC_CONTAINER"	*/
   t2o_TEMPcntC,	/* "TEMP_CONTAINER"	*/
   t2o_TransactionC,	/* "TRANSACTION"	*/
   t2o_TrueC,		/* "TRUE", "true"	*/
   t2o_UNUSEDcntC,	/* "UNUSED_CONTAINER"	*/

   t2o_AccessC = 64,	/* "access"		*/
   t2o_BindC,		/* "bind"		*/
   t2o_CardC,		/* "card"		*/
   t2o_ClearC,		/* "clear"		*/
   t2o_CloseC,		/* "close"		*/
   t2o_CommitC,		/* "commit"		*/
   t2o_CompressC,	/* "compress"		*/
   t2o_ConstC,		/* "const"		*/
   t2o_CreateC,		/* "create"		*/
   t2o_CurrentC,	/* "current"		*/
   t2o_CustomizeC,	/* "customize"		*/
   t2o_DestroyC,	/* "destroy"		*/
   t2o_ExistsC,		/* "exists"		*/
   t2o_HasTypeC,	/* "has_type"		*/
   t2o_IsaC,		/* "isa"		*/
   t2o_IsScalarC,	/* "is_scalar"		*/
   t2o_IsSomeC,		/* "is_some"		*/
   t2o_LoopC,		/* "loop"		*/
   t2o_ModifiedC,	/* "modified"		*/
   t2o_Obj2ScalarC, 	/* "obj2scalar"		*/
   t2o_ObjectExistsC,	/* "object_exists"	*/
   t2o_ObjectSizeC,	/* "objsize"		*/
   t2o_OccupiedC,	/* "occupied"		*/
   t2o_OpenC,		/* "open"		*/
   t2o_OpenCntC,	/* "open_containers"	*/
   t2o_OpenSetsC,	/* "open_sets"		*/
   t2o_ResetC,		/* "reset"		*/
   t2o_RootObjectC,	/* "root_object"	*/
   t2o_Scalar2ObjC, 	/* "scalar2obj"		*/
   t2o_SchemasC,	/* "schemas"		*/
   t2o_SqueezeC,	/* "squeeze"		*/
   t2o_StatisticsC,	/* "statistics"		*/
   t2o_StatusC,		/* "status"		*/
   t2o_TestC,		/* "_test"		*/
   t2o_TmpStrC,		/* "tmpstr"		*/
   t2o_TraceC,		/* "trace"		*/
   t2o_TriggerC,       	/* "trigger"		*/
   t2o_TypeC, 		/* "type"		*/
   t2o_UpdateC,		/* "update"		*/
   t2o_VersionC,	/* "version"		*/

   t2o_NoCode		/* must be >0!		*/
} _t2o_StringCode;

#define t2o_LastCommand()	t2o_UtilCmdC
#define t2o_FirstOption()	t2o_AccessC
#define t2o_FirstCustom()	0
#define t2o_InvalidOption(code)	((code) < 64 || (code) >= t2o_NoCode)
#define t2o_InvalidCustom(code) ((code) < 0  || (code) >  t2o_ObjCmdC)
#define t2o_Custom2Idx(code)	(code)
#define t2o_Option2Idx(code)	((unsigned)(code) & 63)

extern void _t2o_set_strcode __FSIG_((const char*, int));
extern int  _t2o_get_strcode __FSIG_((const char*));


#define t2o_OBJPREFSTR   "object_prefix"
#define t2o_OBJCMDSTR	 "object_as_command"
#define t2o_ALLOWABBRSTR "allow_abbrevs"
#define t2o_ALLOWDFLTSTR "allow_defaults"
#define t2o_CPCSTRSTR	 "copy_Cstrings"
#define t2o_AGGCMDSTR	 "agg_command"
#define t2o_CALLCMDSTR	 "call_command"
#define t2o_CNTCMDSTR	 "cnt_command"
#define t2o_CTRLCMDSTR	 "ctrl_command"
#define t2o_UTILCMDSTR	 "util_command"


/* ----- String Encodings: variant lists ---------------------------------- */

struct t2o_OptVariant
{  const char* name;	 // name of the variant (must not be prefix of
			 // another variant with different encoding)
   int         code;	 // associated encoding (must not be t2o_NoCode)
};

struct t2o_OptVariants
{  int   	  size;			   // number of variants
   t2o_OptVariant *variants;		   // variant list
};

extern t2o_OptVariants t2o_custom_opts;    // customization options
extern t2o_OptVariants t2o_bool_opts;      // boolean options
extern t2o_OptVariants t2o_const_opts;     // OBST constants
extern t2o_OptVariants t2o_aggDirect_opts; // scan directions
extern t2o_OptVariants t2o_aggCurr_opts;   // agg current options
extern t2o_OptVariants t2o_trigger_opts;   // trigger kind options
extern t2o_OptVariants t2o_trgCurr_opts;   // trigger current options
extern t2o_OptVariants t2o_option[];	   // option table as variant list


/* ----- Utilities: Conversions ------------------------------------------- */

#if t2o_ALWAYS_CODE_TYPE
#  define t2o_OBJ2STR(p1,p2,p3)	_t2o_obj2str (p1, p2)
   extern char* _t2o_obj2str __FSIG_((const sos_Object*, char*));
#else
#  define t2o_OBJ2STR(p1,p2,p3)	_t2o_obj2str (p1, p2, p3)
   extern char* _t2o_obj2str __FSIG_((const sos_Object*, char*, int));
#endif
extern int _t2o_str2obj __FSIG_((sos_Object*, const char*));


/* ----- Interpreter Data ------------------------------------------------- */

struct t2o_InterpData
{  Tcl_Interp*	interp;
   char*	cmd_name[t2o_UtilCmdC + 1];
   char*	obj_prefix;
   int		define_obj_cmds, allow_abbrevs, allow_defaults, copy_Cstrings,
   		defs_bound;
   int		class_codelen, scalar_codelen;
   void*	loop_data;
};

extern t2o_InterpData* _t2o_current_ip;
extern int	       _t2o_active_triggers;

extern t2o_InterpData* t2o_get_ipdata __FSIG_((const Tcl_Interp*, int));


/* ----- Tcl commands: definitions ---------------------------------------- */

#define _TclCommandDecl(name) \
   int name __FSIG_((const ClientData, Tcl_Interp*, int, char*[]))

extern _TclCommandDecl (t2o_AggCmd);
extern _TclCommandDecl (t2o_CallCmd);
extern _TclCommandDecl (t2o_CntCmd);
extern _TclCommandDecl (t2o_CtrlCmd);
extern _TclCommandDecl (t2o_UtilCmd);


/* ----- Tcl commands: option table --------------------------------------- */

enum _t2o_ArgType
{  t2o_ObjCode,         		// must be encoded object (argv2obj)
   t2o_List,            		// convert into a list (t2o_list?)
   t2o_MapStr,          		// map argv[2] (argv2code)
   t2o_Nop				// do nothing wrt. argv[2]
};

struct _t2o_OptionInfo
{  const char*  name;			// name of the option
   const char*	usage;			// usage description
   int 	        cmd_code;		// associated command
   int	        min_argc,		// minimal/maximal valid value of argc
	        max_argc;		// (note: 2 args are internal)
   _t2o_ArgType	argv2_tp;		// type of argv[2]
   int	        data1, data2;		// some additional data
};

extern _t2o_OptionInfo _t2o_option_data[/* enum _t2o_StringCode */];
					// command options


#ifdef __cplusplus
}
#endif
#endif
