# --------------------------------------------------------------------------
# Copyright 1993-1994 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------
# Module: lazy_bind.tcl
# Tcl version: 7.0 (Tcl/Tk/XF)
# Tk version: 3.3
# XF version: 2.2
#

# module contents
global moduleList
global autoLoadList
set moduleList(lazy_bind.tcl) { }
set autoLoadList(lazy_bind.tcl) {0}

# procedures to show toplevel windows


# User defined procedures


# ---------
catch {rename unkown t2o_unknown}

proc unknown { cmd args } {
#
# Unkown procedure which performs lazy binding (see tclOBST documentation)
# for (tcl)OBST object handles, i.e. it will transparently execute
# `tclOBST bind <object handle>' if necessary.
#
   if {[string match "obst????????????????????????????????" $cmd]} {
      tclOBST bind $cmd
      uplevel 1 $cmd $args
   } else {
      uplevel 1 t2o_unknown $args
   }
}
