#!../../bin/wish -f
# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------
# Program: dirTool_tk
# Tcl version: 6.7 (Tcl/Tk/XF)
# Tk version: 3.2
# XF version: 2.2
#

# module inclusion
global env
global xfLoadPath
global xfLoadInfo
set xfLoadInfo 0
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) .:/usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):.:/usr/local/lib/
  } {
    set xfLoadPath .:/usr/local/lib/
  }
} {
  set xfLoadPath .:/usr/local/lib/
}



# procedure to show window ShowWindow.cpcntbox
proc ShowWindow.cpcntbox { args} {
# xf ignore me 7

  # build widget .cpcntbox
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .cpcntbox"
  } {
    catch "destroy .cpcntbox"
  }
  toplevel .cpcntbox

  # Window manager configurations
  global tkVersion
  wm positionfrom .cpcntbox ""
  wm sizefrom .cpcntbox user
  wm maxsize .cpcntbox 1000 900
  wm minsize .cpcntbox 10 10
  wm title .cpcntbox {CopyContainer}


  # build widget .cpcntbox.frame
  frame .cpcntbox.frame    -borderwidth {5}

  # build widget .cpcntbox.frame.scrollbar7
  scrollbar .cpcntbox.frame.scrollbar7    -command {.cpcntbox.frame.frame3.entry5 view}    -orient {horizontal}    -width {10}

  # build widget .cpcntbox.frame.frame3
  frame .cpcntbox.frame.frame3

  # build widget .cpcntbox.frame.frame3.entry5
  entry .cpcntbox.frame.frame3.entry5    -borderwidth {1}    -relief {raised}    -scrollcommand {.cpcntbox.frame.scrollbar7 set}    -state {disabled}    -textvariable {dir::selectedObjPath}

  # build widget .cpcntbox.frame.frame3.label4
  label .cpcntbox.frame.frame3.label4    -padx {2}    -text {object path:}

  # pack widget .cpcntbox.frame.frame3
  pack append .cpcntbox.frame.frame3     .cpcntbox.frame.frame3.label4 {left frame center}     .cpcntbox.frame.frame3.entry5 {top frame center expand fill} 

  # pack widget .cpcntbox.frame
  pack append .cpcntbox.frame     .cpcntbox.frame.frame3 {top frame center fillx}     .cpcntbox.frame.scrollbar7 {top frame center fillx} 

  # build widget .cpcntbox.frame1
  frame .cpcntbox.frame1    -borderwidth {4}

  # build widget .cpcntbox.frame1.scrollbar7
  scrollbar .cpcntbox.frame1.scrollbar7    -command {.cpcntbox.frame1.frame3.entry5 view}    -orient {horizontal}    -width {10}

  # build widget .cpcntbox.frame1.frame3
  frame .cpcntbox.frame1.frame3

  # build widget .cpcntbox.frame1.frame3.entry5
  entry .cpcntbox.frame1.frame3.entry5    -relief {raised}    -scrollcommand {.cpcntbox.frame1.scrollbar7 set}    -textvariable {dir::foreignCntDir}

  # build widget .cpcntbox.frame1.frame3.label4
  label .cpcntbox.frame1.frame3.label4    -padx {2}    -text {container directory:}

  # pack widget .cpcntbox.frame1.frame3
  pack append .cpcntbox.frame1.frame3     .cpcntbox.frame1.frame3.label4 {left frame center}     .cpcntbox.frame1.frame3.entry5 {top frame center expand fill} 

  # pack widget .cpcntbox.frame1
  pack append .cpcntbox.frame1     .cpcntbox.frame1.frame3 {top frame center fillx}     .cpcntbox.frame1.scrollbar7 {top frame center fillx} 

  # build widget .cpcntbox.frame8
  frame .cpcntbox.frame8    -borderwidth {2}

  # build widget .cpcntbox.frame8.button
  button .cpcntbox.frame8.button    -command {dir::do_copy_container}    -padx {2}    -text {  OK  }

  # build widget .cpcntbox.frame8.button9
  button .cpcntbox.frame8.button9    -command {DestroyWindow[SymbolicName dir::CopyCntBox]}    -text { Cancel }

  # pack widget .cpcntbox.frame8
  pack append .cpcntbox.frame8     .cpcntbox.frame8.button {left frame s padx 128}     .cpcntbox.frame8.button9 {right frame s padx 128} 

  # pack widget .cpcntbox
  pack append .cpcntbox     .cpcntbox.frame {top frame n pady 8 fillx}     .cpcntbox.frame1 {top frame n fillx}     .cpcntbox.frame8 {bottom frame center pady 16} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .cpcntbox
  }

  .cpcntbox.frame.frame3.entry5 insert end {/sos_schemas/agg}
  .cpcntbox.frame1.frame3.entry5 insert end {}
}

proc DestroyWindow.cpcntbox {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .cpcntbox]" != ""} {
      global xfShowWindow.cpcntbox
      set xfShowWindow.cpcntbox 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .cpcntbox; XFEditSetShowWindows"
    }
  } {
    catch "destroy .cpcntbox"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . ""
  wm sizefrom . user
  wm geometry . 498x305
  wm maxsize . 1152 900
  wm minsize . 0 0
  wm title . {directoryTool}


  # build widget .frame0
  frame .frame0 \
    -borderwidth {1} \
    -relief {raised}

  # build widget .frame0.menubutton0
  menubutton .frame0.menubutton0 \
    -menu {.frame0.menubutton0.m} \
    -relief {raised} \
    -text {Help}

  # build widget .frame0.menubutton0.m
  menu .frame0.menubutton0.m
  .frame0.menubutton0.m add command \
    -command {infobox::displayInfo about} \
    -label {About ...}

  # build widget .frame0.menubutton4
  menubutton .frame0.menubutton4 \
    -cursor {arrow} \
    -menu {.frame0.menubutton4.m} \
    -relief {raised} \
    -text {Objects}

  # build widget .frame0.menubutton4.m
  menu .frame0.menubutton4.m
  .frame0.menubutton4.m add command \
    -command {dir::display_directory /} \
    -label {Display Root}
  .frame0.menubutton4.m add command \
    -command {dir::copy_container} \
    -label {Copy Container}
  .frame0.menubutton4.m add command \
    -command {destroy .} \
    -label {Quit}

  # pack widget .frame0
  pack append .frame0 \
    .frame0.menubutton4 {left frame center} \
    .frame0.menubutton0 {right frame center}

  # build widget .frame1
  frame .frame1 \
    -borderwidth {10}

  # build widget .frame1.frame
  frame .frame1.frame

  # build widget .frame1.frame.scrollbar7
  scrollbar .frame1.frame.scrollbar7 \
    -command {.frame1.frame.frame3.entry5 view} \
    -orient {horizontal} \
    -width {8}

  # build widget .frame1.frame.frame3
  frame .frame1.frame.frame3

  # build widget .frame1.frame.frame3.entry5
  entry .frame1.frame.frame3.entry5 \
    -borderwidth {1} \
    -relief {raised} \
    -scrollcommand {.frame1.frame.scrollbar7 set} \
    -state {disabled} \
    -textvariable {dir::objectPath}

  # build widget .frame1.frame.frame3.label4
  label .frame1.frame.frame3.label4 \
    -anchor {w} \
    -padx {2} \
    -text {object path:}

  # pack widget .frame1.frame.frame3
  pack append .frame1.frame.frame3 \
    .frame1.frame.frame3.label4 {left frame center} \
    .frame1.frame.frame3.entry5 {top frame center expand fill}

  # pack widget .frame1.frame
  pack append .frame1.frame \
    .frame1.frame.frame3 {top frame center fillx} \
    .frame1.frame.scrollbar7 {top frame center fillx}

  # build widget .frame1.frame3
  frame .frame1.frame3

  # build widget .frame1.frame3.scrollbar7
  scrollbar .frame1.frame3.scrollbar7 \
    -command {.frame1.frame3.frame3.entry5 view} \
    -orient {horizontal} \
    -width {8}

  # build widget .frame1.frame3.frame3
  frame .frame1.frame3.frame3

  # build widget .frame1.frame3.frame3.entry5
  entry .frame1.frame3.frame3.entry5 \
    -borderwidth {1} \
    -relief {raised} \
    -scrollcommand {.frame1.frame3.scrollbar7 set} \
    -state {disabled} \
    -textvariable {dir::containerPath}

  # build widget .frame1.frame3.frame3.label4
  label .frame1.frame3.frame3.label4 \
    -anchor {w} \
    -borderwidth {1} \
    -padx {5} \
    -pady {0} \
    -text {containers:}

  # pack widget .frame1.frame3.frame3
  pack append .frame1.frame3.frame3 \
    .frame1.frame3.frame3.label4 {left frame center} \
    .frame1.frame3.frame3.entry5 {top frame center expand fillx}

  # pack widget .frame1.frame3
  pack append .frame1.frame3 \
    .frame1.frame3.frame3 {top frame center fillx} \
    .frame1.frame3.scrollbar7 {top frame center fillx}

  # pack widget .frame1
  pack append .frame1 \
    .frame1.frame {top frame center expand fillx} \
    .frame1.frame3 {top frame center expand fillx}

  # build widget .frame2
  frame .frame2 \
    -borderwidth {1} \
    -geometry {30x37} \
    -relief {sunken}

  # build widget .frame2.frame
  frame .frame2.frame \
    -borderwidth {1}

  # build widget .frame2.frame.scrollbar2
  scrollbar .frame2.frame.scrollbar2 \
    -command {.frame2.frame.listbox1 yview} \
    -width {10}

  # build widget .frame2.frame.scrollbar3
  scrollbar .frame2.frame.scrollbar3 \
    -command {.frame2.frame.listbox1 xview} \
    -orient {horizontal} \
    -width {10}

  # build widget .frame2.frame.listbox1
  listbox .frame2.frame.listbox1 \
    -exportselection {0} \
    -geometry {10x2} \
    -relief {raised} \
    -xscrollcommand {.frame2.frame.scrollbar3 set} \
    -yscrollcommand {.frame2.frame.scrollbar2 set}
  # bindings
  bind .frame2.frame.listbox1 <Any-Button-1> {dir::list_callback 1 %y}
  bind .frame2.frame.listbox1 <Double-Any-Button-1> {dir::list_callback 2 %y}

  # pack widget .frame2.frame
  pack append .frame2.frame \
    .frame2.frame.scrollbar2 {left frame center filly} \
    .frame2.frame.listbox1 {top frame center expand fill} \
    .frame2.frame.scrollbar3 {bottom frame center fillx}

  # pack widget .frame2
  pack append .frame2 \
    .frame2.frame {top frame center expand fill}

  # pack widget .
  pack append . \
    .frame0 {top frame n fillx} \
    .frame1 {top frame center fillx} \
    .frame2 {bottom frame s expand fill}

  .frame2.frame.listbox1 insert end {..}
  .frame2.frame.listbox1 insert end {. (sos_Object_Directory)}
  .frame2.frame.listbox1 insert end {sos_schemas (sos_Schema_module_Directory)}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# Internal procedures



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus

  foreach p [split $xfLoadPath :] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
    # are we able to load versions from wish ?
    if {[catch "afbind $p/$moduleName" aso]} {
      # try to use xf version load command
      global xfVersion
      if {[info exists xfVersion(showDefault)]} {
        set xfCommand $xfVersion(showDefault)
      } {
	# our last hope
        set xfCommand "vcat -q $p/$moduleName"
      }
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    } {
      # yes we can load versions directly
      if {[catch "$aso open r" inFile]} {
        puts stderr "Cannot open $p/[$aso attr af_bound] (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/[$aso attr af_bound]..."
      }
      if {[catch "read \{$inFile\}" contents]} {
        puts stderr "Cannot read $p/[$aso attr af_bound] (permission denied)"
        close $inFile
        continue
      }
      close $inFile
      eval $contents
      return 1
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  puts stderr "Specify a xf load path with the environment variable:"
  puts stderr "  XF_LOAD_PATH (e.g \"export XF_LOAD_PATH=.\")"
  catch "destroy ."
  catch "exit 0"
}



# end source
proc EndSrc {} {
#
# environment
#  - OBST*
#  - SAMPLE_TCLDIR
#	path of directory holding $dir::doCopyPrg, defaults to "../lib/tcl".
#  - WISH_CMD
#	Name of interpreter which is to execute $dir::doCopyPrg.
#
# global variables:
#  - dir::containerPath [quasi-const]
#	UNIX pathname of OBST container directory for `dirTool'.
#	Associated to read-only entry in main dialog.
#  - dir::foreignCntDir
#	UNIX pathname of OBST container directory into which objects/containers
#	are to be copied.
#	Associated to editable entry in `Copy Container' dialog.
#  - dir::objectPath
#	OBST path of object currently displayed in main dialog.
#	Associated to read-only entry in main dialog.
#  - dir::selectedObjPath
#	OBST path of object to be copied.
#	Associated to read-only entry in `Copy Container' dialog.
#  - dir::doCopyPrg
#	UNIX pathname of script file which performs a container copy.
#  - infobox::aboutText
#	Description of this `dirTool'.
#
   global dir::containerPath dir::objectPath dir::doCopyPrg env

   # block incomming send requests
   rename send ""

   if {![info exists env(SAMPLE_TCLDIR)]} {
      set env(SAMPLE_TCLDIR) ../lib/tcl
   }
   set dir::doCopyPrg	$env(SAMPLE_TCLDIR)/dirTool_doCopy.tcl
   set dir::containerPath	[dir::readCONTAINER]
   set dir::objectPath	{/}

   tclOBST bind
   tclOBST customize copy_Cstrings false

   dir::display_directory ${dir::objectPath}
}

XFLocalIncludeModule dirTool_obst.tcl
XFLocalIncludeModule infobox_tk.tcl
XFLocalIncludeModule xfstuff.tcl


# initialize global variables
proc InitGlobals {} {
  global {dir::containerPath}
  set {dir::containerPath} {/tmp_mnt/disk/prost-4/home/stone/tclOBST-1.1/cnt}
  global {dir::doCopyPrg}
  set {dir::doCopyPrg} {../lib/tcl/dirTool_doCopy.tcl}
  global {dir::foreignCntDir}
  set {dir::foreignCntDir} {}
  global {dir::objectPath}
  set {dir::objectPath} {/}
  global {dir::selectedObjPath}
  set {dir::selectedObjPath} {/sos_schemas/agg}
  global {infobox::aboutText}
  set {infobox::aboutText} {
                  Directory Tool

`Directory Tool' is a browser for OBST directories;
more precisely, the directory tree rooted at the OBST
root directory.

Objects are displayed with their name and type.
The symbolic entries "." and ".." represent the
currently displayed object and its parent directory,
respectively.

The display focus is shifted by double-clicking on an
object. A single click selects the respective object.

The tool offers the additional possibility to merge
container directories.

This makes it possible to merge a part of one OBST
database into another database, provided the data to
be copied are self-contained except for references to
identical data.
The sole exception where the differences between both
databases may overlap are common directory objects
whose contents (but not their object IDs) may differ in
that they contain named references into the different
portions.

This is the case e.g. in the following situation:
 - A local database was created as a clone of a
   central database.
 - Schemas were developed with that local database,
   whereby none of the common schemas differ between
   both databases.
 - The local schema data are to be merged into the
   global database without schema recompilation.
   (Schema recompilation will require recompilation of
    all the C++ code associated with those schemas.)

The above can be accomplished by using the `Copy
Container' operation from the `Objects' Menu:
 - Start this tool on the local database.
 - Copy each locally developed schema in turn, and
   specify the path name of the central database as
   `container path' in the respective dialog box.
 - In order to copy a schema, display the contents
   of the `/sos_schemas' directory, select a schema,
   and activate `Copy Container'.
}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(dirTool_obst.tcl)} {0}
  set {autoLoadList(dirTool_tk.tcl)} {0}
  set {autoLoadList(infobox_tk.tcl)} {0}
  set {autoLoadList(xfstuff.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(dirTool_obst.tcl)} { dir::append_path dir::readCONTAINER dir::lookup_OBSTobject dir::read_OBSTobject dir::display_directory dir::copy_container dir::do_copy_container dir::list_callback}
  set {moduleList(dirTool_tk.tcl)} {}
  set {moduleList(infobox_tk.tcl)} { infobox::displayInfo infobox::displayText .infobox}
  set {moduleList(xfstuff.tcl)} { Alias GetSelection MenuPopupAdd MenuPopupMotion MenuPopupPost MenuPopupRelease NoFunction SN SymbolicName Unalias}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(dir::CopyCntBox)} {.cpcntbox}
  set {symbolicName(dir::ObjectBox)} {.frame2.frame.listbox1}
  set {symbolicName(infobox::root)} {.infobox}
  set {symbolicName(infobox::text)} {.infobox.frame.text2}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {.}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.cpcntbox
set xfShowWindow.cpcntbox 0

global xfShowWindow.infobox
set xfShowWindow.infobox 0

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# end source
EndSrc

# eof
#

