#!./bin/wish -f
# XF
# create the widget hierarchy
#
# --------------------------------------------------------------------------
# Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------
#

# module inclusion

# initialize global variables
proc InitGlobals {} {
  global dir::containerPath
  set dir::containerPath {}
  global dir::objectPath
  set dir::objectPath {/}
  global dir::ForeignCntDir
  set dir::ForeignCntDir {}
  global dir::DoCopyPrg
  set dir::DoCopyPrg {/fzi/prost/stone/tclOBST-1.0/sample/bin/dirTool_doCopy.tk}
  global symbolicName
  set {symbolicName(dir::CopyCntBox)} {.top0}
  set {symbolicName(dir::InfoBox)} {.top1}
  set {symbolicName(root)} {.}
  set {symbolicName(dir::InfoTextBox)} {.top1.frame.text2}
  set {symbolicName(dir::ObjPathEntry)} {.top0.frame.frame3.entry5}
  set {symbolicName(dir::ObjectBox)} {.frame2.frame.listbox1}
  global moduleList
  set {moduleList(dirTool.tcl)} {}
}

proc ShowWindow.top0 { args} {

  # build widget .top0

  if {[string length [info commands .XFEdit]] > 0} {
    catch "XFDestroy .top0"
  } {
    catch "destroy .top0"
  }
  toplevel .top0
  .top0 configure 
  # bindings
  tk_bindForTraversal .top0
  bind .top0 <F10> {tk_firstMenu %W} 
  bind .top0 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # Window manager configurations
  wm title .top0 {CopyContainer}
  wm geometry .top0 394x145
  wm positionfrom .top0 program
  wm sizefrom .top0 user
  wm maxsize .top0 1000 900
  wm minsize .top0 10 10

  # build widget .top0.frame8
  frame .top0.frame8
  .top0.frame8 configure     -borderwidth {2}    -geometry {30x30}
  # bindings
  tk_bindForTraversal .top0.frame8
  bind .top0.frame8 <F10> {tk_firstMenu %W} 
  bind .top0.frame8 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame8.button9
  button .top0.frame8.button9
  .top0.frame8.button9 configure     -command {DestroyWindow[SymbolicName dir::CopyCntBox]}    -text { Cancel }
  # bindings
  tk_bindForTraversal .top0.frame8.button9
  bind .top0.frame8.button9 <F10> {tk_firstMenu %W} 
  bind .top0.frame8.button9 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame8.button
  button .top0.frame8.button
  .top0.frame8.button configure     -command {dir::do_copy_container}    -padx {2}    -text {  OK  }
  # bindings
  tk_bindForTraversal .top0.frame8.button
  bind .top0.frame8.button <F10> {tk_firstMenu %W} 
  bind .top0.frame8.button <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .top0.frame8
  pack append .top0.frame8    .top0.frame8.button   {left frame s padx 128}     .top0.frame8.button9   {right frame s padx 128} 


  # build widget .top0.frame1
  frame .top0.frame1
  .top0.frame1 configure     -borderwidth {4}    -geometry {30x30}
  # bindings
  tk_bindForTraversal .top0.frame1
  bind .top0.frame1 <F10> {tk_firstMenu %W} 
  bind .top0.frame1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame1.scrollbar7
  scrollbar .top0.frame1.scrollbar7
  .top0.frame1.scrollbar7 configure     -command {.top0.frame1.frame3.entry5 view}    -orient {horizontal}    -width {10}
  # bindings
  tk_bindForTraversal .top0.frame1.scrollbar7
  bind .top0.frame1.scrollbar7 <F10> {tk_firstMenu %W} 
  bind .top0.frame1.scrollbar7 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame1.frame3
  frame .top0.frame1.frame3
  .top0.frame1.frame3 configure     -geometry {30x30}
  # bindings
  tk_bindForTraversal .top0.frame1.frame3
  bind .top0.frame1.frame3 <F10> {tk_firstMenu %W} 
  bind .top0.frame1.frame3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame1.frame3.label4
  label .top0.frame1.frame3.label4
  .top0.frame1.frame3.label4 configure     -padx {2}    -text {container directory:}
  # bindings
  tk_bindForTraversal .top0.frame1.frame3.label4
  bind .top0.frame1.frame3.label4 <F10> {tk_firstMenu %W} 
  bind .top0.frame1.frame3.label4 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame1.frame3.entry5
  entry .top0.frame1.frame3.entry5
  .top0.frame1.frame3.entry5 configure     -exportselection {true}    -relief {raised}    -scrollcommand {.top0.frame1.scrollbar7 set}    -textvariable {dir::ForeignCntDir}
  # bindings
  tk_bindForTraversal .top0.frame1.frame3.entry5
  bind .top0.frame1.frame3.entry5 <Button-2> {%W insert cursor [GetSelection]} 
  bind .top0.frame1.frame3.entry5 <B3-Mod1-Motion> {%W scan dragto %x} 
  bind .top0.frame1.frame3.entry5 <Delete> {EntryBS %W} 
  bind .top0.frame1.frame3.entry5 <Control-Delete> {%W delete 0 cursor; %W view 0 } 
  bind .top0.frame1.frame3.entry5 <BackSpace> {EntryBS %W} 
  bind .top0.frame1.frame3.entry5 <Control-BackSpace> {%W delete 0 cursor; %W view 0} 
  bind .top0.frame1.frame3.entry5 <Right> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W } 
  bind .top0.frame1.frame3.entry5 <Left> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W } 
  bind .top0.frame1.frame3.entry5 <Control-a> {%W cursor 0; %W view 0} 
  bind .top0.frame1.frame3.entry5 <Control-b> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-d> {%W delete cursor; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-Mod1-d> {%W delete sel.first sel.last; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-e> {%W cursor end; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-f> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-h> {EntryBS %W} 
  bind .top0.frame1.frame3.entry5 <Control-Mod1-h> {%W delete 0 cursor; %W view cursor} 
  bind .top0.frame1.frame3.entry5 <Control-k> {%W delete cursor end; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-l> {EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <space> {%W insert cursor " "; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Any-Key> {%W insert cursor "%A"; EntryV2C %W} 
  bind .top0.frame1.frame3.entry5 <Control-v> {%W insert cursor "[GetSelection]"} 

  # pack widget .top0.frame1.frame3
  pack append .top0.frame1.frame3    .top0.frame1.frame3.label4   {left frame center}     .top0.frame1.frame3.entry5   {top frame center expand fill} 


  # pack widget .top0.frame1
  pack append .top0.frame1    .top0.frame1.frame3   {top frame center fillx}     .top0.frame1.scrollbar7   {top frame center fillx} 


  # build widget .top0.frame
  frame .top0.frame
  .top0.frame configure     -borderwidth {5}    -geometry {30x30}
  # bindings
  tk_bindForTraversal .top0.frame
  bind .top0.frame <F10> {tk_firstMenu %W} 
  bind .top0.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame.scrollbar7
  scrollbar .top0.frame.scrollbar7
  .top0.frame.scrollbar7 configure     -command {.top0.frame.frame3.entry5 view}    -orient {horizontal}    -width {10}
  # bindings
  tk_bindForTraversal .top0.frame.scrollbar7
  bind .top0.frame.scrollbar7 <F10> {tk_firstMenu %W} 
  bind .top0.frame.scrollbar7 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame.frame3
  frame .top0.frame.frame3
  .top0.frame.frame3 configure     -geometry {30x30}
  # bindings
  tk_bindForTraversal .top0.frame.frame3
  bind .top0.frame.frame3 <F10> {tk_firstMenu %W} 
  bind .top0.frame.frame3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame.frame3.label4
  label .top0.frame.frame3.label4
  .top0.frame.frame3.label4 configure     -padx {2}    -text {object path:}
  # bindings
  tk_bindForTraversal .top0.frame.frame3.label4
  bind .top0.frame.frame3.label4 <F10> {tk_firstMenu %W} 
  bind .top0.frame.frame3.label4 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top0.frame.frame3.entry5
  entry .top0.frame.frame3.entry5
  .top0.frame.frame3.entry5 configure     -borderwidth {1}    -exportselection {true}    -relief {raised}    -scrollcommand {.top0.frame.scrollbar7 set}
  # bindings
  tk_bindForTraversal .top0.frame.frame3.entry5
  bind .top0.frame.frame3.entry5 <Button-2> {%W insert cursor [GetSelection]} 
  bind .top0.frame.frame3.entry5 <B3-Mod1-Motion> {%W scan dragto %x} 
  bind .top0.frame.frame3.entry5 <Delete> {EntryBS %W} 
  bind .top0.frame.frame3.entry5 <Control-Delete> {%W delete 0 cursor; %W view 0 } 
  bind .top0.frame.frame3.entry5 <BackSpace> {EntryBS %W} 
  bind .top0.frame.frame3.entry5 <Control-BackSpace> {%W delete 0 cursor; %W view 0} 
  bind .top0.frame.frame3.entry5 <Right> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W } 
  bind .top0.frame.frame3.entry5 <Left> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W } 
  bind .top0.frame.frame3.entry5 <Control-a> {%W cursor 0; %W view 0} 
  bind .top0.frame.frame3.entry5 <Control-b> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-d> {%W delete cursor; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-Mod1-d> {%W delete sel.first sel.last; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-e> {%W cursor end; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-f> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-h> {EntryBS %W} 
  bind .top0.frame.frame3.entry5 <Control-Mod1-h> {%W delete 0 cursor; %W view cursor} 
  bind .top0.frame.frame3.entry5 <Control-k> {%W delete cursor end; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-l> {EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <space> {%W insert cursor " "; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Any-Key> {%W insert cursor "%A"; EntryV2C %W} 
  bind .top0.frame.frame3.entry5 <Control-v> {%W insert cursor "[GetSelection]"} 


  .top0.frame.frame3.entry5 insert end {}

  # pack widget .top0.frame.frame3
  pack append .top0.frame.frame3    .top0.frame.frame3.label4   {left frame center}     .top0.frame.frame3.entry5   {top frame center expand fill} 


  # pack widget .top0.frame
  pack append .top0.frame    .top0.frame.frame3   {top frame center fillx}     .top0.frame.scrollbar7   {top frame center fillx} 


  # pack widget .top0
  pack append .top0    .top0.frame   {top frame n pady 8 fillx}     .top0.frame1   {top frame n fillx}     .top0.frame8   {bottom frame center pady 16} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .top0
  }
}

proc DestroyWindow.top0 {} {
  if {[string length [info procs XFSaveAsProc]] > 0} {
    if {[string length [info commands .top0]] > 0} {
      XFMiscRemoveBindWidgetTree .top0 notall
      global xfShowWindow.top0
      set xfShowWindow.top0 0
      XFEditSetPath .
      after 200 "XFSaveAsProc .top0; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top0"
    update
  }
}

proc ShowWindow.top1 { args} {

  # build widget .top1

  if {[string length [info commands .XFEdit]] > 0} {
    catch "XFDestroy .top1"
  } {
    catch "destroy .top1"
  }
  toplevel .top1
  .top1 configure     -borderwidth {1}
  # bindings
  tk_bindForTraversal .top1
  bind .top1 <F10> {tk_firstMenu %W} 
  bind .top1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # Window manager configurations
  wm title .top1 {info}
  wm geometry .top1 400x342
  wm positionfrom .top1 program
  wm sizefrom .top1 user
  wm maxsize .top1 1000 900
  wm minsize .top1 10 10

  # build widget .top1.frame
  frame .top1.frame
  .top1.frame configure     -geometry {30x30}    -relief {raised}
  # bindings
  tk_bindForTraversal .top1.frame
  bind .top1.frame <F10> {tk_firstMenu %W} 
  bind .top1.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top1.frame.scrollbar1
  scrollbar .top1.frame.scrollbar1
  .top1.frame.scrollbar1 configure     -command {.top1.frame.text2 yview}    -width {10}
  # bindings
  tk_bindForTraversal .top1.frame.scrollbar1
  bind .top1.frame.scrollbar1 <F10> {tk_firstMenu %W} 
  bind .top1.frame.scrollbar1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top1.frame.text2
  text .top1.frame.text2
  .top1.frame.text2 configure     -borderwidth {1}    -exportselection {true}    -padx {2}    -pady {2}    -relief {raised}    -selectborderwidth {0}    -state {disabled}    -wrap {none}    -yscrollcommand {.top1.frame.scrollbar1 set}
  # bindings
  tk_bindForTraversal .top1.frame.text2
  bind .top1.frame.text2 <Any-Key> {NoFunction} 
  bind .top1.frame.text2 <Control-v> {
      %W insert insert "[GetSelection]"
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Left> {
      %W mark set insert insert-1c
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Delete> {
      %W delete insert insert+1c
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Right> {
      %W mark set insert insert+1c
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Up> {
      %W mark set insert insert-1l
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Down> {
      %W mark set insert insert+1l
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Control-a> {
      %W mark set insert "insert linestart"
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Control-e> {
      %W mark set insert "insert lineend"
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Home> {
      %W mark set insert 1.0
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <End> {
      %W mark set insert end
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Prior> {
      set xfCounter [lindex [%W config -height] 4]
      while {$xfCounter > 0} {
        %W mark set insert insert-1l
        incr xfCounter -1
      }
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Next> {
      set xfCounter [lindex [%W config -height] 4]
      while {$xfCounter > 0} {
        %W mark set insert insert+1l
        incr xfCounter -1
      }
      %W yview -pickplace insert} 

  # pack widget .top1.frame
  pack append .top1.frame    .top1.frame.scrollbar1   {left frame center filly}     .top1.frame.text2   {top frame center expand fill} 


  # build widget .top1.button5
  button .top1.button5
  .top1.button5 configure     -command {DestroyWindow[SymbolicName dir::InfoBox]}    -text {dismiss}
  # bindings
  tk_bindForTraversal .top1.button5
  bind .top1.button5 <F10> {tk_firstMenu %W} 
  bind .top1.button5 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .top1
  pack append .top1    .top1.frame   {top frame center expand fill}     .top1.button5   {bottom frame center pady 4} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .top1
  }
}

proc DestroyWindow.top1 {} {
  if {[string length [info procs XFSaveAsProc]] > 0} {
    if {[string length [info commands .top1]] > 0} {
      XFMiscRemoveBindWidgetTree .top1 notall
      global xfShowWindow.top1
      set xfShowWindow.top1 0
      XFEditSetPath .
      after 200 "XFSaveAsProc .top1; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top1"
    update
  }
}

# contents of .
proc ShowWindow. {args} {

  # Window manager configurations
  wm title . {directoryTool}
  wm geometry . 490x300
  wm positionfrom . program
  wm sizefrom . user
  wm maxsize . 1152 900
  wm minsize . 0 0

  # build widget .frame0
  frame .frame0
  .frame0 configure \
    -borderwidth {1}\
    -geometry {30x30}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame0
  bind .frame0 <F10> {tk_firstMenu %W} 
  bind .frame0 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame0.menubutton4
  menubutton .frame0.menubutton4
  .frame0.menubutton4 configure \
    -cursor {arrow}\
    -menu {.frame0.menubutton4.m}\
    -relief {raised}\
    -text {Objects}
  # bindings
  tk_bindForTraversal .frame0.menubutton4
  bind .frame0.menubutton4 <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton4 <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus . .frame0.menubutton4

  # build widget .frame0.menubutton4.m
  menu .frame0.menubutton4.m
  .frame0.menubutton4.m configure 
  # bindings
  tk_bindForTraversal .frame0.menubutton4.m
  bind .frame0.menubutton4.m <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton4.m <Mod2-Key> {tk_traverseToMenu %W %A} 

# Menu widget code
  .frame0.menubutton4.m add command\
  -command {dir::display_directory /}\
  -label {Display Root}
  .frame0.menubutton4.m add command\
  -command {dir::copy_container}\
  -label {Copy Container}
  .frame0.menubutton4.m add command\
  -command {dir::quit}\
  -label {Quit}

  # build widget .frame0.menubutton0
  menubutton .frame0.menubutton0
  .frame0.menubutton0 configure \
    -menu {.frame0.menubutton0.m}\
    -relief {raised}\
    -text {Help}
  # bindings
  tk_bindForTraversal .frame0.menubutton0
  bind .frame0.menubutton0 <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton0 <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus . .frame0.menubutton0

  # build widget .frame0.menubutton0.m
  menu .frame0.menubutton0.m
  .frame0.menubutton0.m configure 
  # bindings
  tk_bindForTraversal .frame0.menubutton0.m
  bind .frame0.menubutton0.m <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton0.m <Mod2-Key> {tk_traverseToMenu %W %A} 

# Menu widget code
  .frame0.menubutton0.m add command\
  -command {dir::showInfo about}\
  -label {About ...}

  # pack widget .frame0
  pack append .frame0\
    .frame0.menubutton4   {left frame center} \
    .frame0.menubutton0   {right frame center} 


  # build widget .frame1
  frame .frame1
  .frame1 configure \
    -borderwidth {10}
  # bindings
  tk_bindForTraversal .frame1
  bind .frame1 <F10> {tk_firstMenu %W} 
  bind .frame1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame
  frame .frame1.frame
  .frame1.frame configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame
  bind .frame1.frame <F10> {tk_firstMenu %W} 
  bind .frame1.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame.scrollbar7
  scrollbar .frame1.frame.scrollbar7
  .frame1.frame.scrollbar7 configure \
    -command {.frame1.frame.frame3.entry5 view}\
    -orient {horizontal}\
    -width {8}
  # bindings
  tk_bindForTraversal .frame1.frame.scrollbar7
  bind .frame1.frame.scrollbar7 <F10> {tk_firstMenu %W} 
  bind .frame1.frame.scrollbar7 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame.frame3
  frame .frame1.frame.frame3
  .frame1.frame.frame3 configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame.frame3
  bind .frame1.frame.frame3 <F10> {tk_firstMenu %W} 
  bind .frame1.frame.frame3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame.frame3.entry5
  entry .frame1.frame.frame3.entry5
  .frame1.frame.frame3.entry5 configure \
    -borderwidth {1}\
    -exportselection {true}\
    -relief {raised}\
    -scrollcommand {.frame1.frame.scrollbar7 set}\
    -state {disabled}\
    -textvariable {dir::objectPath}
  # bindings
  tk_bindForTraversal .frame1.frame.frame3.entry5
  bind .frame1.frame.frame3.entry5 <Control-v> {%W insert cursor "[GetSelection]"} 
  bind .frame1.frame.frame3.entry5 <Any-Key> {%W insert cursor "%A"; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <space> {%W insert cursor " "; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-l> {EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-k> {%W delete cursor end; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-Mod1-h> {%W delete 0 cursor; %W view cursor} 
  bind .frame1.frame.frame3.entry5 <Control-h> {EntryBS %W} 
  bind .frame1.frame.frame3.entry5 <Control-f> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-e> {%W cursor end; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-Mod1-d> {%W delete sel.first sel.last; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-d> {%W delete cursor; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-b> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W} 
  bind .frame1.frame.frame3.entry5 <Control-a> {%W cursor 0; %W view 0} 
  bind .frame1.frame.frame3.entry5 <Left> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W } 
  bind .frame1.frame.frame3.entry5 <Right> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W } 
  bind .frame1.frame.frame3.entry5 <Control-BackSpace> {%W delete 0 cursor; %W view 0} 
  bind .frame1.frame.frame3.entry5 <BackSpace> {EntryBS %W} 
  bind .frame1.frame.frame3.entry5 <Control-Delete> {%W delete 0 cursor; %W view 0 } 
  bind .frame1.frame.frame3.entry5 <Delete> {EntryBS %W} 
  bind .frame1.frame.frame3.entry5 <B3-Mod1-Motion> {%W scan dragto %x} 
  bind .frame1.frame.frame3.entry5 <Button-2> {%W insert cursor [GetSelection]} 


  .frame1.frame.frame3.entry5 insert end {/}

  # build widget .frame1.frame.frame3.label4
  label .frame1.frame.frame3.label4
  .frame1.frame.frame3.label4 configure \
    -anchor {w}\
    -padx {2}\
    -text {object path:}
  # bindings
  tk_bindForTraversal .frame1.frame.frame3.label4
  bind .frame1.frame.frame3.label4 <F10> {tk_firstMenu %W} 
  bind .frame1.frame.frame3.label4 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .frame1.frame.frame3
  pack append .frame1.frame.frame3\
    .frame1.frame.frame3.label4   {left frame center} \
    .frame1.frame.frame3.entry5   {top frame center expand fill} 


  # pack widget .frame1.frame
  pack append .frame1.frame\
    .frame1.frame.frame3   {top frame center fillx} \
    .frame1.frame.scrollbar7   {top frame center fillx} 


  # build widget .frame1.frame3
  frame .frame1.frame3
  .frame1.frame3 configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame3
  bind .frame1.frame3 <F10> {tk_firstMenu %W} 
  bind .frame1.frame3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame3.scrollbar7
  scrollbar .frame1.frame3.scrollbar7
  .frame1.frame3.scrollbar7 configure \
    -command {.frame1.frame3.frame3.entry5 view}\
    -orient {horizontal}\
    -width {8}
  # bindings
  tk_bindForTraversal .frame1.frame3.scrollbar7
  bind .frame1.frame3.scrollbar7 <F10> {tk_firstMenu %W} 
  bind .frame1.frame3.scrollbar7 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame3.frame3
  frame .frame1.frame3.frame3
  .frame1.frame3.frame3 configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame3.frame3
  bind .frame1.frame3.frame3 <F10> {tk_firstMenu %W} 
  bind .frame1.frame3.frame3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame3.frame3.entry5
  entry .frame1.frame3.frame3.entry5
  .frame1.frame3.frame3.entry5 configure \
    -borderwidth {1}\
    -exportselection {true}\
    -relief {raised}\
    -scrollcommand {.frame1.frame3.scrollbar7 set}\
    -state {disabled}\
    -textvariable {dir::containerPath}
  # bindings
  tk_bindForTraversal .frame1.frame3.frame3.entry5
  bind .frame1.frame3.frame3.entry5 <Control-v> {%W insert cursor "[GetSelection]"} 
  bind .frame1.frame3.frame3.entry5 <Any-Key> {%W insert cursor "%A"; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <space> {%W insert cursor " "; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-l> {EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-k> {%W delete cursor end; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-Mod1-h> {%W delete 0 cursor; %W view cursor} 
  bind .frame1.frame3.frame3.entry5 <Control-h> {EntryBS %W} 
  bind .frame1.frame3.frame3.entry5 <Control-f> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-e> {%W cursor end; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-Mod1-d> {%W delete sel.first sel.last; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-d> {%W delete cursor; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-b> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W} 
  bind .frame1.frame3.frame3.entry5 <Control-a> {%W cursor 0; %W view 0} 
  bind .frame1.frame3.frame3.entry5 <Left> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W } 
  bind .frame1.frame3.frame3.entry5 <Right> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W } 
  bind .frame1.frame3.frame3.entry5 <Control-BackSpace> {%W delete 0 cursor; %W view 0} 
  bind .frame1.frame3.frame3.entry5 <BackSpace> {EntryBS %W} 
  bind .frame1.frame3.frame3.entry5 <Control-Delete> {%W delete 0 cursor; %W view 0 } 
  bind .frame1.frame3.frame3.entry5 <Delete> {EntryBS %W} 
  bind .frame1.frame3.frame3.entry5 <B3-Mod1-Motion> {%W scan dragto %x} 
  bind .frame1.frame3.frame3.entry5 <Button-2> {%W insert cursor [GetSelection]} 


  .frame1.frame3.frame3.entry5 insert end {/tmp_mnt/disk/DBS0S4-3H/home/theobald/work/tclOBST-1.0/cnt}

  # build widget .frame1.frame3.frame3.label4
  label .frame1.frame3.frame3.label4
  .frame1.frame3.frame3.label4 configure \
    -anchor {w}\
    -borderwidth {1}\
    -padx {5}\
    -pady {0}\
    -text {containers:}
  # bindings
  tk_bindForTraversal .frame1.frame3.frame3.label4
  bind .frame1.frame3.frame3.label4 <F10> {tk_firstMenu %W} 
  bind .frame1.frame3.frame3.label4 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .frame1.frame3.frame3
  pack append .frame1.frame3.frame3\
    .frame1.frame3.frame3.label4   {left frame center} \
    .frame1.frame3.frame3.entry5   {top frame center expand fillx} 


  # pack widget .frame1.frame3
  pack append .frame1.frame3\
    .frame1.frame3.frame3   {top frame center fillx} \
    .frame1.frame3.scrollbar7   {top frame center fillx} 


  # pack widget .frame1
  pack append .frame1\
    .frame1.frame   {top frame center expand fillx} \
    .frame1.frame3   {top frame center expand fillx} 


  # build widget .frame2
  frame .frame2
  .frame2 configure \
    -borderwidth {1}\
    -geometry {30x37}\
    -relief {sunken}
  # bindings
  tk_bindForTraversal .frame2
  bind .frame2 <F10> {tk_firstMenu %W} 
  bind .frame2 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame
  frame .frame2.frame
  .frame2.frame configure \
    -borderwidth {1}\
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame2.frame
  bind .frame2.frame <F10> {tk_firstMenu %W} 
  bind .frame2.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame.scrollbar3
  scrollbar .frame2.frame.scrollbar3
  .frame2.frame.scrollbar3 configure \
    -command {.frame2.frame.listbox1 xview}\
    -orient {horizontal}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame2.frame.scrollbar3
  bind .frame2.frame.scrollbar3 <F10> {tk_firstMenu %W} 
  bind .frame2.frame.scrollbar3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame.scrollbar2
  scrollbar .frame2.frame.scrollbar2
  .frame2.frame.scrollbar2 configure \
    -command {.frame2.frame.listbox1 yview}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame2.frame.scrollbar2
  bind .frame2.frame.scrollbar2 <F10> {tk_firstMenu %W} 
  bind .frame2.frame.scrollbar2 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame.listbox1
  listbox .frame2.frame.listbox1
  .frame2.frame.listbox1 configure \
    -exportselection {false}\
    -geometry {10x2}\
    -relief {raised}\
    -xscrollcommand {.frame2.frame.scrollbar3 set}\
    -yscrollcommand {.frame2.frame.scrollbar2 set}
  # bindings
  tk_bindForTraversal .frame2.frame.listbox1
  bind .frame2.frame.listbox1 <Any-Button-1> {dir::list_callback 1 %y} 
  bind .frame2.frame.listbox1 <Double-Any-Button-1> {dir::list_callback 2 %y} 
  bind .frame2.frame.listbox1 <F10> {tk_firstMenu %W} 
  bind .frame2.frame.listbox1 <Mod2-Key> {tk_traverseToMenu %W %A} 



  # pack widget .frame2.frame
  pack append .frame2.frame\
    .frame2.frame.scrollbar2   {left frame center filly} \
    .frame2.frame.listbox1   {top frame center expand fill} \
    .frame2.frame.scrollbar3   {bottom frame center fillx} 


  # pack widget .frame2
  pack append .frame2\
    .frame2.frame   {top frame center expand fill} 

  # bindings
  tk_bindForTraversal .
  bind . <F10> {tk_firstMenu %W} 
  bind . <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .
  pack append .\
    .frame0   {top frame n fillx} \
    .frame1   {top frame center fillx} \
    .frame2   {bottom frame s expand fill} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .frame2
  }
}


# Procedures


if {[string length [info procs GetSelection]] == 0} {
proc GetSelection {} {

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  return $xfSelection
}
}


if {[string length [info procs MenuPopupAdd]] == 0} {
proc MenuPopupAdd { xfW xfButton xfMenu} {

  if {[catch "bind $xfW \"<ButtonPress-$xfButton>\"                 \"$xfMenu post %X %Y\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
  # we need these to counteract the effects of passive grabs :-(
  if {[catch "bind $xfW \"<ButtonRelease-$xfButton>\"                 \"$xfMenu invoke active; $xfMenu unpost\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
  if {[catch "bind $xfW \"<B$xfButton-Motion>\"                 \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
}
}

proc dir::showInfo { what {text ""}} {
#-----------------
global errorInfo

if {[info exists errorInfo]} then {
   set errInfo $errorInfo
} else {
   set errInfo ""
}
set Box     [SymbolicName dir::InfoBox]
set TextBox [SymbolicName dir::InfoTextBox]

if {[catch "winfo ismapped Box"]} ShowWindow$Box

$TextBox configure -state normal
$TextBox delete 1.0 end

case $what in {
  error {$TextBox insert end "$errInfo"}
  text  {$TextBox insert end "$text"}
  about {$TextBox insert end {
                  Directory Tool

`Directory Tool' is a browser for OBST directories;
more precisely, the directory tree rooted at the OBST
root directory.

Objects are displayed with their name and type.
The symbolic entries "." and ".." represent the
currently displayed object and its parent directory,
respectively.

The display focus is shifted by double-clicking on an
object. A single click selects the respective object.

The tool offers the additional possibility to merge
container directories.

This makes it possible to merge a part of one OBST
database into another database, provided the data to
be copied are self-contained except for references to
identical data.
The sole exception where the differences between both
databases may overlap are common directory objects
whose contents (but not their locations) may differ in
that they contain named references into the different
portions.

This is the case e.g. in the following situation:
 - A local database was created as a clone of a
   central database.
 - Schemata were developed with that local database,
   whereby none of the common schemata differs between
   both databases.
 - The local schema data are to be merged into the
   global database without schema recompilation.
   (Schema recompilation will require recompilation of
    all the C++ code associated with those schemata.)

The above can be accomplished by using the `Copy
Container' operation from the `Objects' Menu:
 - Start this tool on the local database.
 - Copy each locally developed schema in turn, and
   specify the path name of the central database as
   `container path' in the respective dialog box.
 - In order to copy a schema, display the contents
   of the `/sos_schemas' directory, select a schema,
   and activate `Copy Container'.}
	}
}
$TextBox configure -state disabled
}


if {[string length [info procs EntryV2C]] == 0} {
proc EntryV2C { xfW} {

  set xfLeftExtent [$xfW index @0]
  set xfRightExtent [$xfW index @[winfo width $xfW]]
  set xfCursorPos [$xfW index cursor]
  set xfEntryLen [expr "$xfRightExtent-$xfLeftExtent"]

  if {$xfCursorPos > $xfLeftExtent} {
    if {$xfCursorPos > $xfRightExtent} {
      #handle cursor too far to the right
      $xfW view [expr "$xfCursorPos-$xfEntryLen+1"]
    }
  } { 
    #handle cursor too far to the left
    $xfW view [expr "$xfCursorPos-1"]
  }
}
}

proc dir::append_path { path} {
#--------------------
global dir::objectPath

case "$path" in {
   /*	   {set newPath "$path"}
   ..	   {set newPath [file dirname "${dir::objectPath}"]
	    if {"$newPath" == "."} then {set newPath "/"}
	   }
   .	   {set newPath "${dir::objectPath}"}
   default {set newPath "[string trimright ${dir::objectPath} /]/$path"}
}

return "$newPath"
}

proc dir::display_directory { path} {
#--------------------------
global dir::objectPath

set Box     [SymbolicName dir::ObjectBox]
set newPath "[dir::append_path $path]"

if {[catch "set entryList [list [dir::read_OBSTdirectory $newPath]]"]} then {
   dir::showInfo error
} else {
   set dir::objectPath "$newPath"

   $Box delete 0 end
   $Box insert end ".."
   foreach entry $entryList {
      $Box insert end $entry
   }
}
}

proc dir::do_copy_container {} {
#--------------------------
global dir::ForeignCntDir dir::containerPath dir::DoCopyPrg env

set ObjEntry  [SymbolicName dir::ObjPathEntry]
set objPath   [$ObjEntry get]
set objHandle [dir::lookup_OBSTobject $objPath]

set env(OBSTCONTAINER) "${dir::ForeignCntDir}"

catch "exec ${dir::DoCopyPrg} ${dir::containerPath} $objPath $objHandle" result

dir::showInfo text "$result"

DestroyWindow[SymbolicName dir::CopyCntBox]
}

proc dir::quit {} {
#-------------
destroy [SymbolicName root]
}

proc dir::copy_container {} {
#--------------------------
set Box     [SymbolicName dir::ObjectBox]
set SelList "[$Box curselection]"

if {[llength $SelList] == 1} then {
   set entry    "[lindex [$Box get [lindex $SelList 0]] 0]"
   set ObjEntry [SymbolicName dir::ObjPathEntry]

   ShowWindow[SymbolicName dir::CopyCntBox]

   $ObjEntry configure -state normal
   $ObjEntry delete 0 end
   $ObjEntry insert end "[dir::append_path $entry]"
   $ObjEntry configure -state disabled
}
}


if {[string length [info procs EntryBS]] == 0} {
proc EntryBS { xfW} {

  set xfX [expr {[$xfW index cursor]-1}]
  if {$xfX != -1} {
    $xfW delete $xfX
  }
  EntryV2C $xfW
}
}

proc dir::list_callback { clicks ypos} {
#----------------------
set Box	  [SymbolicName dir::ObjectBox]
set Index [$Box nearest $ypos]

$Box select from $Index

if {$clicks > 1} then {dir::display_directory [lindex [$Box get $Index] 0]}
}


if {[string length [info procs SymbolicName]] == 0} {
proc SymbolicName { {xfName ""}} {
  global symbolicName

  if {[string length $xfName] > 0} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {[catch "set \"$xfArrayName\"" xfValue] == 0} {
      return $xfValue
    } {
      if {[string length [info commands XFError]] > 0} {
        XFError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}

proc tkerror { err} {
    global errorInfo
    puts stdout "$errorInfo"
}


if {[string length [info procs NoFunction]] == 0} {
proc NoFunction { args} {

}
}


if {[string length [info procs MenuPopupHandle]] == 0} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {

 if {[winfo ismapped $xfMenu]} {
   set xfPopMinX [winfo rootx $xfMenu]
   set xfPopMaxX [expr "$xfPopMinX + [winfo width $xfMenu]"]
   if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
     $xfMenu activate @[expr "$xfY - [winfo rooty $xfMenu]"]
   } {
     $xfMenu activate none}
   }
}
}

proc dir::readCONTAINER {} {
#----------------------
global env
set result ""

if {[catch {set result $env(OBSTCONTAINER)}]} then {
   if {[catch {set result $env(SOSCONTAINER)}]} then {
      puts stderr "*** \$OBSTCONTAINER not defined"
      dir::quit
   }
}
return $result
}

proc dir::lookup_OBSTobject { path} {
#--------------------------
set name [OBST tmpstr $path]
set obj	 [mcall sos_Directory::lookup $name]

$name destroy

return $obj
}

proc dir::read_OBSTdirectory { path} {
#---------------------------
#for XF
#return

set obj	[dir::lookup_OBSTobject $path]

if {$obj == [OBST const NO_OBJECT]} return

lappend result ". ([[[$obj type] get_name] make_Cstring])"

if {[OBST is_some $obj sos_Object_Directory]} then {
   agg loop $obj {
      set type "[[[[agg current role2] type] get_name] make_Cstring]"
      lappend result "[[agg current role1] make_Cstring] ($type)"
   }
}
return $result
}

# end source
proc EndSrc {} {
#----------
global dir::containerPath
set dir::containerPath "[dir::readCONTAINER]"

#for XF
tclOBST bind
dir::display_directory "${dir::objectPath}"
}


# initialize global variables
# remove this call if there are problems at startup
InitGlobals


# stuff to display and remove toplevel windows
# call the procedures to create the toplevels.
ShowWindow.

global xfShowWindow.top0
set xfShowWindow.top0 0

global xfShowWindow.top1
set xfShowWindow.top1 0

# end source

#----------
global dir::containerPath
set dir::containerPath "[dir::readCONTAINER]"

#for XF
tclOBST bind
dir::display_directory "${dir::objectPath}"

# eof
#
