/* =================================================================== */
/*       CLASS - IMPLEMENTATION                                    === */
/* =================================================================== */
/*                                                                     */
/* CLASS-NAME: add_Related_Object             Class_Id: RO             */
/*                                                                     */
/* IMPLEMENTATION ISSUES:                                              */
/*                                                                     */
/* =================================================================== */
#define RELATIONSHIP_CONCEPT 1

/* =================================================================== */
/* Substitution of C-symbols :                                         */
#include "predef.h"

/* =================================================================== */
/* Trace switches:                                                     */
#include "trc_add.h"

/* =================================================================== */
// Export File of this concept
#include "Relationship_obst.h"

// ---- Initialization ---- //

Void ro_init ()
// initializies the runtime data structures of this process.
// This function is called only by main();
{/*
  T_PROC("ro_init"); TT(rel_H, T_ENTER);
  copy_of_relship_bag = 
        add_Relship_Bag::create(TEMP_CONTAINER);
  TT(rel_H, T_LEAVE); return;
*/}


// ---- Methods of this Class ---- //

add_Relship_Bag add_Related_Object::relships(sos_Type relship_type, sos_Cstring role)
   //
   // PURPOSE:
   // returns a bag containing all add_Relships this objects takes part in.
   // The returned bag is only a copy (snapshot).
   // The bag is a buffer which will be overwritten
   // by the next execution of this method. Therefore the bag
   // should be copied by the invoking method in case the
   // retrieved information should be preserved.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Related_Object::relships(sos_Type relship_type, sos_Cstring role)"); 
  TT(rel_H, T_ENTER);
  static add_Relship_Bag copy_of_relship_bag = 
    add_Relship_Bag::create(TEMP_CONTAINER, FALSE, FALSE, AGG_LIST);
  copy_of_relship_bag.clear();

  add_Relship_Bag relship_bag = self.get_relships();  
  TT(rel_H, TI( relship_bag.card()));

  if (relship_type == NO_OBJECT)
    copy_of_relship_bag.assign(relship_bag);
  else
    {
//      copy_of_relship_bag.clear();
      if (role) {
	agg_iterate(relship_bag, add_Relship relship)
	  if (relship.isa(relship_type) AND
	      streql(relship.role_name_of(self), role))
	    copy_of_relship_bag.insert(relship);
	agg_iterate_end(relship_bag, relship);
      }
      else {
	agg_iterate(relship_bag, add_Relship relship)
	  if (relship.isa(relship_type))
	    copy_of_relship_bag.insert(relship);
	agg_iterate_end(relship_bag, relship);
      }
    }

  TT(rel_H, T_LEAVE;  TI( copy_of_relship_bag.card()));
  return (copy_of_relship_bag);
}

add_Related_Object_Bag add_Related_Object::related_objects (sos_Type relship_type, 
					sos_Cstring role_of_this_object,
					sos_Cstring role_of_retrieved_objects)
	// retrieves objects which are related with this object.
	// retrieves all related objects if (relship_type == NO_OBJECT)
{
  T_PROC("add_Related_Object::related_objects(relship_type, role_of_this_object, role_of_retrieved_objects)"); 
  TT(rel_H, T_ENTER);
  static add_Related_Object_Bag copy_of_related_object_bag = 
    add_Related_Object_Bag::create(TEMP_CONTAINER, FALSE, FALSE, AGG_LIST);
  copy_of_related_object_bag.clear();

  add_Relship_Bag relship_bag = self.get_relships();  
  TT(rel_H, TI( relship_bag.card()));

  if (relship_type == NO_OBJECT)
    {
      agg_iterate(relship_bag, add_Relship relship) {
	add_Role_Set role_set = relship.get_roles();
	if (role_set == NO_OBJECT) {
	  add_Related_Object obj1 = relship.get_obj1();
	  if (obj1 != self)
	    copy_of_related_object_bag.insert(obj1);
	  else 
	    copy_of_related_object_bag.insert(relship.get_obj2());	    
	}
	else {
	  agg_iterate(role_set, add_Role role) {
	    add_Related_Object related_object = role.get_related_object();
	    if (related_object != self)
	      copy_of_related_object_bag.insert(related_object);
	  }	  
	  agg_iterate_end(role_set, role);
	}
      }
      agg_iterate_end(relship_bag, relship);
    }
  else
    {
      agg_iterate(relship_bag, add_Relship relship) {
	if (relship.isa(relship_type)) {
	  add_Role_Set role_set = relship.get_roles();
	  if (role_set == NO_OBJECT) {
	    add_Related_Object obj1 = relship.get_obj1();
	    add_Related_Object obj2 = relship.get_obj2();
	    if (!role_of_this_object) {
	      if (obj1 == self) 
		copy_of_related_object_bag.insert(obj2);
	      else 
		copy_of_related_object_bag.insert(obj1);
	    }
	    else {
	      sos_Cstring role1 = relship.get_role1().make_Cstring();
	      sos_Cstring role2 = relship.get_role2().make_Cstring();	    
	      if (!role_of_retrieved_objects) {
		if (obj1 == self) {
		  if(streql(role1, role_of_this_object))
		    copy_of_related_object_bag.insert(obj2);
		}
		else {
		  if(streql(role2, role_of_this_object))
		    copy_of_related_object_bag.insert(obj2);
		}
	      }
	      else {
		if (obj1 == self) {
		  if(streql(role1, role_of_this_object) AND
		     streql(role2, role_of_retrieved_objects))
		    copy_of_related_object_bag.insert(obj2);
		}
		else {
		  if(streql(role2, role_of_this_object) AND
		     streql(role1, role_of_retrieved_objects))
		    copy_of_related_object_bag.insert(obj1);
		}
	      }
	      delete role1;
	      delete role2;
	    }
	  }
	  else {
	    sos_Bool role_of_this_object_found = FALSE;
	    sos_Bool role_of_retrieved_objects_found = FALSE;
	    add_Related_Object related_object;
	    agg_iterate(role_set, add_Role role) {
	      sos_Cstring role_name = role.get_role_name().make_Cstring();
	      if (streql(role_name, role_of_this_object) AND 
		  role.get_related_object() == self)
		role_of_this_object_found = TRUE;
	      else
		if (streql(role_name, role_of_retrieved_objects)) {
		  related_object = role.get_related_object();
		  role_of_retrieved_objects_found = TRUE;	
		}	
	      delete role_name;
	    }	  
	    agg_iterate_end(role_set, role);
	    if (role_of_this_object_found AND role_of_retrieved_objects_found)
		copy_of_related_object_bag.insert(related_object);
	  }
	}
      }
      agg_iterate_end(relship_bag, relship);
    }

  TT(rel_H, T_LEAVE;  TI( copy_of_related_object_bag.card()));
  return (copy_of_related_object_bag);
}


sos_Cstring add_Related_Object::description()
   //
   // PURPOSE:
   //     returns a description of this object.
   //     Contained name spaces are described in a 
   //     non recursive way.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Related_Object::description()"); TT(rel_H, T_ENTER);

  sos_Cstring tmp_string1;
  sos_Cstring tmp_string2;
  sos_Cstring string = strnew("Relationship.Roles: ", "");

  add_Relship_Bag relship_bag = self.get_relships();  
  if (relship_bag.card() == 0)
    {
      tmp_string1 = strnew(string, "none");
      delete string;
      string = tmp_string1;
    }
  else
    {
      agg_iterate ( relship_bag, add_Relship rel)
	{
	  tmp_string1 = rel.type().get_name().make_Cstring();
	  tmp_string2 = strnew(string, tmp_string1);
	  delete tmp_string1;
	  delete string;
	  tmp_string1 = strnew(tmp_string2, ".");
	  delete tmp_string2;
	  tmp_string2 = strnew(tmp_string1, rel.role_name_of(self));
	  string = strnew(tmp_string2, " ");
	  delete tmp_string2;
	}
      agg_iterate_end ( relship_bag, rel);
    }

  tmp_string1 = strnew(string, "\n");
  delete string;
  string = tmp_string1;
  TT(rel_H, TS( string));
  TT(rel_H, T_LEAVE); return (string);
}

Void add_Related_Object::note_new_relship (add_Relship r)
                // <- add_Relship::create, change_role
{return;}

Void add_Related_Object::note_lost_relship (add_Relship r)
                // <- add_Relship::destroy, change_role
{return;}

Void add_Related_Object::note_changed_partners (add_Relship r)
                // notifies this object that it is now related to
                // other Related_Objects than before.
                // <- add_Relship::change_role
{return;}


Void add_Related_Object::local_initialize(add_Related_Object this_one)
   //
   // PURPOSE:
   // initialises the components of this Related_Object
   // and notifies the concerned objects.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  sos_String sos_str;

  T_PROC("add_Related_Object::local_initialize(add_Related_Object this_one)");
  TT(rel_H, T_ENTER);

  this_one.set_relships(add_Relship_Bag::create(this_one.container()));

  TT(rel_H, T_LEAVE); return;
} 


Void add_Related_Object::local_assign(add_Related_Object destination,
					   sos_Object source_obj)
   //
   // PURPOSE:
   // dest will not!! take part in any!! relationship,
   // i.e. the relships Bag is not copied.
   //                                                         
   // PRECONDITION:                                           
   //                                                         
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC("add_Related_Object::local_assign(...) "); TT(rel_H, T_ENTER);

//  destination.get_relships().clear();

  TT(rel_H, T_LEAVE); return;
} 


Void add_Related_Object::local_finalize(add_Related_Object this_one)
   //
   // PURPOSE:
   // destroys this object and all its relships.
   //                                                         
   // PRECONDITION:                                           
   //                                                         
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC("add_Related_Object::local_finalize(this_one)"); TT(rel_H, T_ENTER);

  add_Relship_Bag relship_bag = this_one.get_relships();  
  // destroy all referenced relships
  do
    {
      sos_Cursor cursor = relship_bag.open_cursor();
      if (relship_bag.to_first(cursor)) 
	{ 
	  relship_bag.get(cursor).destroy();
	  relship_bag.close_cursor(cursor);
    	}
      else
	{
	  relship_bag.close_cursor(cursor);
	  break;
	}
    }
  while(TRUE);

  relship_bag.destroy();

  TT(rel_H, T_LEAVE); return;
} 


