/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "smg.h"
#include "trc_stf.h"
#include "stf_err.h"
#include "stf_obst.h"

filebuf fb_lex;
filebuf fb_yacc;
ostream out_lex(&fb_lex);
ostream out_yacc(&fb_yacc);

LOCAL ostream& operator<< (ostream&, sos_Typed_id);
LOCAL int str_item_out (stf_Item, int&);
LOCAL void str_string_items_out (stf_String_symbol_List, int&);
LOCAL void convert (sos_Bool, sos_Type, smg_String target,
		    sos_Type, smg_String source,
		    sos_String conversion);
LOCAL smg_String str_unfoldCstring (sos_String s);
LOCAL void stf_print_lex_header ();
LOCAL void stf_print_yacc_final (sos_String, smg_String);


// **************************************************************************
void stf_Grammar::gen_structurer()
// **************************************************************************
{
   T_PROC ("stf_Grammar::gen_structurer");
   TT (stf_H, T_ENTER);
   smg_String gra_name = smg_String (self.get_name());
   smg_String lex_name = gra_name + "_str.l";
   smg_String yacc_name = gra_name + "_str.y";

   sos_Type sos_string_type =
      sos_Type::make (sos_String_type);
   sos_String no_conversion = sos_String::make (NO_OBJECT);

   if (fb_lex.open(lex_name.make_Cstring (SMG_BORROW), output) == 0 || 
       fb_yacc.open(yacc_name.make_Cstring (SMG_BORROW), output) == 0)
   {  err_raise (err_USE, err_STF_OUTPUT_ERROR);
      TT (stf_H, T_LEAVE);
      return;
   }

   stf_Imports impl = self.get_imports();
   stf_Item_List aux_rules = self.get_aux_rules();
   stf_Rule_List rules = self.get_rules();
   sos_String_stf_Symbol_rule_Mapping symbol_table = self.get_symbol_table();
   sos_String_stf_String_symbol_Mapping string_symbols =
      self.get_string_symbols();
   sos_Type root_type =
      self.get_root_rule().get_symbol().get_schema_type();

   stf_print_lex_header ();

   // string symbols
   agg_iterate_association (string_symbols,
			    sos_String str, stf_String_symbol sym)
   {  if (NOT smg_String (sym).equal ("\n"))
      {  out_yacc << "%token stf_tok_" << sym._typed_id() << "\n";
	 out_lex << str_unfoldCstring (sym)
		 << "\t{return stf_tok_" << sym._typed_id() << ";}\n";
      }
   }
   agg_iterate_association_end (string_symbols, str, sym);

   // symbols in lexical rules
   sos_Bool whitespace_defined = FALSE;
   agg_iterate (rules, stf_Rule rl)
   {  if (rl.has_type (stf_Lexical_rule_type))
      {  stf_Lexical_rule lrl = stf_Lexical_rule::make (rl);
	 sos_String sym = lrl.get_symbol().get_name();
	 sos_String pat = lrl.get_pattern();
	 out_lex << pat << "\t{";
	 if (smg_String (sym).equal ("whitespace"))
	    whitespace_defined = TRUE;
	 else
	 {  out_yacc << "%token " << sym << "\n";
	    out_lex << "sos_String _s = sos_String::create(_stf_cnt);\n"
		    << "\t_s.assign_Cstring((char*)yytext);\n\t";

	    smg_String target = smg_String ("yylval.u_") + sym;
	    smg_String source = smg_String ("_s");
	    convert (FALSE, lrl.get_symbol().get_schema_type(), target,
		     sos_string_type, source,
		     lrl.get_conversion());
	    out_lex << "\n\treturn " << sym << ";";
	 }
	 out_lex << "}\n";
      }
   }
   agg_iterate_end (rules, rl);
   if (NOT whitespace_defined)
      out_lex << "{CClinecomment}|{CCmlinecomment}|[ \\t\\n]\t{}\n";
   out_lex << ".\t{yyerror(\"lexical error\");}\n";

   // yacc types
   agg_iterate_association (symbol_table, sos_String str, stf_Symbol_rule sr)
   {  if (NOT smg_String (str).equal ("whitespace"))
	 out_yacc << "%type <u_" << str << "> " << str << "\n";
   }
   agg_iterate_association_end (symbol_table, str, sr);

   agg_iterate (aux_rules, stf_Item item)
   {  out_yacc << "%type <u_" << item.get_schema_type().get_name()
	       << "_" << item._typed_id() << "> "
	       << item.get_schema_type().get_name()
	       << "_" << item._typed_id() << "\n";
   }
   agg_iterate_end (aux_rules, item);


   out_yacc << "%{\n";

   out_yacc << "#define OBST_IMP_STREAM\n#define OBST_IMP_MALLOC\n"
      	    << "#include <obst_stdinc.h>\n"
            << "#include <string.h>\n";
   agg_iterate (impl, sos_Schema_module imp)
   {  out_yacc << "#include \"" << imp.get_name() << "_use.h\"\n";
   }
   agg_iterate_end (impl, imp);

   //out_yacc << "#define YYDEBUG 1\n";

   // YYSTYPE
   out_yacc << "typedef union {\n";
   agg_iterate_association (symbol_table, sos_String str, stf_Symbol_rule sr)
   {  out_yacc << sr.get_schema_type().get_name() << " u_" << str << ";\n";
   }
   agg_iterate_association_end (symbol_table, str, sr);

   agg_iterate (aux_rules, stf_Item item)
   {  out_yacc << item.get_schema_type().get_name()
	       << " u_" << item.get_schema_type().get_name()
	       << "_" << item._typed_id() << ";\n";
   }
   agg_iterate_end (aux_rules, item);
   out_yacc << "} _YYSTYPE;\n#define YYSTYPE _YYSTYPE\n";

   // modified 19.8.91mr
   // out_yacc << "static sos_Container _stf_cnt;\n"
   out_yacc << "sos_Container _stf_cnt;\n"
	    << "static char* _atoi_string;\n"
	    << "static int _stf_error=0;\n"
	    << "static " << root_type.get_name() << " _stf_root;\n"
            << "void yyerror(char*msg);\n"
	    << "#include \"" << gra_name << "_lex.h\"\n"
            << "%}\n";
   out_yacc << "%%\n";

   // grammar rules

   sos_Bool is_root = TRUE;

   agg_iterate (rules, stf_Rule rl)
   {  if (rl.has_type (stf_Derived_item_rule_type))
      {  stf_Derived_item_rule drl = stf_Derived_item_rule::make (rl);
	 out_yacc << drl.get_symbol().get_name() << ":\n";
	 int item_count = 1;
	 int item_nr = str_item_out (drl.get_item(), item_count);
	 smg_String target = smg_String (is_root?"_stf_root":"$$");
	 is_root = FALSE;
	 smg_String source = smg_String ("$") + item_nr;
	 out_yacc << "\t{";
	 convert (TRUE, drl.get_symbol().get_schema_type(), target,
		  drl.get_item().get_schema_type(), source,
		  drl.get_conversion());
	 out_yacc << "}\n";
      }
      else if (rl.has_type (stf_Derived_string_rule_type))
      {  stf_Derived_string_rule drl = stf_Derived_string_rule::make (rl);
	 if (drl.get_string() == NO_OBJECT) // error rule
	 {  smg_String target = smg_String (is_root?"_stf_root":"$$");
	    is_root = FALSE;
	    out_yacc << drl.get_symbol().get_name() << ":\n\terror\n\t{"
		     << target << "="
		     << drl.get_symbol().get_schema_type().get_name()
		     << "::make(NO_OBJECT);}\n";
	 }
	 else
	 {  out_yacc << drl.get_symbol().get_name() << ":\n"
		     << "\tstf_tok_" << drl.get_string()._typed_id() << "\n";
	    out_yacc << "\t{sos_String _s = sos_String::create(_stf_cnt);\n"
		     << "\t_s.assign_Cstring(\""
		     << drl.get_string() << "\");\n\t";
	    smg_String target = smg_String (is_root?"_stf_root":"$$");
	    is_root = FALSE;
	    smg_String source = smg_String ("_s");
	    convert (TRUE, drl.get_symbol().get_schema_type(), target,
		     sos_string_type, source, drl.get_conversion());
	    out_yacc << "}\n";
	 }
      }
      else if (rl.has_type (stf_Class_rule_type))
      {  stf_Class_rule crl = stf_Class_rule::make (rl);
	 sos_String sym = crl.get_symbol().get_name();
	 sos_Type stp = crl.get_symbol().get_schema_type();

	 out_yacc << sym << ":\n";
	 stf_Component_List cl = crl.get_components();
	 int item_count = 1;
	 int *item_nr, ic=0;
	 item_nr = new int [cl.card()];
	 agg_iterate (cl, stf_Component co)
	 {  if (co.has_type (stf_Item_component_type))
	    {  stf_Item_component ico = stf_Item_component::make (co);
	       item_nr[ic] = str_item_out (ico.get_item(), item_count);
	    }
	    else
	    {  stf_String_component sco = stf_String_component::make (co);
	       sos_String sym = sco.get_string();
	       if (NOT smg_String (sym).equal ("\n"))
	       {  out_yacc << "\tstf_tok_" << sym._typed_id() << "\n";
		  item_count++;
	       }
	    }
	    ic++;
	 }
	 agg_iterate_end (cl, co);
	 smg_String result = smg_String (is_root?"_stf_root":"$$");
         out_yacc << "\t{";
	 if (!is_root) 
            { out_yacc << result << "=" << stp.get_name()
		       << "::create(_stf_cnt);\n";
            };
	 is_root = FALSE;
	 ic=0;
	 agg_iterate (cl, stf_Component co)
	 {  if (co.has_type (stf_Item_component_type))
	    {  stf_Item_component ico = stf_Item_component::make (co);
	       sos_Type ctp =
		  ico.get_component().get_get_method().get_result_type().make_type();
	       sos_Type itp = ico.get_item().get_schema_type();
	       if (ico.get_conversion() != NO_OBJECT)
		  out_yacc << "\t ";
	       else
	          out_yacc << "\t" << ctp.get_name() << " ";
	       smg_String target = smg_String ("_co") + ic;
	       smg_String source = smg_String ("$") + item_nr[ic];
	       convert (TRUE, ctp, target,
			itp, source, ico.get_conversion());
	       char *cn = ico.get_component().get_name().make_Cstring();
	       out_yacc << "\n\t" << result << ".set_" << cn  //+4
			<< "(_co" << ic << ");\n";
	       delete cn;
	    }
	    ic++;
	 }
	 agg_iterate_end (cl, co);
	 out_yacc << "\t}\n";
      }
   }
   agg_iterate_end (rules, rl);

   agg_iterate (aux_rules, stf_Item item)
   {  out_yacc << item.get_schema_type().get_name()
	       << "_" << item._typed_id() << ":\n";

      if (item.has_type (stf_Optional_item_type))
      {  stf_Optional_item oi = stf_Optional_item::make (item);
	 // For optional items in case of absence of the item
	 // a NO_OBJECT is created. This does not work for
	 // scalar types. For the sake of convenience I 
	 // corrected this hack for sos_Int only. mr, 9.8.91
	 out_yacc << "\t{$$=";
	 if( smg_String(item.get_schema_type().get_name()).equal ("sos_Int"))
	    out_yacc << STF_INT_DEFAULT << ";}\n|";
	 else
	    out_yacc << item.get_schema_type().get_name()
		     << "::make(NO_OBJECT);}\n|";

	 int item_count = 1;
	 int item_nr = str_item_out (oi.get_item(), item_count);
	 smg_String target = smg_String ("$$");
	 smg_String source = smg_String ("$") + item_nr;
	 out_yacc << "\t{";
	 convert (TRUE, oi.get_schema_type(), target,
		  oi.get_item().get_schema_type(), source, no_conversion);
	 out_yacc << "}\n";
      }
      else if (item.has_type (stf_Optional_strings_type))
      {  stf_Optional_strings os = stf_Optional_strings::make (item);
	 out_yacc << "\t{$$=FALSE;}\n|";
	 int item_count = 1;
	 str_string_items_out (os.get_strings(), item_count);
	 out_yacc << "\t{$$=TRUE;}\n";
      }
      else if (item.has_type (stf_General_list_item_type))
      {  stf_General_list_item gli = stf_General_list_item::make (item);
	 out_yacc << "\t{$$=" << item.get_schema_type().get_name()
		  << "::create(_stf_cnt);}\n|";
	 int item_count = 1;
	 int item_nr = str_item_out (gli.get_repeated(), item_count);
	 out_yacc << "\t" << item.get_schema_type().get_name()
		  << "_" << item._typed_id() << "\n";
	 smg_String target = smg_String ("_e");
	 smg_String source = smg_String ("$") + item_nr;
	 out_yacc << "\t{" << gli.get_elem_type().get_name()
		  << " _e;\n\t";
	 convert (TRUE, gli.get_elem_type(), target,
		  gli.get_repeated().get_schema_type(), source, no_conversion);
	 out_yacc << "\n\t$$=$" << item_count << ";\n\t$$.insert(1,_e);}\n";
      }
      else if (item.has_type (stf_Non_empty_list_item_type))
      {  stf_Non_empty_list_item nli = stf_Non_empty_list_item::make (item);
	 int item_count = 1;
	 int item_nr = str_item_out (nli.get_repeated(), item_count);
	 smg_String target = smg_String ("_e");
	 smg_String source = smg_String ("$") + item_nr;
	 out_yacc << "\t{" << nli.get_elem_type().get_name()
		  << " _e;\n\t";
	 convert (TRUE, nli.get_elem_type(), target,
		  nli.get_repeated().get_schema_type(), source, no_conversion);
	 out_yacc << "\n\t$$=" << item.get_schema_type().get_name()
		  << "::create(_stf_cnt);\n\t$$.append(_e);}\n|";
	 item_count = 1;
	 item_nr = str_item_out (nli.get_repeated(), item_count);
	 out_yacc << "\t" << item.get_schema_type().get_name()
		  << "_" << item._typed_id() << "\n";
	 target = smg_String ("_e");
	 source = smg_String ("$") + item_nr;
	 out_yacc << "\t{" << nli.get_elem_type().get_name()
		  << " _e;\n\t";
	 convert (TRUE, nli.get_elem_type(), target,
		  nli.get_repeated().get_schema_type(), source, no_conversion);
	 out_yacc << "\n\t$$=$" << item_count << ";\n\t$$.insert(1,_e);}\n";
      }
      else // item.has_type (stf_Separator_list_item_type)
      {  stf_Separator_list_item sli = stf_Separator_list_item::make (item);
	 int item_count = 1;
	 int item_nr = str_item_out (sli.get_repeated(), item_count);
	 smg_String target = smg_String ("_e");
	 smg_String source = smg_String ("$") + item_nr;
	 out_yacc << "\t{" << sli.get_elem_type().get_name()
		  << " _e;\n\t";
	 convert (TRUE, sli.get_elem_type(), target,
		  sli.get_repeated().get_schema_type(), source, no_conversion);
	 out_yacc << "\n\t$$=" << item.get_schema_type().get_name()
		  << "::create(_stf_cnt);\n\t$$.append(_e);}\n|";
	 item_count = 1;
	 item_nr = str_item_out (sli.get_repeated(), item_count);
	 str_string_items_out (sli.get_separator(), item_count);
	 out_yacc << "\t" << item.get_schema_type().get_name()
		  << "_" << item._typed_id() << "\n";
	 target = smg_String ("_e");
	 source = smg_String ("$") + item_nr;
	 out_yacc << "\t{" << sli.get_elem_type().get_name()
		  << " _e;\n\t";
	 convert (TRUE, sli.get_elem_type(), target,
		  sli.get_repeated().get_schema_type(), source, no_conversion);
	 out_yacc << "\n\t$$=$" << item_count << ";\n\t$$.insert(1,_e);}\n";
      }
   }
   agg_iterate_end (aux_rules, item);

   stf_print_yacc_final (root_type.get_name(), gra_name);

   fb_lex.close();
   fb_yacc.close();

   TT (stf_H, T_LEAVE);
}

// ******************end of gen_structurer method****************************
// **************************************************************************

LOCAL ostream& operator<< (ostream& out_f, sos_Typed_id tpid)
{
   T_PROC ("ostream& operator<<");
   TT (stf_H, T_ENTER);

   out_f << sos_Int(tpid.container()) << "_" << tpid.offset();

   TT (stf_H, T_LEAVE);

   return out_f;
}

// *************************************************************************

LOCAL int str_item_out (stf_Item item, int& count)
{  int result;
   if (item.has_type (stf_Symbol_item_type))
   {  stf_Symbol_item si = stf_Symbol_item::make (item);
      result = count;
      out_yacc << "\t" << si.get_symbol().get_name() << "\n";
      count++;
   }
   else if (item.has_type (stf_Item_with_strings_type))
   {  stf_Item_with_strings iws = stf_Item_with_strings::make (item);
      str_string_items_out (iws.get_before(), count);
      result = str_item_out (iws.get_item(), count);
      str_string_items_out (iws.get_after(), count);
   }
   else // aux_rule - item
   {  result = count;
      out_yacc << "\t" << item.get_schema_type().get_name()
	       << "_" << item._typed_id() << "\n";
      count++;
   }
   return result;
}

// ************************************************************************

LOCAL void str_string_items_out (stf_String_symbol_List strings, int& count)
{  agg_iterate (strings, stf_String_symbol sym)
   {  if (NOT smg_String (sym).equal ("\n"))
      {  out_yacc << "\tstf_tok_" << sym._typed_id() << "\n";
	 count++;
      }
   }
   agg_iterate_end (strings, sym);
}

// ***********************************************************************

LOCAL
void convert (sos_Bool for_yacc, sos_Type target_type, smg_String target,
	      sos_Type source_type, smg_String source,
	      sos_String conversion)
{  ostream& sout = (for_yacc) ? out_yacc
   			      : out_lex;
   
   if (conversion != NO_OBJECT)
   {
      sout << "extern " << target_type.get_name() << " " << conversion
	   << "(" << source_type.get_name() << ");\n";
      // If output to yacc file a user defined conversion method
      // is introduced. This is slightly different from all other
      // calls to convert. mr 8.8.91
      if (for_yacc AND target.equal("$$") != 1)
  	 sout << "\t" << target_type.get_name() << " " << target;
      else
  	 sout << "\t" << target;
      sout << "=" << conversion << "(" << source << ");";
   }
   else if (source_type.is_derived_from_some (target_type) OR
            source_type.equal(target_type))

   // modification done to fix bug appearing after switching
   // to OBST3-3.(added "source_type.equal(target_type)")  mp 15-4-93      

	 sout << target << "=" 
	      << source << ";";

   else // source_type .is_derived_from (sos_String_type)
   if (target_type.operator== (sos_Int_type))
      		   //AT&T2.0 QUEERNESS: explicit operator
      sout << "_atoi_string=" << source << ".make_Cstring();\n"
	   << "\t" << target << "=atoi(_atoi_string);\n"
	   << "\tdelete _atoi_string;\n"
	   << "\t" << source << ".destroy();";
   else // source_type .is_derived_from (sos_String_type) AND
	// target_type.is_derived_from (sos_Named_type)
      { if (target.equal("$$") != 1)
           sout << target << "="
	        << target_type.get_name() << "::create(_stf_cnt);\n";
	sout << "\t" << target << ".set_name(" << source << ");";
      }
}

// ******************************************************************

LOCAL smg_String str_unfoldCstring (sos_String s)
{
   char *c = s.make_Cstring();
   char *nc = new char [strlen(c)*2+3];
   nc[0] = '"';
   int l = strlen (c);
   int d = 1;
   for (int i = 0; i < l; i++)
   {
      if ( c[i] == '\\' ) { nc[i+d] = '\\'; d++; nc[i+d]='\\'; }
      else if (c[i] == '"') { nc[i+d] = '\\'; d++; nc[i+d]='"'; }
      else if (c[i] == '\n') { nc[i+d] = '\\'; d++; nc[i+d]='n'; }
      else if (c[i] == '\t') { nc[i+d] = '\\'; d++; nc[i+d]='t'; }
      else nc[i+d]=c[i];
   }
   nc[i+d] = '"';
   nc[i+d+1] = 0;
   delete c;
   return smg_String (nc, SMG_TRANSFER);
}

// ********************************************************************

LOCAL void stf_print_lex_header ()
{
   out_lex << "%{\n"
	   << "extern \"C\" int yyreject();\n"
	   << "extern \"C\" int yylook();\n"
           << "#ifndef FLEX_SCANNER\n"
	   << "extern \"C\" int yyinput();\n"
           << "#ifdef HAVE_YYWRAP\n"
	   << "extern \"C\" int yywrap();\n"
           << "#endif\n"
           << "#endif\n"
	   << "extern \"C\" int yyless(int);\n"
	   << "extern \"C\" int yyback(int*, int);\n"
           << "extern \"C\" void yyoutput (int);\n"
           << "extern \"C\" void yyunput (int);\n"
           << "extern \"C\" YYSTYPE yylval;\n"
	   << "%}\n"
	   << "letter\t[a-zA-Z]\n"
	   << "uletter\t[a-zA-Z_]\n"
	   << "digit\t[0-9]\n"
	   << "udigit\t[0-9_]\n"
	   << "diglet\t[a-zA-Z0-9]\n"
	   << "udiglet\t[a-zA-Z0-9_]\n"
	   << "CCname\t{uletter}({udiglet})*\n"
	   << "CCstring\t\\\"([^\\n\\\"]|\\\\\\\")*\\\"\n"
	   << "CClinecomment\t\"//\"[^\\n]*\\n\n"
	   << "CCmlinecomment\t\"/*\"([^*]|\"*\"+[^*/])*\"*\"+\"/\"\n"
           << "%a 5000\n"   // redefinition of number of transitions
           << "%o 10000\n"   //    "          "   "     " output slots
           << "%e 1100\n"   //    "          "   "     " nodes
           << "%n 600\n"
           << "%p 3100\n"   // redefinition of number of positions
	   << "%%\n";
}

// ********************************************************************

LOCAL
void stf_print_yacc_final (sos_String root_type_name, smg_String grammar_name)
{  out_yacc << "%%\n"
            << "int yyparse();\n"
	    << "void yyerror(char*msg)\n"
            << "{cerr<<\"line \"<<yylineno<<\":\"<<msg<<\"\\n\";"
	    << "_stf_error=1;}\n"

	    << root_type_name << " " << grammar_name
	    << "_structurer(sos_Container cnt)\n"
	    << "{_stf_cnt=cnt;"
            << "_stf_root = " << root_type_name << "::create(_stf_cnt);\n"
            << "yyparse();\n"
	    << "if(_stf_error) return " << root_type_name
	    << "::make(NO_OBJECT); else return _stf_root;}\n"

	    << " sos_String "
            << grammar_name << "_foldCstring (sos_String s) {\n"
	    << " sos_String result=sos_String::create(s.container());\n"
	    << " char *c=s.make_Cstring();\n"
	    << " int l=strlen(c)-1;\n"
	    << " int d=1;\n"
	    << " for (int i=1;i<l;i++){\n"
	    << "  if (c[i] == '\\\\') {\n"
	    << "   d++;i++;\n"
	    << "   if(c[i]=='n') c[i-d]='\\n';\n"
	    << "   else if(c[i]=='t') c[i-d]='\\t';\n"
	    << "   else c[i-d]=c[i];}\n"
	    << "  else c[i-d]=c[i];}\n"
	    << " c[i-d]=0;\n"
	    << " result.assign_Cstring(c);\n"
	    << " delete c;\n"
	    << " return result;}\n";
}
