/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "smg.h"
#include "trc_stf.h"
#include "stf_err.h"
#include "stf_obst.h"

filebuf fb_flt;
ostream out_flt(&fb_flt);


LOCAL  ostream& operator<< (ostream&, sos_Typed_id);
LOCAL  sos_Type converted_type (sos_Type target_type,
                                sos_Type source_type,
                                sos_String conversion);
EXPORT void flt_item_out (stf_Item, smg_String, int);
EXPORT void flt_string_items_out (stf_String_symbol_List);
LOCAL  void unconvert (ostream&, sos_Type, smg_String target,
                       sos_Type, smg_String source,
                       sos_String conversion);
LOCAL  smg_String flt_unfoldCstring (sos_String s);
LOCAL  void stf_print_flt_header ();
LOCAL  void stf_print_flt_final (smg_String);

// **************************************************************************
void stf_Grammar::gen_flattener()
// **************************************************************************
{
   T_PROC ("stf_Grammar::gen_flattener");
   TT (stf_H, T_ENTER);

   smg_String gra_name = smg_String (self.get_name());
   smg_String flt_name = gra_name + "_flt.C";

   sos_Type sos_string_type =
      sos_Type::make (sos_String_type);
   sos_String no_conversion = sos_String::make (NO_OBJECT);

   stf_Imports impl = self.get_imports();
   stf_Item_List aux_rules = self.get_aux_rules();
   sos_String_stf_Symbol_rule_Mapping symbol_table = self.get_symbol_table();
   stf_Structure_rule root_rule = self.get_root_rule();
   stf_Symbol_rule root_sym = root_rule.get_symbol();

   if (fb_flt.open(flt_name.make_Cstring (SMG_BORROW), output) == 0)
   {  err_raise (err_USE, err_STF_OUTPUT_ERROR);
      TT (stf_H, T_LEAVE);
      return;
   }

   // #includes
   out_flt << "#include <stream.h>\n";
   out_flt << "#include <string.h>\n";
   out_flt << "#include \"smg.h\"\n";

   agg_iterate (impl, sos_Schema_module imp)
   {  
       out_flt << "#include \"" << imp.get_name() << "_use.h\"\n";
   }
   agg_iterate_end (impl, imp);
 
   stf_print_flt_header ();
 
   // forward declaration of (static) flattening functions
   agg_iterate_association (symbol_table, sos_String str, stf_Symbol_rule sr)
   {  
      out_flt << "static void flatten_" << sr.get_name() << "(ostream &,"
              << sr.get_schema_type().get_name() << ",int&,int,int,int);\n";
   }
   agg_iterate_association_end (symbol_table, str, sr);
 
   agg_iterate (aux_rules, stf_Item item)
   {  
      out_flt << "static void flatten_" << item._typed_id() << "(ostream &,"
              << item.get_schema_type().get_name() << ",int&,int,int,int);\n";
   }
   agg_iterate_end (aux_rules, item);
 
   // root flattening
   out_flt << "void " << gra_name << "_flattener (ostream &sout,"
           << root_sym.get_schema_type().get_name() << " o){\n"
           << " int cp=0;\n"
           << " flatten_" << root_sym.get_name() << "(sout,o,cp,0,1,0);\n"
           << " sout<<\"\\n\";}\n";
 
   // definition of flattening functions
   agg_iterate_association (symbol_table, sos_String str, stf_Symbol_rule sr)
   {  
      stf_Structure_rule_List rls = sr.get_rules();
      int rls_card = rls.card();
      sos_Type stp = sr.get_schema_type();
      sos_Bool uncond_rule = FALSE;
      out_flt << "static void flatten_" << sr.get_name() << "(ostream &sout,"
              << stp.get_name() << " o,int &cp,int id,int dp,int wf){\n";
 
      agg_iterate (rls, stf_Structure_rule rl)
      {  
         if (uncond_rule)   //error case
         {  char *n = rl.get_symbol().get_name().make_Cstring();
            err_raise (err_WNG, err_STF_AMBIGUOUS_FLATTENING, n);
            delete n;
            break;
         }
         if (rl.has_type (stf_Lexical_rule_type))
         {  stf_Lexical_rule lrl = stf_Lexical_rule::make (rl);
            sos_Type tp = sos_string_type;
            sos_Type isa_tp =
               converted_type (stp, tp, lrl.get_conversion());
            if (rls_card > 1 AND isa_tp.root().has_type (sos_Class_type_type))
               out_flt << " if (o.has_type ("
                       << isa_tp.get_name() << "_type))";
            else
               uncond_rule = TRUE;
            out_flt << " {\n  sos_String i;\n  ";
            smg_String target = smg_String ("o");
            smg_String source = smg_String ("i");
            unconvert (out_flt, stp, target,
                       tp, source, lrl.get_conversion());
            out_flt << "\n  _flt_tok(i)" << ";\n  return;}\n";
         }
         else if (rl.has_type (stf_Derived_item_rule_type))
         {  stf_Derived_item_rule drl = stf_Derived_item_rule::make (rl);
            sos_Type tp = drl.get_item().get_schema_type();
            sos_Type isa_tp =
               converted_type (stp, tp, drl.get_conversion());
            if (rls_card > 1 AND
                NOT isa_tp.equal(stp) AND
                isa_tp.root().has_type (sos_Class_type_type))
               out_flt << " if (o.isa (" << isa_tp.get_name() << "_type))";
            else
               uncond_rule = TRUE;
            out_flt << " {\n  " << tp.get_name() << " i;\n  ";
            smg_String target = smg_String ("o");
            smg_String source = smg_String ("i");
            unconvert (out_flt, stp, target,
                       tp, source, drl.get_conversion());
            out_flt << "\n";
            flt_item_out (drl.get_item(), source, 0);
            out_flt << "  return;}\n";
         }
         else if (rl.has_type (stf_Derived_string_rule_type))
         {  stf_Derived_string_rule drl = stf_Derived_string_rule::make (rl);
            sos_Type isa_tp =
                  converted_type (stp, sos_string_type, drl.get_conversion());
            if (rls_card > 1 AND
                NOT isa_tp.equal(stp) AND
                isa_tp.root().has_type (sos_Class_type_type))
               out_flt << " if (o.isa (" << isa_tp.get_name() << "_type))";
            else
               uncond_rule = TRUE;
            out_flt << " {\n  _flt_tok(" << flt_unfoldCstring (drl.get_string())
                    << ");\n  return;}\n";
            
         }
         else if (rl.has_type (stf_Class_rule_type))
         {  stf_Class_rule crl = stf_Class_rule::make (rl);
            stf_Component_List cl = crl.get_components();
            sos_String sym = crl.get_symbol().get_name();
 
            if (rls_card > 1 AND stp.root().has_type (sos_Class_type_type))
                out_flt << " if (o.has_type (" << stp.get_name() << "_type))";
            else
               uncond_rule = TRUE;
            out_flt << " {\n";
            int ic=0;
            agg_iterate (cl, stf_Component co)
            { 
               if (co.has_type (stf_String_component_type))
               {  stf_String_component sco = stf_String_component::make (co);
                  sos_String sym = sco.get_string();
                  if (smg_String (sym).equal ("\n"))
                     out_flt << "  _flt_donl=1;\n";
                  else
                     out_flt << "  _flt_tok(" << flt_unfoldCstring (sym) << ");\n";
               }
               else // co.has_type (stf_Item_component_type)
               {  stf_Item_component ico = stf_Item_component::make (co);
                  sos_Type ctp =
                     ico.get_component().get_get_method().get_result_type().make_type();
                  sos_Type itp = ico.get_item().get_schema_type();
                  smg_String target = smg_String ("o.get_") +
                                      ico.get_component().get_name() + "()";
                  smg_String source = smg_String ("_co") + ic;
                  out_flt << "  " << itp.get_name() << " " << source << ";\n  ";
                  unconvert (out_flt, ctp, target,
                             itp, source, ico.get_conversion());
                  out_flt << "\n";
                  flt_item_out (ico.get_item(), source, 1);
                  ic++;
               }
            }
            agg_iterate_end (cl, co);
            out_flt << "  return;}\n";
         }
      }
      agg_iterate_end (rls, rl);
      out_flt << "}\n";
   }
   agg_iterate_association_end (symbol_table, str, sr);
 
   agg_iterate (aux_rules, stf_Item item)
   {  
      out_flt << "void flatten_" << item._typed_id() << "(ostream &sout,"
              << item.get_schema_type().get_name()
              << " o,int &cp,int id,int dp,int wf){\n";
 
      if (item.has_type (stf_Optional_item_type))
      {  stf_Optional_item oi = stf_Optional_item::make (item);
         if( strcmp(item.get_schema_type().get_name().make_Cstring(), "sos_Int"))
            out_flt << " if (o !=  NO_OBJECT){\n";
         else
            out_flt << " if (o != 0){\n";
         smg_String source = smg_String ("o");
         flt_item_out (oi.get_item(), source, 0);
         out_flt << " }\n";
      }
      else if (item.has_type (stf_Optional_strings_type))
      {  stf_Optional_strings os = stf_Optional_strings::make (item);
         out_flt << " if (o){\n";
         flt_string_items_out (os.get_strings());
         out_flt << " }\n";
      }
      else // item.isa stf_List_item_type
      {  stf_List_item li = stf_List_item::make (item);
         sos_Type etp = li.get_elem_type();
         if (item.has_type (stf_Separator_list_item_type))
            out_flt << " sos_Bool is_first=TRUE;\n";
         out_flt << " agg_iterate(o," << etp.get_name() << " e){\n";
         if (item.has_type (stf_Separator_list_item_type))
         {  stf_Separator_list_item sli = stf_Separator_list_item::make (item);
            out_flt << "  if(is_first)is_first=FALSE;else{\n";
            flt_string_items_out (sli.get_separator());
            out_flt << "  }\n";
         }
         stf_Item ri = li.get_repeated();
         sos_Type tp = ri.get_schema_type();
         out_flt << "  " << tp.get_name() << " i;\n  ";
         smg_String target = smg_String ("e");
         smg_String source = smg_String ("i");
         unconvert (out_flt, etp, target,
                    tp, source, no_conversion);
         out_flt << "\n";
         flt_item_out (ri, source, 0);
         out_flt << " }\n agg_iterate_end(o,e);\n";
      }
      out_flt << "}\n";
   }
   agg_iterate_end (aux_rules, item);
 
   stf_print_flt_final (gra_name);

   fb_flt.close();
 
   TT (stf_H, T_LEAVE);
}

// ****************end of gen_flattener method************************
// *******************************************************************

LOCAL ostream& operator<< (ostream& out_f, sos_Typed_id tpid)
{
   T_PROC ("ostream& operator<<");
   TT (stf_H, T_ENTER);
 
   out_f << sos_Int(tpid.container()) << "_" << tpid.offset();
 
   TT (stf_H, T_LEAVE);
 
   return out_f;
}

// ******************************************************************

LOCAL
sos_Type converted_type (sos_Type   target_type,
                         sos_Type   source_type,
                         sos_String conversion)
{  sos_Type result;
 
   if (conversion != NO_OBJECT)
      result = target_type;
   else if (source_type.is_derived_from_some (target_type))
      result = source_type;
   else
      result = target_type;
 
  return result;
}

// ******************************************************************* 

EXPORT void flt_item_out (stf_Item item, smg_String source, int inc_indent)
{  if (item.has_type (stf_Symbol_item_type))
   {  stf_Symbol_item si = stf_Symbol_item::make (item);
      out_flt << "  _flt_sym(flatten_" << si.get_symbol().get_name()
              << "," << source << ",id+" << inc_indent << ");\n";
   }
   else if (item.has_type (stf_Item_with_strings_type))
   {  stf_Item_with_strings iws = stf_Item_with_strings::make (item);
      flt_string_items_out (iws.get_before());
      flt_item_out (iws.get_item(), source, inc_indent);
      flt_string_items_out (iws.get_after());
   }
   else // aux_rule - item
      out_flt << "  _flt_sym(flatten_" << item._typed_id()
              << "," << source << ",id+" << inc_indent << ");\n";
}

// *******************************************************************

EXPORT void flt_string_items_out (stf_String_symbol_List strings)
{  agg_iterate (strings, stf_String_symbol sym)
   {  if (smg_String (sym).equal ("\n"))
         out_flt << "  _flt_donl=1;\n";
      else
         out_flt << "  _flt_tok(" << flt_unfoldCstring (sym) << ");\n";
   }
   agg_iterate_end (strings, sym);
}

// *******************************************************************

LOCAL
void unconvert (ostream &sout, sos_Type target_type, smg_String target, 
                sos_Type source_type, smg_String source,
                sos_String conversion)
{
   if (conversion != NO_OBJECT)
      sout << "extern " << source_type.get_name() << " un" << conversion
           << "(" << target_type.get_name() << ");\n  "
           << source << "=un" << conversion << "(" << target << ");";
   else if (source_type.equal (target_type))
      sout << source << "=" << target << ";";
   else if (source_type.is_derived_from_some (target_type))
      sout << source << "=" << source_type.get_name() << "::make("
           << target << ");";

   else if (target_type.operator== (sos_Int_type))
      sout << source
           << " = sos_String::create(TEMP_CONTAINER,"
           << "make_string_from_sos_Int_object(make_sos_Int_object("
           << target << ")));";
 
   else // source_type .is_derived_from (sos_String_type) AND
        // target_type.is_derived_from (sos_Named_type)
      sout << source << "=" << target << ".get_name();";
} 

// ********************************************************************     

LOCAL smg_String flt_unfoldCstring (sos_String s)
{
   if (s == NO_OBJECT)
      return smg_String("\"\"");

   char *c = s.make_Cstring();
   char *nc = new char [strlen(c)*2+3];
   nc[0] = '"';
   int l = strlen (c);
   int d = 1;
   for (int i = 0; i < l; i++)
   { 
      if ( c[i] == '\\' ) { nc[i+d] = '\\'; d++; nc[i+d]='\\'; }
      else if (c[i] == '"') { nc[i+d] = '\\'; d++; nc[i+d]='"'; }
      else if (c[i] == '\n') { nc[i+d] = '\\'; d++; nc[i+d]='n'; }
      else if (c[i] == '\t') { nc[i+d] = '\\'; d++; nc[i+d]='t'; }
      else nc[i+d]=c[i];
   }
   nc[i+d] = '"';
   nc[i+d+1] = 0;
   delete c;
   return smg_String (nc, SMG_TRANSFER);
}

// ********************************************************************

LOCAL void stf_print_flt_header ()
{
   // pretty printing definitions
   // _flt_cid is the indentation of the current line
   // _flt_tok and _flt_sym are macros for formatting lexical tokens
   // or grammar symbols, respectively. _flt_donl is set by a newline
   // string symbol and forces a _fnt_nl. The parameters cp, id, dp, and
   // wf of each flattening function denote the current line position,
   // the indentation level, whether formatting should actually
   // output (dp=1) or just check whether the formatted item fits on
   // the current line (dp=0), and the fact that the item will fit on
   // the current line (due to a check of one of its parent items).
   // function _flt_nl changed to static 20-10-92
   out_flt << "static int _flt_donl=0;\n"
           << "#ifdef NO_PRETTY\n"
           << "#define _flt_tok(tok) sout<<tok<<\"\\n\"\n"
           << "#define _flt_sym(f,o,id) f(sout,o,cp,id,dp,wf)\n"
           << "#else\n"
           << "#ifndef LINE_LENGTH\n"
           << "#define LINE_LENGTH 80\n"
           << "#endif\n"
           << "#ifndef INDENTATION\n"
           << "#define INDENTATION 2\n"
           << "#endif\n"
           << "inline int _flt_len (sos_String s) {return s.get_length();}\n"
           << "inline int _flt_len (char* s) {return strlen(s);}\n"
           << "static int _flt_cid = 0;\n"
           << "static void _flt_nl(ostream &sout,int &cp,int id) {\n"
           << "  sout<<\"\\n\";cp=id*INDENTATION;_flt_cid=id;_flt_donl=0;\n"
           << "  for(int i=cp;i>0;i--)sout<<\" \";}\n"
           << "#define _flt_tok(tok) cp+=_flt_len(tok)+1;\\\n"
           << "\tif(dp){if(_flt_donl||cp>LINE_LENGTH)"
           << "_flt_nl(sout,cp,_flt_cid+1);\\\n"
           << "\tsout<<tok<<\" \";}else if(cp>LINE_LENGTH)return\n"
           << "#define _flt_sym(f,o,id) {int wf1=wf;\\\n"
           << "\tif(dp){if(_flt_donl||_flt_cid>(id))_flt_nl(sout,cp,id);\\\n"
           << "\telse if(!wf&&cp>(id)*INDENTATION)"
           << "{int cp1=cp;f(sout,o,cp1,0,0,0);\\\n"
           << "\twf1=cp1<=LINE_LENGTH;if(!wf1)_flt_nl(sout,cp,id);}}\\\n"
           << "\tf(sout,o,cp,id,dp,wf1);}\\\n"
           << "\tif(!dp&&cp>LINE_LENGTH)return\n"
           << "#endif\n";
}

// ************************************************************************
 
LOCAL void stf_print_flt_final (smg_String grammar_name)
{
   out_flt << "sos_String un"
           << grammar_name << "_foldCstring (sos_String s)\n"
           << "{char *c = s.make_Cstring();\n"
           << " char *nc = new char [strlen(c)*2+3];\n"
           << " nc[0] = '\"';\n"
           << " int l = strlen (c);\n"
           << " int d = 1;\n"
           << " for (int i = 0; i < l; i++){\n"
           << "  if (c[i] == '\\\\'){nc[i+d]='\\\\'; d++; nc[i+d]='\\\\';}\n"
           << "  else if (c[i] == '\"'){nc[i+d]='\\\\'; d++; nc[i+d]='\"';}\n"
           << "  else if (c[i] == '\\n'){nc[i+d]='\\\\'; d++; nc[i+d]='n';}\n"
           << "  else if (c[i] == '\\t'){nc[i+d]='\\\\'; d++; nc[i+d]='t';}\n"
           << "  else nc[i+d]=c[i];}\n"
           << " nc[i+d] = '\"';\n"
           << " nc[i+d+1] = 0;\n"
           << " delete c;\n"
           << " sos_String result = smg_String(nc, SMG_TRANSFER).make_String(TEMP_CONTAINER);\n"
           << " return result;}\n";
}
