/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst.h"
#include "dir_use.h"
#include "sfb_use.h"

extern sfb_Grammar sfb_structurer (sos_Container);
extern void sfb_flattener (ostream&,sfb_Grammar);

int main (int argc, char *argv[])
{  obst_init (argc, argv);

   sos_Container cnt = sos_Container::create();
   sfb_Grammar g = sfb_structurer (cnt);

   if (g != NO_OBJECT)
   {  cnt.commit();
      sos_Object_Directory::set_wd_from_env();
      sos_Directory wd = sos_Object_Directory::get_wd();
      wd.container().open (WRITING, WAITING);
      wd.insert (g.get_name(), g);
      wd.container().close ();

      sfb_flattener (cout, g);
   }
   else
   {  cnt.destroy(); cnt.close();
   }
   return 0;
}
