/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

/* ========================================================================= */
/* IMPLEMENTATION                                                            */
/* ========================================================================= */
/*                                                                           */
/* MODULE : sync_switch                                                      */
/*                                                                           */
/* ORIGINAL                                                                  */
/* AUTHOR: Axel Freyberg                       DATE: 14.09.1992              */
/*                                                                           */
/* CHANGES:                                                                  */
/*                                                                           */
/* PURPOSE: This program switches the synchronization on and off with the    */
/*          parameters 'ON' and 'OFF'. In ths case the returnvalue will be   */
/*          '1' and '0'. If 'MODUS' is used as parameter, the returnvalue    */
/*          will show whether the synchronization is on or off. If a wrong   */
/*          parameter is used, the returnvalue is '-1' and a error message   */
/*          will occure on the screen. If the switch is turned, the          */
/*          SYNC_CONTAINER will be emptied and a new root-object will be     */
/*          created.                                                         */
/*                                                                           */
/* VERSION: none                                                             */
/* ========================================================================= */

#define OBST_IMP_STREAM
#define OBST_IMP_FILE
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"
#include "string.h"
#include "obst.h"
#include "sync_use.h"
#include "sync_decl.h"
#include "sync_err.h"
#include "smg.h"

LOCAL int sync_switch_op (int argc, char *argv[])
{
  int             sw;                               // returnvalue
  sos_Bool	  paramerr = FALSE;
  sos_Open_result result;
  smg_String 	  cnt_name = smg_String (obst_getenv(ENVVAR_CONTAINER))
			     + "/" + 2;
  if (argc != 2)
     paramerr = TRUE;

  else if (streql(argv[1],"ON") || streql(argv[1],"on"))
  {  // enable synchronization and creates SyncContainer, SyncCont and
     // process directory 
     sw = 1;

     int fd = ::open(cnt_name.make_Cstring (SMG_BORROW),
		     O_RDWR | O_CREAT,0664);
     if (fd == -1)
     {  err_raise (err_USE, "cannot create SYNC_CONTAINER", "sync_switch");
	return -1;
     }
     ::close(fd);

#ifndef LOCKD_CORRECT
     cnt_name += ".lck";
     fd = ::open(cnt_name.make_Cstring (SMG_BORROW),O_RDWR | O_CREAT,0664);
     if (fd == -1)
     {  err_raise (err_USE, "cannot create SYNC_CONTAINER.lck", "sync_switch");
	return -1;
     }
     ::close(fd);
#endif

     cnt_name = smg_String (obst_getenv(ENVVAR_CONTAINER)) + "/process";
     mkdir(cnt_name.make_Cstring (SMG_BORROW), 0777);
     chmod(cnt_name.make_Cstring (SMG_BORROW), 0777);

     result = SYNC_CONTAINER.open(WRITING, WAITING);
     if (result != OPENED)
     {  err_raise (err_USE, "cannot open SYNC_CONTAINER", "sync_switch");
	return -1;
     }
     SYNC_CONTAINER.clear(); 
     SyncCont sc = SyncCont::create(SYNC_CONTAINER);
     SYNC_CONTAINER.close();
  }

  else if (streql(argv[1],"OFF") || streql(argv[1],"off"))
  {  // disable synchronization and remove SyncContainer
     unlink(cnt_name.make_Cstring (SMG_BORROW));
#ifndef LOCKD_CORRECT
     cnt_name += ".lck";
     unlink(cnt_name.make_Cstring (SMG_BORROW));
#endif /* LOCKD_CORRECT */
  }

  else if (streql(argv[1],"MODUS") || streql(argv[1],"modus"))
  {  // 'modus' -> output whether synchronization is on
     int fd = ::open(cnt_name.make_Cstring (SMG_BORROW),O_RDONLY);
     if (fd != -1)
     {  ::close(fd);
	sw = 1;
     }
     else
	sw = 0;
  }
  else
     paramerr = TRUE;

  if (paramerr)
  {  cerr << "\nError in sync_switch : wrong parameter \n"
	  << "on    - switches synchronization on \n"
	  << "off   - switches synchronization off \n"
	  << "modus - output of switch \n\n";
     sw = -1;
  }
  return sw;
}

int sync_switch_main (int argc, char* argv[])
{  int status = sync_switch_op (argc, argv);

   if (status != -1)
      cout << "Transactions are switched "
	   << ((status == 1) ? "on" : "off")
	   << ".\n";

   return status;
}
