/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STDCONST
#define OBST_IMP_STREAM
#define OBST_IMP_FORMATTED_IO
#define OBST_IMP_MALLOC
#include "obst_stdinc.h"
#include "obst_trc.h"

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "scp_err.h"
#include "scp_yacc.h"

EXPORT int scp_main (int argc, char *argv[])
{
   T_FILE ("scp.out");  T_REDEF (NULL);

   force_indirect_call =
   scp_do_warnings     = FALSE;

   for (int arg = 1;  arg < argc  &&  argv[arg][0] == '-';  ++ arg)
   {  if (streql (argv[arg], "-force"))
	 force_indirect_call = TRUE;
      else if (streql (argv[arg], "-warn"))
	 scp_do_warnings = TRUE;
      else
      {  err_raise (err_USE, err_SCP_USAGE, NULL, FALSE);
	 return 1;
      }
   }
   if (argc - arg != 2)
   {  err_raise (err_USE, err_SCP_USAGE, NULL, FALSE);
      return 1;
   }

   sos_String n = sos_String::create (TEMP_CONTAINER, argv[arg]);
   scp_mdl = sos_Schema_module::lookup (n);
   n.destroy();
   if (scp_mdl EQ NO_OBJECT)
   {  err_raise (err_USE, err_SCP_NO_SCHEMA, argv[arg], FALSE);
      return 1;
   }

   scp_yyin = fopen (argv[++ arg], "r");
   if (scp_yyin EQ 0)
   {  err_raise (err_USE, err_SCP_NO_FILE, argv[arg], FALSE);
      exit (1);
   }
   cout << "#line 1 \"" << argv[arg] << "\"\n";

   scp_yyparse();

   return (err_occurred (err_USE) || err_occurred (err_SYS)) ? 1 : 0;
}
