/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STDCONST
#define OBST_IMP_STRINGOP
#define OBST_IMP_FORMATTED_IO
#define OBST_IMP_PROCEXEC
#include "obst_stdinc.h"

#include "knl_use.h"
#include "psm.h"
#include "psm_err.h"

#ifndef FALSE
#define FALSE 0
#endif

int cnt_main (int argc, char *argv[])
{
   int do_occupied = 0;
   int do_clean = 0;
   int do_squeeze = 0;
   sos_Sync_mode mode = WAITING;

   int i = 1;
   for (; i < argc && strlen (argv[i]) == 2 && argv[i][0] == '-'; i++)
   {  switch (argv[i][1])
      {  case 'o': do_occupied = 1;	break;
	 case 'd': do_clean = 1;	break;
	 case 's': do_squeeze = 1;	break;
	 case 't': mode = TESTING;	break;
	 default : err_raise (err_USE, err_CNT_USAGE, NULL, FALSE);
		   exit (1);
      }
   }

   if (do_clean + do_occupied + do_squeeze != 1)
   {  err_raise (err_USE, err_CNT_USAGE, NULL, FALSE);
      exit (1);
   }

   if (i != argc-1)
   {  err_raise (err_USE, err_CNT_USAGE, NULL, FALSE);
      exit (1);
   }

   int c, l;
   sscanf (argv[i], "%d%n", &c, &l);
   if (c == 0 || l != strlen (argv[i]))
   {  err_raise (err_USE, err_CNT_USAGE, NULL, FALSE);
      exit (1);
   }

   sos_Container ct = sos_Container::make (c);

   if (do_occupied)
   {  sos_Open_result opened = ct.open (READING, mode);
      if (opened == UNACCESSIBLE)
	 err_raise (err_USE, err_CNT_OPEN_FAILED, NULL, FALSE);
      else if (opened == LOCKED)
	 err_raise (err_USE, err_CNT_CONTAINER_BUSY, NULL, FALSE);
      else
	 printf ("%d\n", ct.occupied ());
   }
   else if (do_clean)
   {  sos_Open_result opened = ct.open (WRITING, mode);
      if (opened == UNACCESSIBLE)
	 err_raise (err_USE, err_CNT_OPEN_FAILED, NULL, FALSE);
      else if (opened == LOCKED)
	 err_raise (err_USE, err_CNT_CONTAINER_BUSY, NULL, FALSE);
      else if (ct.occupied() == 0)
      {  ct.destroy ();
	 ct.close ();
      }
   }
   else if (do_squeeze)
   {  sos_Open_result opened = ct.open (WRITING, mode);
      if (opened == UNACCESSIBLE)
	 err_raise (err_USE, err_CNT_OPEN_FAILED, NULL, FALSE);
      else if (opened == LOCKED)
	 err_raise (err_USE, err_CNT_CONTAINER_BUSY, NULL, FALSE);
      else
	 ct.squeeze ();
   }

   return 0;
}
