/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */
// **************************************************************************
// Module prot                   13-Aug-1993           Bernhard Schiefer (bs)
// **************************************************************************
// implements methods of all classes declared in schema "prot"
// **************************************************************************

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "trc_prot.h" 

#include "prot_obst.h"
#include "prot_err.h"

// -------------------------------------------------------------------------
// sos_MethodModif
// -------------------------------------------------------------------------
// *************************************************************************
void sos_MethodModif::local_initialize(sos_MethodModif mm)
// *************************************************************************
{
   T_PROC("sos_MethodModif::local_initialize");
   TT(prot_M, T_ENTER);

   mm.set_change_params(sos_ParamModif_List::create(mm.container()));

   TT(prot_M, T_LEAVE);
}

// *************************************************************************
void sos_MethodModif::local_finalize(sos_MethodModif mm)
// *************************************************************************
{
   T_PROC("sos_MethodModif::local_finalize");
   TT(prot_M, T_ENTER);

   sos_ParamModif_List pmlist;
   sos_ParamModif      pm;
   
   if (VALID(mm.get_old_name()))
      mm.get_old_name().destroy();
   
   // remove ParamModifs
   pmlist = mm.get_change_params();

   agg_iterate(pmlist, pm);
   {
      pm.destroy();
   } agg_iterate_end(pmlist, pm);

   pmlist.destroy();

   TT(prot_M, T_LEAVE);
}

// *************************************************************************
void sos_MethodModif::add_param(sos_Param param, sos_Int position)
// *************************************************************************
{
   T_PROC("sos_MethodModif::add_param");
   TT(prot_H, T_ENTER);

   sos_ParamModif	pm;

   pm = sos_ParamModif::create(self.container());
   pm.set_modified_param(param);
   pm.set_position      (position);
   pm.set_change        (PROT_ADD);

   self.get_change_params().append(pm);

   TT(prot_H, T_LEAVE);
}
// *************************************************************************
void sos_MethodModif::del_param(sos_Param param)
// *************************************************************************
{
   T_PROC("sos_MethodModif::del_param");
   TT(prot_H, T_ENTER);

   sos_ParamModif       pm;
   sos_Method           meth = self.get_modified_method();

   pm = sos_ParamModif::create(self.container());
   pm.set_modified_param(param);
   pm.set_position      (meth.get_params().find(param));
   pm.set_change        (PROT_DEL);
 
   self.get_change_params().append(pm);

   TT(prot_H, T_LEAVE);
}

// *************************************************************************
void sos_MethodModif::mod_param(sos_Param param)
// *************************************************************************
{
   T_PROC("sos_MethodModif::mod_param");
   TT(prot_H, T_ENTER);

   sos_Container        cnt;
   sos_ParamModif_List  parammodifs;
   sos_ParamModif       pmod;
   sos_ParamModif       pm;
   sos_Method           meth;
   sos_Bool             found = FALSE;
 
   parammodifs = self.get_change_params();

   agg_iterate(parammodifs, pmod)
   { 
      if (pmod.get_modified_param() == param) 
      {  found = TRUE;
         pm    = pmod;
      }
   } agg_iterate_end(parammodifs, pmod);


   if (found)
   {  if (pm.get_change() == PROT_DEL)
      {  // param is deleted
         err_raise(err_SYS, err_PROT_PARAM_DEL, prot_ERR, FALSE); 
      }
   }
   else
   {
      meth = self.get_modified_method(); 
      cnt  = self.container();
      pmod = sos_ParamModif::create(cnt);
      pmod.set_modified_param(param);
      pmod.set_position      (meth.get_params().find(param));
      pmod.set_change        (PROT_MOD);
  
      pmod.set_old_name	     (sos_String::clone(param.get_name(), cnt));
      pmod.set_old_type      (param.get_type());
      pmod.set_old_default   (param.get_default_expr());
      pmod.set_old_ref       (param.get_is_ref());

      parammodifs.append(pmod);
   }

   TT(prot_H, T_LEAVE);
}

// *************************************************************************
void sos_ParamModif::local_finalize(sos_ParamModif pm)
// *************************************************************************
{
   T_PROC("sos_ParamModif::local_finalize");
   TT(prot_M, T_ENTER);

   if (VALID(pm.get_old_name()))
      pm.get_old_name().destroy();

   TT(prot_M, T_LEAVE);
}
