/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#define OBST_IMP_STDCONST
#include "obst_stdinc.h"
#include "_obst_config.h"
#include "obst_progstd.h"
#include "obst.h"

/* ==========================================================================
 * OBST library: initialization / finalization.
 * ==========================================================================
 */
#include "cci_use.h"
#include "smg.h"
#include "cci_incrload.h"

class __obst_dummy__
{ public:
    __obst_dummy__() { _obst_initcore(); }
   ~__obst_dummy__() { cci_incr_ld.fini(); }
};
static __obst_dummy__ _dummy;


/*
 * This is used to force a reference to the static part of the OBST library.
 */
EXPORT int __obst_dummy;


/* ==========================================================================
 * OBST library: exported initialized globals.
 * ==========================================================================
 */

/* --------------------------------------------------------------------------
 * Module "psm"
 */
#include "obst_err.h"
#include "knl_use.h"
#include "psm.h"

// #include "psm_util.h" (bs) 16.4.1994
// to avoid link errors:
extern const err_msg psm_ERR;

const err_msg 	  psm_ERR = "container manager";
const sos_Offset  ROOT_OFFSET = 1024;
			// refer to psm_P in psm_util.h
 			// bytes 0..psm_P-1 used for table of free blocks.

EXPORT sos_Container _TEMP_CONTAINER;
EXPORT sos_Container _ROOT_CONTAINER;
EXPORT sos_Container _SYNC_CONTAINER;
EXPORT sos_Container _UNUSED_CONTAINER;
EXPORT sos_Container _psm_checked_cnt;

const sos_Container &TEMP_CONTAINER   =_TEMP_CONTAINER;
const sos_Container &ROOT_CONTAINER   =_ROOT_CONTAINER;
const sos_Container &SYNC_CONTAINER   =_SYNC_CONTAINER;
const sos_Container &UNUSED_CONTAINER =_UNUSED_CONTAINER;

/* --------------------------------------------------------------------------
 * Module "obst"
 */
#include "obst.h"

EXPORT const char *obst_version       = OBSTVERSION;
EXPORT const char *obst_tempdir       = OBSTTMPDIR;
EXPORT char*      _obst_bootschemas[] = BOOTSCHEMAS;


/* ==========================================================================
 * OBST library: error constants
 * ==========================================================================
 */
/* --------------------------------------------------------------------------
 * Module "agg"
 */
#include "agg_err.h"

const err_msg err_AGG_ARRAY_POS_INVALID="position out of range in array operation";
const err_msg err_AGG_CURSOR_POS_INVALID="invalid cursor position specified";
const err_msg err_AGG_KEY_INVALID="invalid key in mapping operation";
const err_msg err_AGG_LIST_POS_INVALID="position out of range in list operation";
const err_msg err_AGG_WRONG_CURSOR="cursor not opened for that aggregate";

/* --------------------------------------------------------------------------
 * Module "cci"
 */

#include "cci_err.h"

const err_msg err_CCI_INC_LOAD_FAILED="incremental load failed";
const err_msg err_CCI_INC_LOAD_NOT_IMPL="incremental loading facility not installed";
const err_msg err_CCI_INC_LOAD_NO_LOADFCT="incremental loader not defined";
const err_msg err_CCI_INVALID_OBJ="invalid object - accessing uninitialized data?";
const err_msg err_CCI_INVALID_METHOD="no code associated to method";
const err_msg err_CCI_LINK_FAILED="incremental load: ln failed";
const err_msg err_CCI_LOAD_FAILED="incremental load: ld failed";
const err_msg err_CCI_MKEXEC_FAILED="incremental load: failure in making code executable";
const err_msg err_CCI_MOVE_FAILED="incremental load: mv failed";
const err_msg err_CCI_NOT_INITIALIZED="incremental load: OBST not initialized";
const err_msg err_CCI_NOT_STATIC="incremental load: read failed (executable not statically linked?)";
const err_msg err_CCI_NO_DEPENDENCIES="incremental load: empty dependency list";
const err_msg err_CCI_NO_LOAD_IN_BOOT="incremental load: not in *boot* programs - accessing uninitialized data?";
const err_msg err_CCI_OPEN_FAILED="incremental load: open failed";
const err_msg err_CCI_READ_FAILED="incremental load: read failed";
const err_msg err_CCI_READ_HEADER_FAILED="incremental load: read header failed";
const err_msg err_CCI_SEEK_FAILED="incremental load: seek failed";
const err_msg err_CCI_TYPE_ERROR="type error";
const err_msg err_CCI_UNKNOWN_SCHEMA="unknown schema in dependency list";
const err_msg err_CCI_WRITE_FAILED="incremental load: write failed";
const err_msg err_CCI_WRONG_INIT="OBSTINCRLOAD usage: [<context>] [(+|-) [<ld param>...]]";

const err_msg err_SIL_NO_SCHEMA="no such schema";
const err_msg err_SIL_USAGE="usage: sil <schema> [(-l[ibraries]|-o[bjects]|-s[chemas]) <dep>...] [-c[ontext] <ctxt>] [-p[rint]] [-P[RINT]] [-r[emove]] [-R[EMOVE]] [-t[est]]";

/* --------------------------------------------------------------------------
 * Module "dir"
 */
#include "dir_err.h"

const err_msg err_DIR_INVALID_PATH="invalid directory path";
const err_msg err_DIR_NO_DIR="no directory";
const err_msg err_DIR_NO_WD="no working directory";

/* --------------------------------------------------------------------------
 * Module "err"
 */
const err_msg err_NOT_IMPLEMENTED="attempt to execute not implemented function";
const err_msg err_ABSTRACT_METHOD="attempt to execute an abstract method";
const err_msg err_ASSERTION_FAILED="assertion failed";

/* --------------------------------------------------------------------------
 * Module "knl"
 */
#include "knl_err.h"

const err_msg err_KNL_NO_SCHEMA="can't access SOS kernel schema";
const err_msg err_SOS_ILLEGAL_EXT_OP="illegal operation for external type";
const err_msg err_SOS_TYPE_ERROR="incompatible types";
const err_msg err_SOS_INVALID_ASSIGNMENT_TO_LOCAL="attempt to assign an object located in a different container than self";

/* --------------------------------------------------------------------------
 * Module "mta"
 */
EXPORT sos_Container_set mta_impl_opened_cnt;	// from mta_misc.C

#include "mta_err.h"

const err_msg err_MTA_METHOD_NOT_EXECUTABLE="method not executable";

const err_msg err_MTA_L_AND_T_ASSIGN="local_assign and total_assign defined";
const err_msg err_MTA_L_AND_T_EQUAL="local_equal and total_equal defined";
const err_msg err_MTA_L_AND_T_HASH="local_hash_value and total_hash_value defined";
const err_msg err_MTA_L_AND_T_FINALIZE="local_finalize and total_finalize defined";
const err_msg err_MTA_L_AND_T_INIT="local_initialize and total_initialize defined";
const err_msg err_MTA_ASSIGN_WITHOUT_EQUAL="assign is defined but equal is not";
const err_msg err_MTA_EQUAL_WITHOUT_HASH="equal is defined but hash_value is not";
const err_msg err_MTA_INTERNAL="internal error";
const err_msg err_MTA_UNOPENED_CONTAINER="unopened container";
const err_msg err_MTA_SCHEMA_IN_USE="schema is already used from a type or imported from Import";
const err_msg err_MTA_TRANS_IMP_REMOVE="transitive imports and import of KNL cannot be removed";
const err_msg err_MTA_GENERATOR_COULD_NOT_CALLED="generator could not be called";
const err_msg err_MTA_NAME_IN_USE="this name is already used";
const err_msg err_MTA_CONTAINER_YET_OPEN="this container is already open";
const err_msg err_MTA_TYPE_IN_USE="type already in use";
const err_msg err_MTA_SIZE_TOO_BIG="size too big";
const err_msg err_MTA_INVALID_IMPORT="invalid import";
const err_msg err_MTA_IMPORT_NOT_FOUND="import not found";
const err_msg err_MTA_CIRCLED_IMPORT="circular import";
const err_msg err_MTA_INVALID_METHOD="invalid method";
const err_msg err_MTA_NOT_FOUND="not found";
const err_msg err_MTA_TOO_MANY_LITERALS="too many literals";
const err_msg err_MTA_RESERVED_SCHEMA_NAME="reserved schema name";
const err_msg err_MTA_NO_RESERVED_SCHEMA_NAME="no reserved schema name";
const err_msg err_MTA_INVALID_OVERLOADING="invalid overloading";
const err_msg err_MTA_DEFINITE_REDEFINED="definite method redfined";
const err_msg err_MTA_INVALID_REDEFINITION= "invalid redefinition";
const err_msg err_MTA_INVALID_METHOD_NAME="invalid method name";
const err_msg err_MTA_OVERLOADED_METHOD="method is overloaded";
const err_msg err_MTA_OVERLOADED_NOT_FOUND="overloaded method not found";
const err_msg err_MTA_INVALID_ACCESS_RESTR="invalid access restriction";
const err_msg err_MTA_UNDECL_CLASS="undeclared class";
const err_msg err_MTA_AMBIGUOUS_METHODS="ambiguous methods";
const err_msg err_MTA_AMBIGUOUS_TYPES="ambiguous types";
const err_msg err_MTA_INVALID_LOCAL_METHOD="invalid local method";
const err_msg err_MTA_FEW_CREATE_PARAMS="too few create parameter";
const err_msg err_MTA_UNKNOWN_TYPE="unknown type";
const err_msg err_MTA_INVALID_TYPE_NAME="invalid type name";
const err_msg err_MTA_MANY_CREATE_PARAMS="too many create parameter";
const err_msg err_MTA_CLASS_EXPECTED="class expected";
const err_msg err_MTA_MULTIPLE_TYPE_DECL="multiple type declaration";
const err_msg err_MTA_SCHEMA_NOT_EMPTY="schema not empty";
const err_msg err_MTA_DONT_MODIFY_INSTANTIATION="don't modify generic a instantiation";
const err_msg err_MTA_CIRCLED_DECL="circular declaration";
const err_msg err_MTA_GENERIC_CLASS_EXPECTED="generic class expected";
const err_msg err_MTA_GENERIC_PARAM_MISMATCH="generic parameter mismatch";
const err_msg err_MTA_CREATE_PARAM_TYPE_MISMATCH="create parameter type mismatch";
const err_msg err_MTA_METHOD_MUST_NOT_MODIFIED="this method must NOT be modified";
const err_msg err_MTA_INVALID_NAME="invalid name";
const err_msg err_MTA_SUPERCLASS_EXISTS="superclass exists";
const err_msg err_MTA_INVALID_SUPERCLASS="invalid superclass";
const err_msg err_MTA_INVALID_POSITION="invalid position";
const err_msg err_MTA_SYNTAX="syntax error";
const err_msg err_MTA_CREATE_PARAM_USED="create parameter still used";

const err_msg MTA_ERR="schema evolution manager";


/* --------------------------------------------------------------------------
 * Module "psm"
 */
#include "psm_err.h"

// ================= for PSM ===============

const err_msg err_PSM_NO_CNT_NUMBER_ONE = "Container 1 is missing ! Please check your environment-variable $OBSTCONTAINER!";

const err_msg err_PSM_ALLOC_NULL_BYTES = "not allowed to allocate null bytes";
const err_msg err_PSM_CNT_FCNTL_PROG_FLOCK =
                 "containers use fcntl, program uses flock";
const err_msg err_PSM_CNT_FLOCK_PROG_FCNTL =
                 "containers use flock, program uses fcntl";
const err_msg err_PSM_CONTAINER_TABLE_FULL = "container table full";
const err_msg err_PSM_CREATE_FAILED = "cannot create container";
const err_msg err_PSM_CREATE_LOCK_FAILED = "cannot create a lockfile";
const err_msg err_PSM_DEALLOC_NULL_BYTES = 
                 "not allowed to deallocate null bytes";
const err_msg err_PSM_DEALLOCATE_WRONG_OFFSET =
                 "deallocate on table of free blocks(offset<1024)";
const err_msg err_PSM_DESTROY_DURING_CHECKOUT =
                 "destroy() not allowed during checkout";
const err_msg err_PSM_DESTROY_ONLY_PERMITTED_FOR_WRITING =
                 "cannot destroy a container without writing permission";
const err_msg err_PSM_DESTROYED_CONTAINER =
                 "operation is not allowed on a destroyed container";
const err_msg err_PSM_EXISTS = 
                 "error while exists(): invalid containerstatus";
const err_msg err_PSM_FREELIST_CHECK_FAILED =
                 "you read/write/deallocate a part of a block of the freelist";
const err_msg err_PSM_INVALID_ACCESS_MODE = "invalid access mode";
const err_msg err_PSM_INVALID_CURSOR = 
                 "get() on container set with invalid sos_container_cursor";
const err_msg err_PSM_LOST_ALL_LOCKS = 
             "you have lost all locks when trying a write lock to the container";
const err_msg err_PSM_NO_ACCESS = "access() called on unopened container";
const err_msg err_PSM_NONWRITEABLE_CONTAINER = 
                 "container not opened for writing";
const err_msg err_PSM_OPEN_ON_TEMP = 
                 "open() not allowed on temporary container";
const err_msg err_PSM_OPEN_TWICE = 
                 "open() called on opened container";
const err_msg err_PSM_OPERATION_DELETED_DONT_USE = 
                 "deleted() no longer available, use !exists()";
const err_msg err_PSM_PATH_TOO_LONG = 
                 "container path too long";
const err_msg err_PSM_SQUEEZE_WITH_WRONG_STATUS = 
                 "cannot squeeze without writing permission";
const err_msg err_PSM_TEMP_FULL = 
                 "no more space in temporary container";
const err_msg err_PSM_UNOPENED_CONTAINER = 
                 "access to unopened container";
const err_msg err_PSM_WRITEPAGE = "internal error in writepage";
const err_msg err_PSM_WRONG_OFFSET = "access outside allocated area";
const err_msg err_PSM_WRONG_OFFSET_IN_OBJ_EXIST = 
                 "wrong offset when using object_exists()";

const err_msg err_CNT_USAGE = "usage:cnt [-t](-o | -d | -s) <container>";
const err_msg err_CNT_OPEN_FAILED = "cnt: open failed";
const err_msg err_CNT_CONTAINER_BUSY = "cnt: container busy";

const err_msg err_NO_CONTAINER_PATH = 
                 "environment variable OBSTCONTAINER not set";

// ================= for MON ===============

const err_msg err_MON_SERVER_CONNECTION_FAILED = "cannot connect to X server";
const err_msg err_MON_PIXMAP_CREATION_FAILED = "cannot create bitmap";


// ================= for JOYCE =============
 
const err_msg err_PSM_CONTAINER_STILL_OPEN = 
                 "container has to be closed before read_close and write_close";
const err_msg err_PSM_NO_SYNC_CONTAINER = 
                 "cannot find SYNC_CONTAINER";
const err_msg err_PSM_NO_WRITEOPEN_CONTAINER = 
                 "write_close not allowed for only readable containers";
const err_msg err_PSM_SYCT_OPEN_RCL = 
                 "SYNC_CONTAINER has to be open for read_close()";
const err_msg err_PSM_SYCT_OPEN_WCL = 
                 "SYNC_CONTAINER has to be open for write_close()";
const err_msg err_PSM_SYCT_READ_CLOSE = 
                 "read_close not allowed for SYNC_CONTAINER";
const err_msg err_PSM_SYCT_WRITE_CLOSE = 
                 "write_close not allowed for SYNC_CONTAINER";
const err_msg err_PSM_SYCT_WRONG_ACCESS = 
                 "SYNC_CONTAINER can only be accessed with WRITING and WAITING";
const err_msg err_PSM_SYNC = "error in synchronization module during locking";
const err_msg err_PSM_SYNC_IMPLTA_ABORTED = 
    "an implicit transaction had to be aborted because of an error or deadlock";
const err_msg err_PSM_SYNC_NOT_ACTIVATED = 
      "read_close and write_close not allowed if synchronization not activated";
const err_msg err_PSM_SYNC_TA_ABORTED = 
                 "transaction aborted because of deadlock";
const err_msg err_PSM_WRITE_CLOSE = 
                 "error while operation at the end in write_close()";

/* --------------------------------------------------------------------------
 * Module "prot"
 */
#include "prot_err.h"

const err_msg prot_ERR = "schema evolution protocol";
const err_msg err_PROT_SUPERCLASS_ADD = "this superclass already exists";
const err_msg err_PROT_SUPERCLASS_DEL = "this superclass has already been deleted";
const err_msg err_PROT_FRIEND_NO_CLASS = "this friend is not a class";
const err_msg err_PROT_COMP_DEL = "this component has alredy been deleted";
const err_msg err_PROT_PARAM_DEL = "this parameter has already been deleted";
const err_msg err_PROT_SCHEMAMODIF_NOT_KNOWN = "this schemamodif is not found in history";
const err_msg err_PROT_SCHEMA_ADDMOD = "this schema already exists";
const err_msg err_PROT_TYPE_ADDMOD   = "this type already exists";
const err_msg err_PROT_RENTYPE_DEL   = "this type has already been deleted";

/* --------------------------------------------------------------------------
 * Module "sync"
 */
#include "sync_err.h"

const err_msg ERR="Synchronization";
const err_msg err_SYNC_NO_SYNC_CONTAINER="cannot find SYNC_CONTAINER";
const err_msg err_SYNC_NO_SYCT_ROOT="no root_object in SYNC_CONTAINER";
const err_msg err_SYNC_TA_NOT_EXISTS="transaction does not exist";
const err_msg err_SYNC_NO_CREATE_SYNCOBJ="cannot create a new Syncobj";
const err_msg err_SYNC_NO_CREATE_IMPLICIT_TA="cannot create an implicit transaction";
const err_msg err_SYNC_PATH_TOO_LONG="container path too long";
const err_msg err_SYNC_NO_CONTAINER_PATH="environment variable SOSCONTAINER not set";
const err_msg err_SYNC_PIDFILE_CREATE="create of pid-file failed";
const err_msg err_SYNC_PIDFILE_LOCK="lock of pid-file failed";
const err_msg err_SYNC_PIDFILE_OPEN="open of pid-file failed";
const err_msg err_SYNC_NOTA_PROCESS="no transaction belongs to process but pid-file exists";
const err_msg err_SYNC_ACTIVATE_ERR="signal to a running process failed";
const err_msg err_SYNC_TOO_MANY_HOST="too many hosts in table of SYNC_CONTAINER"; 
const err_msg err_SYNC_SOCKET="cannot initialize socket";

/* --------------------------------------------------------------------------
 * Module "trans"
 */
#include "trans_err.h"

const err_msg err_TRANS_CREATE_SECOND="creation of a second instance of the class sos_Transaction is not allowed:perhaps a multiple call of obst_init ?";
const err_msg err_TRANS_ONLY_LOCKING_IMPLEMENTED="transaction is of type LOCKING, because the other methods are not implemented yet";
