 /* --------------------------------------------------------------------------
 * Copyright 1993-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/*
 * This is old/obsolete code which will probably be deleted in the next release
 * and which is probably also buggy.
 * This is a former test program which has been replaced by msh.
 *
 * Things which will have to be changed/checked:
 *  . operator<< (ostream& out_f, sos_Class_type ct)
 *	contains old code
 *  . istream& operator>> (istream& out_f, sos_String s)
 *	reads into fixed-size buffer without setting a limit
 *  . out_sos_Comp_descr
 *	should employ mta interface to learn about the object sizes
 *  . OBST objects should be passed by reference into the operators.
 */

#include "mtool_stream.h"
#include "obst_progstd.h"
#include "smg.h"
#include "mta.h"

#define MTA_BUFSIZE 80

EXPORT istream& operator>> (istream& in_f, sos_String s)
{  char buf[MTA_BUFSIZE];

   in_f >> buf;

   s.assign_Cstring(buf);
   return in_f;
}


LOCAL ostream& operator<< (ostream& out_f, sos_Method_kind kind)
{  switch (kind)
   {  case sos_PRIVATE:   out_f << "private";  break;
      case sos_PUBLIC:    out_f << "public";   break;
      case sos_PROTECTED: out_f << "protected";break;
      default:		  out_f << "@";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_String_List sl)
{  if (VALID (sl))
   {  agg_iterate (sl, sos_String s);
      {  out_f << s << "\n"; }
      agg_iterate_end (sl, s);
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Bool b)
{  out_f << (b ? "TRUE"
	       : "FALSE");
   return out_f;
}

LOCAL void out_sos_Method(ostream&   out_f,
			  sos_Bool   with_class,
			  sos_Bool   with_operator,
			  sos_Bool   with_predefined,
			  sos_Bool   with_kind,
			  sos_Bool   with_abstract,
			  sos_Bool   with_static,
			  sos_Bool   with_generated_from,
			  sos_Method m)
{  if (with_operator)
      if (m.get_is_operator())
	 out_f << "op ";
   if (with_kind)
      out_f << m.get_kind();
   if (with_abstract)
      if (m.get_is_abstract())
	 out_f << "abstract ";
   if (with_static)
      if (m.get_is_static())
	 out_f << "static ";
   if (m.get_is_generated())
      out_f << "G ";
   out_f << m.get_result_type().make_type().get_name() << " ";
   if (with_class)
      out_f << m.get_defined_in().get_name() << "::";
   out_f << m.get_name() << "(";

   sos_Bool	  first = TRUE;
   sos_Param_List mp    = m.get_params();
   if (VALID (mp))
      agg_iterate(mp, sos_Param p)
      {  if (first)
            first = FALSE;
         else
            out_f << ", ";
     
         out_f << p.get_type().make_type().get_name();
         if (p.get_is_ref())
            out_f << "&";
	 if (VALID(p.get_name()))
	    out_f << " " << p.get_name();
         sos_Expr expr = p.get_default_expr();
         if (VALID (expr))
            out_f << " = " << expr;
      }
      agg_iterate_end(mp,p)
   out_f << ");";
  
    /*
   if (with_generated_from)
      if VALID(m.get_generated_from())
      {  out_f << "   from:";
         out_f << m.get_generated_from().get_defined_in().get_name();
      }
   */
} // out_sos_Method

EXPORT ostream& operator<< (ostream& out_f, sos_Expr e)
{  if (INVALID(e))
      out_f << "(sos_Expr:@)";

   else if (e.has_type(sos_Identifier_type))
      out_f << sos_Identifier::make (e).get_id();

   else if (e.has_type(sos_Int_expr_type))
      out_f << sos_Int_expr::make (e).get_value();

   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Expr_List el)
{  if (INVALID(el))
      out_f << "(sos_Expr_List::@)";
   else
   {  sos_Bool first = TRUE;
      out_f << "(";
      agg_iterate(el,sos_Expr e)  
      {  if (first)
	    first = FALSE;
	 else
	    out_f << ",";
	 out_f << e;
      }
      agg_iterate_end(el,sos_Expr e)  
      out_f << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Schema_module sm)
{  if (INVALID(sm))
      out_f << "(sos_Schema_module::@)";
   else
   {  sos_Import_List imports = sm.get_imports();
      if (imports.card() != 0)
      {	 out_f << "with ";
	 sos_Bool first = TRUE;
	 agg_iterate(imports,sos_Import import)
	 {  if (first)
	       first = FALSE;
	    else
	       out_f << ",";
	    out_f << import.get_module().get_name();
	 }
	 agg_iterate_end(imports,import)
	 if (sm.get_has_external_import())
	    out_f << ",extern";
      }
      else if (sm.get_has_external_import())
	 out_f << "with extern";

      out_f << " schema " << sm.get_name();
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Type_descr st)
{  if (INVALID(st))
      out_f << "(sos_Type_descr::@)";
   else
   {  char* pref;

      if (st.has_type(sos_Class_type_type))
	 pref = "class";
      else if (st.has_type(sos_Union_type_type))
	 pref = "union";
      else if (st.has_type(sos_Typedef_type_type))
	 pref = "typedef";
      else if (st.has_type(sos_Enum_type_type))
	 pref = "enum";
      else if (st.has_type(sos_Generic_instantiation_type))
	 pref = "generic";
      else if (st.has_type(sos_Extern_type_type))
	 pref = "extern";
      else if (st.has_type(sos_Gen_param_type))
	 pref = "genpar";
      else
      {  out_f << "(sos_Type_descr:" << st.make_type().get_name() << ")";
	 return out_f;
      }
      out_f << "(" << pref << " " << mta_get_name_declaration(st) << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Type_descr_List stl)
{  if (INVALID(stl))
      out_f << "(sos_Type_descr_List::@)";
   else
   {  sos_Bool first = TRUE;
      cout << "(";
      agg_iterate (stl, sos_Type_descr st)
      {  if (! first)
            cout << ",";
         cout << st;
	 first = FALSE;
      }
      agg_iterate_end (stl, st)
      cout << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Method m)
{  if (INVALID(m))
      out_f << "(sos_Method::@)";
   else
   {  out_f << "(";
      out_sos_Method(out_f, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, m);
      out_f << ")";
   }
   return out_f;
}

LOCAL void out_sos_Comp_descr (ostream&	      out_f,
			       sos_Bool	      with_kind,
			       sos_Comp_descr cd)
{  if (INVALID(cd))
      out_f << "(sos_Comp_descr::@)";
   else
   {  sos_Method get_method = cd.get_get_method(); 
      sos_Method set_method = cd.get_set_method(); 
      if (get_method.get_is_operator() OR set_method.get_is_operator())
	 out_f << "error: component method is operator";

      sos_Class_type ct = get_method.get_defined_in();
      if (with_kind)
	 out_f << get_method.get_kind();
      if (get_method.get_is_abstract() OR set_method.get_is_abstract())
	 out_f << "error:component method is abstract ";
      if (get_method.get_is_static() OR set_method.get_is_static())
	 out_f << "error:component method is static ";
      if (cd.get_is_local())
	 out_f << "local ";

      smg_String     getnm  = get_method.get_name(),
      		     setnm  = set_method.get_name(),
                     compnm = cd.get_name();
      sos_Type_descr getrtd = get_method.get_result_type();
      sos_Type	     getrtp = getrtd.make_type();

      smg_String expctdnm = smg_String("get_") + compnm;
      if (! expctdnm.equal (getnm))
	 out_f << "error: wrong name: " << getnm << "\n";

      expctdnm = smg_String("set_") + compnm;
      if (! expctdnm.equal (setnm))
	 out_f << "error: wrong name: " << setnm << "\n";

      if (INVALID(get_method.get_params()))
	 out_f << "error: " << getnm << ".get_params = NO_OBJECT@\n";
      else if (get_method.get_params().card() != 0)
	 out_f << "error: " << getnm << " has parameters\n";
      if (set_method.get_params().card() != 1)
	 out_f << "error: " << setnm << " has no parameters\n";

      if (set_method.get_result_type() != sos_Type_descr::make(void_type))
	 out_f << "error:" << setnm
	       << " has " << set_method.get_result_type().make_type().get_name()
	       << " as result type (expected 'void')\n";
      if (getrtd != set_method.get_params().get_nth(1).get_type())
	 out_f << "error: " << getnm << "/" << setnm
	       << " have incompatible types";
     
      sos_Int comp_size = 0;
      if (VALID(getrtp) AND getrtp.is_scalar())
         comp_size += getrtp.get_object_size();
      else if (cd.get_is_local())
	 comp_size += SOS_OFFSET_SIZE;
      else
	 comp_size += SOS_TYPED_ID_SIZE;
  
      out_f << getrtp.get_name() << " " << compnm;
      if (VALID(cd.get_init_expr()))
	 out_f << " = " << cd.get_init_expr();

      out_f << "; {" << cd.get_offset() << "," << comp_size << "}";
   }
} // out_sos_Comp_descr

EXPORT ostream& operator<< (ostream& out_f, sos_Comp_descr cd)
{  if (INVALID(cd))
      out_f << "(sos_Comp_descr::@)";
   else
      out_sos_Comp_descr(out_f, TRUE, cd);
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Comp_descr_List cdl)
{  if (INVALID(cdl))
      out_f << "(sos_Comp_descr::@)";
   else if (cdl.card() != 0)
   {  agg_iterate (cdl, sos_Comp_descr cd)
         out_f << cd;
      agg_iterate_end (cdl, cd);
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Container cnt)
{  if (cnt == TEMP_CONTAINER)
      out_f << "(Tmp_Cnt)";
   else if (cnt == ROOT_CONTAINER)
      out_f << "(Root_Cnt)";
   else if (cnt.status() != DESTROYED)
   {  sos_Object ro = cnt.root_object();
      if (ro.has_type(sos_Schema_module_Directory_type))
	 out_f << "(Schema_Dir)";
      else if (ro.has_type(sos_Schema_module_type))
	 out_f << "(" << sos_Schema_module::make(ro).get_name() << ")";
      else
	 out_f << "(" << (sos_Int)cnt << ")";
   }
   else
      out_f << "(" << (sos_Int)cnt << ")";

   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Container_set cnt_set)
{  if (cnt_set.card() == 0)
      out_f << "(sos_Container_set:@)";
   else
   {  out_f << "{";
      sos_Bool first = TRUE;
      cnt_iterate(cnt_set, sos_Container cnt)
      {   if (first)
	    first = FALSE;
	  else 
	     out_f << ",";

	  if (cnt == TEMP_CONTAINER)
	    out_f << "TmpCnt";
	  else if (cnt == ROOT_CONTAINER)
	     out_f << "RootCnt";
          else if (cnt.status() != DESTROYED)
	  {  sos_Object ro = cnt.root_object();
	     if (ro.has_type(sos_Schema_module_Directory_type))
		out_f << "(SchemaDir)";
	     else if (ro.has_type(sos_Schema_module_type))
		out_f << "(" 
		      << sos_Schema_module::make(ro).get_name() << ")";
	     else
		out_f << (sos_Int)cnt;
	  }
	  else
	     out_f << (sos_Int)cnt;
       }
      cnt_iterate_end (cnt_set, cnt);
      out_f << "}";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Method_List ml)
{  if (INVALID(ml))
      out_f << "(sos_Method_List::@)";
   else
   {  out_f << "(";
      if (ml.card() > 1)
	 out_f << "\n";
	 
      agg_iterate(ml, sos_Method m)
      { 
         out_f << " " << m << "\n";
      }
      agg_iterate_end(ml, m);
      out_f << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Method_table mt)
{  if (INVALID(mt))
      out_f << "(sos_Method_table:@)";
   else
   {  out_f << "(sos_Method_table:";
      sos_Bool first = TRUE;
      for (sos_Cursor c = mt.open_cursor();  mt.is_valid(c);  mt.to_succ(c))
      {  sos_Method_List ml = mt.get_info(c);
	 if (! first)
	 {  first = FALSE;
	    out_f << "  ";
	 }
	 if (ml.card() == 1)
	    out_f << ml.get_nth(1) << "\n";
	 else
	 if (ml.card() == 0)
	    out_f << mt.get_key(c) << "-> @\n";
	 else   
	    out_f << mt.get_key(c) << "->" << mt.get_info(c);
	 out_f << "   ";
      }
      mt.close_cursor(c);
      out_f << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Type tn)
{  out_f << "(sos_Type:";
   if (INVALID(tn))
      out_f << "@)";
   else
      out_f << tn.get_name() << ")";
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Type_List tnl)
{  if (INVALID(tnl))
      out_f << "(sos_Type_List:@)";
   else
   {  out_f << "(sos_Type_List:{";
      int i = tnl.card();
      agg_iterate(tnl, sos_Type tn)
      {  out_f << tn.get_name();
	 if (i-- > 1)
	    out_f << ",";
      }
      agg_iterate_end (tnl, tn)
      out_f << "})";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Param p)
{  if (INVALID(p))
      out_f << "(sos_Param:@)";
   else
   {  out_f << "(sos_Param:" << p.get_type().make_type().get_name();
      if (VALID(p.get_name()))
	 out_f << " " << p.get_name();
      if (p.get_is_ref())
	 out_f << "&";
      if (VALID(p.get_default_expr()))
         out_f << " = " << p.get_default_expr();
      out_f << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Param_List pl)
{  if (INVALID(pl))
      out_f << "(sos_Param_List:@)";
   else
   {  out_f << "(";
      int i = pl.card();
      agg_iterate(pl,sos_Param p)
      {  out_f << p.get_type().make_type().get_name();
	 if (p.get_is_ref())
	    out_f << "&";
         if (VALID(p.get_name()))
	    out_f << " " << p.get_name();
	 if (VALID(p.get_default_expr()))
	    out_f << " = " << p.get_default_expr();
	 if (i-- > 1)
	    out_f << ",";
      }
      agg_iterate_end(pl,p)
      out_f << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Generic_instantiation gi)
{  if (INVALID(gi))
      out_f << "(sos_Generic_instantiation:@)";
   else
   {  out_f << "(" << gi.get_gen_class().get_generic_class().get_name() << "<";

      sos_Bool		  first = TRUE;
      sos_Type_descr_List tdl   = gi.get_act_gen_params();
      agg_iterate(tdl, sos_Type_descr tn)
      {  if (first)
	    first = FALSE;
	 else
	    out_f << ",";
         out_f << tn;
      }
      agg_iterate_end(tdl, sos_Type_descr tn);
      out_f << ">";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Gen_param gp)
{  if (INVALID(gp))
      out_f << "(sos_Gen_param:@)";
   else
   {  out_f << gp.get_name();
      if (VALID(gp.get_super_type()))
	 out_f << ":" << gp.make_type().get_name();
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Super_class sc)
{  if (INVALID(sc))
      out_f << "(sos_Super_class:@)";
   else
   {  out_f << mta_get_name_declaration(sc.get_super_class());
      if (VALID (sc.get_create_params()))
	 out_f << sc.get_create_params();
      out_f << "{" << sc.get_offset() << "})";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Super_class_List scl)
{  if (INVALID(scl))
      out_f << "(sos_Super_class_List:@)";
   else
   {  sos_Bool first = TRUE;
      out_f << "(";
      agg_iterate(scl,sos_Super_class sc)  
      {  if (first)
	    first = FALSE;
	 else
	    out_f << ",";
	 out_f << sc.get_super_class().make_type().get_name();
      }
      agg_iterate_end(scl,sc)  
      out_f << ")";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Gen_param_List gpl)
{  if (INVALID(gpl))
      out_f << "(sos_Gen_param_List:@)";
   else
   {  out_f << "(sos_Gen_Param_List:{";
      int i = gpl.card();
      agg_iterate(gpl, sos_Gen_param gp)
      {  out_f << "[" << gp.get_name() << ":" << gp.make_type().get_name();

         if (VALID(gp.get_super_type()))
	    out_f << " sc:" << gp.get_super_type().make_type().get_name();
	 out_f << "]";

	 if (i-- > 1)
	    out_f << ",";
      }
      agg_iterate_end(gpl, gp);
      out_f << "})";
   }
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Class_type ct)
{  out_f << "class " << ct.make_type().get_name();
   sos_Gen_param_List gpl = ct.get_formal_gen_params();
   if (VALID (gpl))
   {  out_f << "<";
      sos_Bool first = TRUE;
      agg_iterate (gpl, sos_Gen_param gp)
      {  if (first)
	    first = FALSE;
         else
	    out_f << ",";
         out_f << gp;
      }
      agg_iterate_end (gpl, gp)
      out_f << ">";
   }
   sos_Super_class_List super_classes = ct.get_super_classes();
   sos_Super_class_List scl = ct.get_super_closure();
   /*
   agg_iterate(scl,sos_Super_class sc)
   {  if sc.get_super_class() == ct)
	 out_f << "{" << sc.get_offset() << "," << ct.get_local_size() << "}";
   }
   agg_iterate_end(scl,sc);
   */
   sos_Param_List pl = ct.get_create_params();
   if (VALID(pl))
      out_f << pl;

   if (VALID(super_classes))
   {  out_f << ":";
      int i = super_classes.card();
      agg_iterate(super_classes, sos_Super_class sc)
      {  if (! sc.make_type().has_type (sos_Object_type))
	 {  out_f << sc;
	    if (i-- > 1)
	       out_f << ",";
         }
      }
      agg_iterate_end(super_classes, sc);
   }
   out_f << "\n";
   /*
   if VALID(scl)
   {  out_f << "super_closure:(";
      sos_Int i = 1;
      agg_iterate(scl, sos_Super_class sc)
      {  out_f << sc.get_super_class().make_type().get_name();
	 out_f << "{" << sc.get_offset() << "}";
	 if VALID(sc.get_create_params())
	 {
	    out_f << "(";
	    sos_Int i = 1;
	    agg_iterate(sc.get_create_params(),sos_Expr e)
	    {  
	       if (e.has_type(sos_Identifier_type))
	          out_f << sos_Identifier::make(e).get_id();
	       if (e.has_type(sos_Int_expr_type))
	          out_f << sos_Int_expr::make(e).get_value();
	       if (i++<pl.card())
		  out_f << ",";
	    }
	    agg_iterate_end(sc.get_create_params(),e)
            out_f << ")";
	 }
      }
      agg_iterate_end(scl,sc)
      out_f << ")";
   }
   */
   sos_Bool first_after_mark = TRUE;
   sos_Type_List friends = ct.get_friends();
   if (VALID(friends) && friends.card() != 0)
   {  if (first_after_mark)
      {   out_f << "  ";
	  first_after_mark = FALSE;
      }
      else
	 out_f << "   ";
      out_f << "friend class ";
      int i = friends.card();
      agg_iterate(friends, sos_Type tp)
      {  out_f << tp.get_name();
	 if (i-- > 1)
	    out_f << ",";
      }
      agg_iterate_end(friends, tp)
      out_f << ";\n";
   }
   // out_f << "   gen_params:" << ct.get_gen_params();
   // out_f << "   init_comps:" << ct.get_has_init_comps();
   // out_f << "   is_abstract:" << ct.get_is_abstract();
   // out_f << "   generated_from:" << ct.get_generated_from();
   // out_f << "   root_name:" << ct.get_root_name();

   sos_Bool	       first_method = TRUE;
   sos_Method_kind     act_get_kind;
   sos_Method_kind     act_set_kind;
   sos_Comp_descr_List components = ct.get_components();
   agg_iterate(components, sos_Comp_descr cd)
   {
      sos_Method get_method = cd.get_get_method();
      sos_Method set_method = cd.get_set_method();
      if (get_method.get_defined_in() == ct)
      {  if (first_after_mark)
	 {  out_f << "  ";
	    first_after_mark = FALSE;
         }
         else 
	    out_f << "   ";

         if (   first_method
	     OR act_get_kind != get_method.get_kind()
	     OR act_set_kind != set_method.get_kind())
	 {  first_method = FALSE;
            act_get_kind = get_method.get_kind();
            act_set_kind = set_method.get_kind();

	    out_f << act_get_kind;
	    if (act_get_kind != act_set_kind)
	       out_f << ", " << act_set_kind << " set";
	    out_f << ":\n   ";
         }
	 out_f << "   ";
	 out_sos_Comp_descr(out_f, FALSE, cd);
	 out_f << "\n";
      }
   }
   agg_iterate_end(components, cd)

   sos_Method_List local_methods = ct.get_local_methods();
   agg_iterate(local_methods, sos_Method m)
   {  
      if (INVALID (m.get_comp_descr()) AND  m.get_defined_in() == ct)
      {  if (first_after_mark)
	 {  out_f << "  ";
	    first_after_mark = FALSE;
         }
         else 
	    out_f << "   ";
         if (first_method OR act_get_kind != m.get_kind())
	 {  first_method = FALSE;
	    out_f << (act_get_kind = m.get_kind());
         }
	 out_f << "   ";
	 out_sos_Method(out_f, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, m);
         out_f << "\n";
	 if (! ct.is_derived_from_some(sos_Type::make(m.get_defined_in())))
	    out_f << "error:defined_in wrong:" 
		  << m.get_defined_in().get_name() << "\n";
      }
   }
   agg_iterate_end(local_methods, m)

   out_f << "}; // *** class " << ct.get_name() << " *** \n";
   return out_f;
}

EXPORT ostream& operator<< (ostream& out_f, sos_Object o)
{
   if (INVALID (o))
      out_f << "(" << o.type().get_name() << ":@)";

   else if (o.has_type(sos_String_type))
      out_f << sos_String::make(o);
   else if (o.has_type(sos_String_List_type))
      out_f << sos_String_List::make(o);
   else if (o.has_type(sos_Int_type))
      out_f << "(sos_Int:" << make_sos_Int(o) << ")";
   else if (o.has_type(sos_Method_type))
      out_f << sos_Method::make(o);
   else
      out_f << "(" << o.type().get_name() << ":" << (sos_Int)o.container()
	    				  << ";" << o.offset() << ")";
   return out_f;
}
