#line 1 "./src/mta/mta_prot.C"
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST Projekt", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#include "mta.h"

#define OBST_IMP_FORMATTED_IO
#define OBST_IMP_STRINGOP
#define OBST_IMP_ERROR
#define OBST_IMP_FILE
#include "obst_stdinc.h"

#ifdef OBST_HAVE_PROT
EXPORT sos_SchemaModif mta_get_schema_mod_from_cnt (const sos_Container& cnt)
{
   T_PROC ("mta_get_schema_modif");
   TT (mta_M, T_ENTER);

   sos_Schema_module sm   = sos_Schema_module::retrieve (cnt);
   sos_SchemaModif   smod = sos_SchemaModif::mod_schema (sm);
   
   TT (mta_M, T_LEAVE);
   return smod;
}
#endif

#ifdef OBST_HAVE_PROT
EXPORT sos_TypeModif mta_get_type_mod (const sos_Container&  cnt,
				       const sos_Type_descr& td)
{
   T_PROC ("mta_get_type_mod");
   TT (mta_M, T_ENTER);

   sos_SchemaModif smod = mta_get_schema_mod_from_cnt (cnt);
   sos_TypeModif   cmod = sos_TypeModif::make(NO_OBJECT);
   
   if (VALID(smod))
      cmod = smod.mod_type (td);

   TT (mta_M, T_LEAVE);
   return cmod;
}
#endif

#ifdef OBST_PROT_ALL
EXPORT sos_MethodModif mta_get_method_mod (const sos_Container& cnt,
					   const sos_Method&	m)
{
   T_PROC ("mta_get_method_mod");
   TT (mta_M, T_ENTER);

   sos_MethodModif result = sos_MethodModif::make(NO_OBJECT);
   sos_ClassModif  cmod = sos_ClassModif::make(
			      MTA_GET_TYPE_MOD (cnt, m.get_defined_in()));
   if (VALID (cmod))
      result = cmod.mod_meth (m);

   TT (mta_M, T_LEAVE);
   return result;
}
#endif
