/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST Projekt", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#include "mta_use.h"
#include "obst_progstd.h"
#include "mta_err.h"
#include "smg.h"

void mta_error (const err_class ec, err_msg msg)
{ 
   err_raise (ec, msg, MTA_ERR,  FALSE);
} // *** mta_error ***
     
void mta_error (const err_class ec,err_msg msg, const sos_Cstring s)
{  smg_String errmsg = smg_String((char*)msg) + "::" + s;

   err_raise (ec, errmsg.make_Cstring(SMG_BORROW), MTA_ERR);
}

void mta_error (const err_class ec, err_msg msg, const sos_String& s)
{ 
   smg_String errmsg = (char*)msg;
   if (VALID (s))
      errmsg += smg_String("::") + s;

   err_raise (ec, errmsg.make_Cstring(SMG_BORROW), MTA_ERR);
} // *** mta_error ***

void mta_error (const err_class   ec, err_msg           msg,
		const sos_String& s1, const sos_String& s2)
{ 
   smg_String errmsg = smg_String((char*)msg) + "::" + s1 + ":" + s2;

   err_raise (ec, errmsg.make_Cstring(SMG_BORROW), MTA_ERR);
} // *** mta_error ***

void mta_internal_error (sos_Cstring where)
{  cerr << err_last_origin() << "::"
        << err_last_raised() << "\n";
   mta_error (err_SYS, err_MTA_INTERNAL, where);
}

void mta_repeat_last_error ()
{
   mta_error (err_last_class(), err_last_raised());
} // *** mta_error ***
