#ifndef _MTA_H
#define _MTA_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe 1, Germany.
 * --------------------------------------------------------------------------
 */

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "mta_err.h"
#include "mta_obst.h"
#include "trc_mta.h"

#ifdef OBST_HAVE_PROT
#include "prot_use.h"
#endif

// --------------------------- mta_misc.C -----------------------------------

// stores all containers which are implicitely opened by mta operations
// These containers will be handled with mta_commit/mta_reset/mta_open_container
extern sos_Container_set mta_impl_opened_cnt;


// --------------------------- mta_schema.C ---------------------------------

extern sos_Import	mta_get_import    (const sos_Schema_module&,
					   const sos_Schema_module&);

extern sos_Import_mode  mta_uses	  (const sos_Type_descr&,
					   const sos_Type_descr&);
extern sos_Import_mode  mta_uses	  (const sos_Typedef_type&,
					   const sos_Type_descr&);
extern sos_Import_mode  mta_uses	  (const sos_Schema_module&,
					   const sos_Type_descr&);

extern sos_Type_descr   mta_lookup_type	  (const sos_String&);
extern sos_Bool		mta_is_bootschema (const sos_String&);

#define mta_remove_from_list(l,o) \
	   internal_remove_from_list (sos_Object_List::make (l),\
				      sos_Object::make (o))


// ---------------------------- mta_type.C -----------------------------------

extern sos_Extern_type   mta_create_extern	(const sos_Schema_module&);
extern sos_Union_type    mta_create_union	(const sos_Schema_module&);
extern sos_Enum_type     mta_create_enum	(const sos_Schema_module&);
extern sos_Typedef_type  mta_create_typedef	(const sos_Schema_module&);
extern sos_String	 mta_get_name           (const sos_Type_descr&);

extern smg_String        mta_generate_type_name (const sos_Schema_module&,
						 const smg_String&);

extern void 		 mta_destroy		(sos_Expr);
extern void 		 mta_destroy		(sos_Super_class);
extern void 		 mta_destroy		(sos_Super_class_List);
extern void 		 mta_destroy		(sos_Comp_descr);
extern void 		 mta_destroy		(sos_Comp_descr_List);
extern void 		 mta_destroy		(sos_Gen_param);
extern void 		 mta_destroy		(sos_String);
extern void 		 mta_destroy		(sos_Gen_param_List);

#define MTA_GET_NAME(tp) mta_get_name(OBST_CAST(sos_Type_descr,tp))


// ---------------------------- mta_meth.C -----------------------------------

extern sos_Expr mta_copy		   (const sos_Expr&, sos_Container);
extern void     mta_build_methodtable      (const sos_Class_type& ct);
extern void     mta_build_class		   (const sos_Class_type&, sos_Bool,
					    sos_Bool = FALSE,
					    sos_Bool = FALSE,
					    sos_Bool = FALSE,
					    sos_Bool = FALSE);
extern void     mta_init_methods           (const sos_Class_type&);
extern void     mta_complete_components    (const sos_Class_type&);
extern void     mta_complete_local_methods (sos_Class_type);
extern sos_Bool mta_dominates		   (const sos_Method&,
					    const sos_Method&);
extern sos_Int  mta_comp_size              (const sos_Comp_descr&);
extern sos_Gen_param_List
		mta_get_agpl_of_superclass (const sos_Class_type&,
					    const sos_Class_type&);

extern void	mta_destroy		   (sos_Method_table);
extern void	mta_destroy		   (sos_Method_List);
extern void	mta_destroy		   (sos_Method);
extern void	mta_destroy		   (sos_Param);
extern void	mta_destroy		   (sos_Param_List);

#define MTA_ADD_PARAM(pl,n,tn,de) mta_add_param(pl,n,tn,OBST_CAST(sos_Expr,de))


// ---------------------------- mta_gen.C ------------------------------------

extern sos_Generic_instantiation mta_get_instantiation  (sos_Class_type,
							 sos_Class_type,
							 sos_Type_descr_List);
extern sos_String		 mta_instantiation_name (sos_String, 
							 sos_Type_descr_List,
							 sos_Bool = TRUE);


// ---------------------------- mta_prot.C -----------------------------------
#ifdef OBST_HAVE_PROT

extern sos_SchemaModif mta_get_schema_mod_from_cnt (const sos_Container&);
extern sos_TypeModif   mta_get_type_mod		   (const sos_Container&,
						    const sos_Type_descr&);
extern sos_MethodModif mta_get_method_mod	   (const sos_Container&,
						    const sos_Method&);

#define MTA_GET_TYPE_MOD(cnt,tp)\
		mta_get_type_mod(cnt,OBST_CAST(sos_Type_descr,tp))
#endif


// ---------------------------- mta_class.C ----------------------------------

extern void		   mta_destroy		    (sos_Generic_instantiation);
extern void		   mta_set_offsets_and_size  (sos_Class_type ct);
extern sos_Class_type_List mta_using_classes	     (const sos_Type_descr&);
extern sos_Import_mode	   mta_uses		     (const sos_Class_type&,
						      const sos_Type_descr&);
extern sos_Class_type	   mta_create_class	     (const sos_Schema_module&);
extern void		   mta_reset_subclass_cache  (sos_Class_type);
extern sos_Expr		   mta_get_default_from_param(const sos_Param&,
						      const sos_Container&);

#define MTA_USING_CLASSES(et)\
		mta_using_classes(OBST_CAST(sos_Type_descr, et))
#define MTA_DERIVED_FROM(sub,super)\
		mta_derived_from(OBST_CAST(sos_Type_descr,sub),\
				 OBST_CAST(sos_Type_descr,super))


// ----------------------------- mta_out.C -----------------------------------

extern sos_String      mta_get_name_declaration (const sos_Type_descr&);

extern sos_String_List mta_get_declaration      (const sos_Type_descr&);
extern void	       mta_generate_schema_file (const sos_Schema_module&);
extern void	       mta_schema_declaration   (ostream&,
						 const sos_Schema_module&);

#define MTA_GET_NAME_DECLARATION(tp)\
		mta_get_name_declaration(OBST_CAST(sos_Type_descr,tp))


// ---------------------------- mta_super.C ----------------------------------

extern void	       mta_enter_object_as_sc  (sos_Class_type,
						sos_Super_class_List);

extern sos_Super_class mta_super_class_in_list (const sos_Super_class_List&,
						const sos_Type_descr&);

extern void	       mta_set_super_closure   (sos_Class_type);

#define MTA_SUPER_CLASS_IN_LIST(scl,tp)\
		mta_super_class_in_list(scl,OBST_CAST(sos_Type_descr,tp))
#define MTA_APPEND_SUPER_CLASS(scl,ct,cpl,isd)\
		mta_append_super_class(scl,OBST_CAST(sos_Type_descr,ct),cpl,isd)


// ----------------------------- mta_misc.C ----------------------------------

extern void	  mta_open_for_writing	    (const sos_Container& cnt);

extern smg_String mta_generate_valid_name
                        (const smg_String&,
                         const sos_Object&,
                         sos_Bool _valid(const sos_Object&,const sos_String&));

extern void	  mta_destroy_list	    (const sos_Object_List&);
extern sos_Bool   internal_remove_from_list (const sos_Object_List&,
					     const sos_Object&);

#define MTA_GENERATE_VALID_NAME(n,o,f)\
		mta_generate_valid_name(n,OBST_CAST(sos_Object,o),f)
#define MTA_DESTROY_LIST(sl)\
		mta_destroy_list(OBST_CAST(sos_Object_List,sl))


LOCAL inline sos_Type mta_get_void_type()
{  return _obst_knl_type (_THE_VOID_TYPE); }

LOCAL inline sos_Type mta_get_int_type()
{  return _obst_knl_type (_THE_INT_TYPE); }

LOCAL inline sos_Type mta_get_container_type()
{  return _obst_knl_type (_THE_CNT_TYPE); }

LOCAL inline sos_Type mta_get_bool_type()
{  return _obst_knl_type (_THE_BOOL_TYPE); }

LOCAL inline sos_Type mta_get_eqkind_type()
{  return _obst_knl_type (_THE_EQKIND_TYPE); }

LOCAL inline sos_Type mta_get_object_type()
{  return _obst_knl_type (_THE_OBJECT_TYPE); }

#endif /* _MTA_H */
