/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// Module gen_main                                         Juergen Uhl (ju)
//
// **************************************************************************
// OBST interface generator
// **************************************************************************
//
// tracing conventions: see trc_genCC.h

#define OBST_IMP_STDCONST
#include "obst_stdinc.h"

#ifdef PROFILE
extern "C" void monitor(...);
#endif

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "genCC_err.h"
#include "trc_genCC.h"
#include "mta_use.h"
#include "mta.h"

#include "genCC.h"


//------- global definitions -----------------------------------------------

sos_Bool gen_inline;
sos_Bool gen_is_boot_schema;


//------- main program -----------------------------------------------------

EXPORT int gen_main (int argc, char *argv[])
{  T_FILE ("gen.out");
   T_REDEF(NULL);

   int status = 0;

   int i = 1;
   if (argc >= 2 AND streql (argv[1], "-I"))
   {  gen_inline = TRUE;
      i++;
   }
   else
      gen_inline = FALSE;

   if (argc != i+1)
   {  err_raise (err_USE, err_GEN_USAGE, NULL, FALSE);
      status = 1;
   }
   else
   {  sos_String schema_name = sos_String::create (TEMP_CONTAINER, argv[i]);
      sos_Schema_module sch = sos_Schema_module::lookup (schema_name);
      gen_is_boot_schema = mta_is_bootschema (schema_name);
				
      if INVALID(sch)
	 err_raise (err_USE, err_GEN_INVALID_SCHEMA, argv[i]);
      else
	 front_module (sch);
   }
   if (err_occurred (err_SYS) + err_occurred (err_USE) > 0)
      status = -1;

#ifdef PROFILE
   monitor (0);
#endif

   T_EXIT ();
   return status;
}
