/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#ifndef _GENCC_H
#define _GENCC_H

// ****** FRONTEND **********************************************************

extern void front_module (sos_Schema_module);

enum Predef_Method {CREATE, COPY, CLONE, DESTROY,

                    ASSIGN,     LOCAL_ASSIGN,
		    EQUAL,      LOCAL_EQUAL, 
                    HASH_VALUE, LOCAL_HASH_VALUE,

                    LOCAL_INITIALIZE, LOCAL_FINALIZE,

                    CONTAINER,    OFFSET,           COMPARE_IDS,
		    OP_IDENTICAL, OP_NOT_IDENTICAL, IDENTICAL,

                    _CREATE, _CREATE_COMPS, _COPY, _COPY_COMPS, _CLONE, 

                    MAKE_HANDLE, MAKE_CP_HANDLE, MAKE_SC_HANDLE,

                    NOT_PREDEF, GENERIC_PATCH, OVERLOADED_INHERITED};

// ----------  global settings  ---------------------------------------------

extern sos_Bool gen_inline;
extern sos_Bool gen_is_boot_schema;


// ****** CODE GENERATION **************************************************

extern void code_initialize ();

extern Predef_Method code_whatis (smg_String, int, sos_Bool);

extern void          code_class_start (sos_Class_type, sos_Param_List);
extern void          code_additional_methods ();

extern void          code_method_start (sos_Method, sos_Type, sos_Param_List);
extern void          code_param_list ();
extern void          code_init_patch (sos_Method);

extern smg_String    code_expr (sos_Expr, smg_String, smg_String);
 
extern smg_String    code_abstract_method ();
extern smg_String    code_comp_method ();
extern smg_String    code_generate_body (Predef_Method);
extern smg_String    code_method_call_impl (smg_String);
extern smg_String    code_univ_body();
extern smg_String    code_method_patch(smg_String, Predef_Method);

// ****** BACKEND ***********************************************************

// ----------  schema handling  ---------------------------------------------

extern void     back_schema_start (sos_String, sos_Bool);
extern void     back_schema_end ();
extern void     back_import (smg_String, sos_Import_mode);

// ----------  type handling  -----------------------------------------------

extern sos_Bool back_types_start ();

extern sos_Bool back_enum_start (smg_String, sos_Typed_id, int);
extern void     back_enum_literal (smg_String);
extern void     back_enum_end ();

extern sos_Bool back_typedef_start (smg_String, sos_Typed_id);
extern void     back_typedef_end (sos_Type, smg_String, sos_Bool);

extern sos_Bool back_extern_start (smg_String, sos_Typed_id);
extern void     back_extern_end ();

extern void     back_scalar_superclass(smg_String);

extern sos_Bool back_union_start (smg_String, sos_Typed_id);
extern void     back_union_type (smg_String, sos_Bool);
extern void     back_union_end ();

// -------- class type ------------------------------------------------------

extern sos_Bool back_class_is_root;

extern sos_Bool back_class_start (smg_String, sos_Typed_id, smg_String, 
                                  sos_Bool, sos_Bool, int);
extern void     back_class_end ();

extern sos_Bool back_super_class_start ();
extern void     back_super_class (smg_String, smg_String,
				  int, sos_Bool, sos_Bool);
extern void     back_super_class_end ();
extern void     back_friend (smg_String);

// -------- method handling -------------------------------------------------

extern sos_Bool   is_static, is_void, OBSThis_param;
extern smg_String nm_method, nm_result_type;

extern void       back_methods_start ();
extern void       back_methods_end ();

extern sos_Bool   back_method_start (sos_Method,
				     smg_String, smg_String, 
                                     sos_Bool, sos_Bool, sos_Bool,
                                     sos_Bool, sos_Bool, sos_Bool, sos_Bool,
                                     sos_Method_kind, Predef_Method, 
                                     int = -1);
extern void       back_method_end();

extern void       back_param (smg_String, smg_String, sos_Bool,
			      sos_Bool,   sos_Expr,   sos_Bool = TRUE);
extern void       back_param_end ();

extern smg_String back_call_method (smg_String, smg_String, sos_Bool, 
				    sos_Bool,   sos_Bool,   smg_String);


// --------  decision/code markers  ----------------------------------------

#define FIXED_FCT(c)			c
#define FIXED_NAME(c)			c
#define FIXED_TYPE(c)			c
#define FIXED_SCHEMA(c)			c

#define SCALAR_EXCEPTION(c)		c
#define GCC_SPECIFIC(c)			c
#define ATT_SPECIFIC(c)			c
#define CALL_STATIC_OF_BASE_BUG		1
#define EXPLICIT_TYPECAST_BUG		1
#define EXPLICIT_ABSTRACT_BUG(c)	c
#define COMPLICATED_ARGUMENT_BUG	1
#define FLOAT_PATCH(c)			c
#define OVERLOADED_INHERITED_PATCH(c)   c

#define ABSTRACT_SHORTCUT(c)		c
#define GENERAL_UNIV_SHORTCUT(c)	c
#define NO_COMPS_SHORTCUT(c)		c
#define sos_OBJECT_SHORTCUT(c)		c
#define SPLIT_CREATE_SHORTCUT(c)	c
#define SUPERCL_SHORTCUT(c)		c
#define ATTRSET_METHOD_SHORTCUT(c)	c


// --------  string constants  ---------------------------------------------

extern char* NL;
extern char* _ID;

extern char* make_TYPE_OBJ;
extern char* cvt_from_EXTERN;
extern char* cvt_to_EXTERN;
extern char* cvt_from_LOCAL;
extern char* cvt_to_LOCAL;

extern char* get_IMPL_OBJ;
extern char* set_IMPL_OBJ;
extern char* set_STRING_FCT;
extern char* set_EXTCVT_FCT;

extern char* nm_UNIV_PREF;
extern char* nm_GEN_UNIV_PREF;
extern char* set_UNIV_FCT;

extern char* nm_ROOT;
extern char* nm_IMPL_ROOT;
extern char* nm_SCALAR_ROOT;

extern char* IMPL_comp;
extern char* call_IMPL;

extern char* THIS_comp;
extern char* THIS_param;
extern char* THIS_param_type;
extern char* THIS_param_decl;
extern char* make_THIS;

extern char* OBJ_container;
extern char* OBJ_offset;
extern char* OBJ_typed_id;
extern char* OBJ_type_ID;

extern char* nm_local_ctor;
extern char* nm_total_ctor;
#endif
