/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-7500 Karlsruhe 1, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// Module cfe_super                                          Juergen Uhl (ju)
//
// **************************************************************************
// OBST schema compiler front end (cfe)
// **************************************************************************
//
// tracing conventions: see trc_cfe.h

#include "cfe.h"

// LOCAL


EXPORT void cfe_check_super_classes (sos_Class_type ct, sos_Super_class_List tnl)
// Checks the correct use of super classes given in list 'tnl'. A class
// specified as super class of any other class must be declared before.
{
   T_PROC ("cfe_check_super_classes");
   TT (cfe_H, T_ENTER);

   sos_Cursor c = tnl.open_cursor();
   for (sos_Bool valid = tnl.is_valid (c); valid;)
   {  sos_Super_class tn = tnl.get(c);
      sos_Bool error = FALSE;
      if (tn.get_super_class().has_type (sos_Gen_param_type))
      {  cfe_error (err_USE, err_CFE_UNDECL_CLASS,
		    sos_Gen_param::make(tn.get_super_class()).get_name());
	 error = TRUE;
      }
      else
      {
	 if (tn.make_type().has_type (sos_Class_type_type))
	 {
	    sos_Class_type sct=sos_Class_type::make(tn.make_type());
	    // check for "class A : A"
	    if (ct.operator==(sct))	//ATT2.0 QUEERNESS: explicit operator
	    {  cfe_error (err_USE, err_CFE_UNDECL_CLASS,
				   tn.make_type().get_name());
	       error = TRUE;
	    }
	    // check, if superclass was forward
	    if INVALID(sct.get_methods())
	    {
	       error = TRUE;
	       cfe_error (err_USE, err_CFE_UNKNOWN_TYPE);
	    }

	    // check create parameters
	    sos_Param_List fpl = sct.get_create_params();
	    sos_Expr_List apl;
	    sos_Int fc, ac;
	    apl = tn.get_create_params();
	    if INVALID(apl)
	       ac = 0;
	    else
	       ac = apl.card();
	    if INVALID(fpl)
	       fc = 0;
	    else
	       fc = fpl.card();
	    if (fc < ac)
	    {
	       smg_String s = smg_String ("(") + fc + " create params) " 
			      + tn.make_type().get_name();
	       sos_String ss = s.make_String (TEMP_CONTAINER);
	       cfe_error (err_USE, err_CFE_MANY_CREATE_PARAMS, ss);
	       error = TRUE;
	       ss.destroy();
	    }
	    else
	    {  sos_Bool has_defaults = TRUE;
	       for (ac++; ac <= fc; ac++)
	       {  if INVALID(fpl.get_nth (ac).get_default_expr())
		  {  has_defaults = FALSE;
		     break;
		  }
	       }
	       if (NOT has_defaults)
	       {
		  smg_String s = smg_String ("(") + fc + " create params) " 
				 + tn.make_type().get_name();
		  sos_String ss = s.make_String (TEMP_CONTAINER);
		  cfe_error (err_USE, err_CFE_FEW_CREATE_PARAMS, ss);
		  error = TRUE;
		  ss.destroy();
	       }
	    }
	 }
	 else  // superclass was no sos_Class_type
	 {
	    cfe_error (err_USE, err_CFE_CLASS_EXPECTED, 
		       tn.make_type().get_name());
	    error = TRUE;
         }
      }

      if (error)
      {  tnl.remove_at(c);
	 valid = tnl.is_valid(c);
      }
      else
	 valid = tnl.to_succ(c);
   }
   tnl.close_cursor (c);

   if (tnl.card() == 0)  // due to errors superclass list became empty
      // This causes sos_Object to be entered as sc, if ct != sos_Object
      mta_enter_object_as_sc (ct, tnl);

   TT (cfe_H, T_LEAVE);
}
