#line 1 "./src/agg/Mapping.C"
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#include "agg.h"

/* **************************** ******** ****************************** */
/* Module Mapping.c 		20/10/92		Jochen Alt (ja) */
/* **************************** ******** ****************************** */

void _sos_Object_sos_Object_Mapping::change_list_cursor (const sos_Typed_id&_OBSThis,sos_Bool new_lc)
const{  sos_Object_sos_Object_Mapping_impl old_impl = get_impl(_OBSThis);

   agg_Impl impl_type = get_impl_type(_OBSThis);
   sos_Bool kboe = get_role1_based_on_equal(_OBSThis);
   sos_Bool iboe = get_role2_based_on_equal(_OBSThis);

   sos_Object_sos_Object_Mapping new_m =
      sos_Object_sos_Object_Mapping::create (_OBSThis.container(),
					     new_lc, kboe,iboe,impl_type);

   sos_Object_sos_Object_Mapping_impl new_impl = new_m.get_impl();
   agg_iterate_association (old_impl, sos_Object key, sos_Object info)
      new_impl.insert (key,info);
   agg_iterate_association_end (old_impl, key, info)

      // switch  the implementations
   set_impl (_OBSThis,new_impl);
   new_m.set_impl (old_impl);

      // destroy yet created Mapping with old Mapping_impl
   new_m.destroy();
} // ** Mapping::change_list_cursor ***


void _sos_Object_sos_Object_Mapping::local_initialize 
					 (OBST_PARDECL(sos_Object_sos_Object_Mapping) m)
{  sos_Object_sos_Object_Mapping_impl im;
   sos_Container cnt = m.container();
   agg_Impl impl_type = m.get_impl_type();
   sos_Bool lc = m.get_list_cursor();
   sos_Bool kboe = m.get_role1_based_on_equal();
   sos_Bool iboe = m.get_role2_based_on_equal();

   switch (impl_type)
   {  case AGG_LIST:  
         im = sos_Object_sos_Object_Mapping_List::create (cnt, lc, kboe, iboe);
         break;
      case AGG_HASH:
         im = sos_Object_sos_Object_Mapping_Hash::create (cnt,lc,kboe,iboe);
         break;
      case AGG_AUTOMATIC:
         im = sos_Object_sos_Object_Mapping_List::create (cnt, lc, kboe, iboe);
         break;
      default:
         err_assert (FALSE,"Mapping::invalid implementation type");
	 break;
   }
   m.set_impl (im);
} // *** Mapping::local_initialize ***
 
void _sos_Object_sos_Object_Mapping::change_impl_type 
					       (const sos_Typed_id&_OBSThis,agg_Impl new_impl_type)
const{  
   sos_Container cnt = _OBSThis.container();
   if ((new_impl_type != AGG_AUTOMATIC) AND
       (new_impl_type != get_impl_type(_OBSThis)))
   {  
      sos_Object_sos_Object_Mapping_impl old_impl = get_impl(_OBSThis);
      sos_Object_sos_Object_Mapping_impl new_impl =
         sos_Object_sos_Object_Mapping_impl::make (NO_OBJECT);
      sos_Bool kboe = get_role1_based_on_equal(_OBSThis);
      sos_Bool iboe = get_role2_based_on_equal(_OBSThis);
      sos_Bool lc   = get_list_cursor(_OBSThis);
      switch (new_impl_type)
      {  case AGG_LIST:
            new_impl = sos_Object_sos_Object_Mapping_List::create 
						     (cnt, lc, kboe,iboe);
            break;
         case AGG_HASH:
            new_impl = sos_Object_sos_Object_Mapping_Hash::create 
						     (cnt, lc, kboe, iboe);
            break;
         case AGG_AUTOMATIC: // suppress warning
	    break;
      }

      agg_iterate_association (old_impl, sos_Object key,sos_Object info)
      {  new_impl.insert (key, info); }
      agg_iterate_association_end (old_impl, key,info)
      
      set_impl (_OBSThis,new_impl);
      old_impl.destroy();
   }
   set_impl_type (_OBSThis,new_impl_type);

   if (new_impl_type == AGG_AUTOMATIC)
      check_impl_type(_OBSThis,get_impl(_OBSThis));
} // *** Mapping::change_impl_type ***

void _sos_Object_sos_Object_Mapping::check_impl_type 
				(const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_sos_Object_Mapping_impl) m)
// if automatic, change the implementation type if the conditions are right
const{  if (get_impl_type(_OBSThis) == AGG_AUTOMATIC)
   {  sos_Int c = card(_OBSThis);
      if (c > 12) 
      {	if (m.has_type 
		(sos_Object_sos_Object_Mapping_List_type))
	{  change_impl_type (_OBSThis,AGG_HASH);
	   set_impl_type (_OBSThis,AGG_AUTOMATIC);
	}
      }
      else if (c < 8)
      {   if (m.has_type 
	       (sos_Object_sos_Object_Mapping_Hash_type))
          {  change_impl_type (_OBSThis,AGG_LIST);
	     set_impl_type (_OBSThis,AGG_AUTOMATIC);
          }
      }
   }
} // ** Mapping:check_impl_type ***

void _sos_Object_sos_Object_Mapping::local_assign 
			     (OBST_PARDECL(sos_Object_sos_Object_Mapping) m,OBST_PARDECL( sos_Object) o)
// change the implementation type and assign 
{  sos_Object_sos_Object_Mapping om = 
      sos_Object_sos_Object_Mapping::make (o);
   m.clear();
   sos_Object_sos_Object_Mapping_impl o_impl= om.get_impl();
   if (o_impl.has_type (sos_Object_sos_Object_Mapping_List_type))
      m.change_impl_type (AGG_LIST);
   else if (o_impl.has_type (sos_Object_sos_Object_Mapping_Hash_type))
      m.change_impl_type (AGG_HASH);

   m.get_impl().assign (o_impl); 

   if (om.get_impl_type() == AGG_AUTOMATIC)
      m.change_impl_type (AGG_AUTOMATIC);
} // *** Mapping::local_assign ***

sos_Bool _sos_Object_sos_Object_Mapping::local_equal 
	      (OBST_PARDECL(sos_Object_sos_Object_Mapping) m,OBST_PARDECL( sos_Object) o, sos_Eq_kind e)
{ 
   sos_Object_sos_Object_Mapping_impl m_impl = m.get_impl();
   sos_Object_sos_Object_Mapping_impl o_impl = 
      sos_Object_sos_Object_Mapping::make(o).get_impl();

   if (m_impl.type().operator== (o_impl.type())) //ATT2.0 QUEERNESS: explicit operator
      return m_impl.equal (o_impl, e);
   else
   {  sos_Bool result = TRUE;

      if (o_impl.card() != m_impl.card())
	 result = FALSE;
      else
      {  sos_Bool info_based_on_equal = m.get_role2_based_on_equal();
	 agg_iterate_association (m_impl, sos_Object key, sos_Object info)
	 {  if (NOT agg_same_entity (o_impl[key],info,
				     info_based_on_equal,e))
	    {  result = FALSE;
	       break;
	    }
	 }
	 agg_iterate_association_end (m_impl, key, info);
      }
      return result;
   }
} // *** Mapping::local_equal ***
 

sos_Bool _sos_Object_sos_Object_Mapping::is_key (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) key)
const{   return get_impl(_OBSThis).is_key (key); } 

sos_Bool _sos_Object_sos_Object_Mapping::is_info (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) info)
const{   return get_impl(_OBSThis).is_info (info); } 

void _sos_Object_sos_Object_Mapping::insert (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) key,OBST_PARDECL( sos_Object) info)
const{ sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
  m.insert (key,info); 
  check_impl_type(_OBSThis,m);
}

void _sos_Object_sos_Object_Mapping::remove (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) key)
const{ sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
  m.remove (key);
  check_impl_type(_OBSThis,m);
}

sos_Object _sos_Object_sos_Object_Mapping::__index (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) key)
const{ return get_impl(_OBSThis)[key]; }

// Cursor operations that do not modify the Mapping or the cursor
// don't need to check the correct node type, because these
// operations just use the mother-class sos_Mapping_node instead the
// implementation specialized classes sos_Mapping_Hash_node or
// sos_Mapping_List_node
sos_Object _sos_Object_sos_Object_Mapping::get_key (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{  return get_impl(_OBSThis).get_key (c); }

sos_Object _sos_Object_sos_Object_Mapping::get_info (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{  return get_impl(_OBSThis).get_info (c); }

void _sos_Object_sos_Object_Mapping::set_info (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c,OBST_PARDECL( sos_Object) info)
const{   get_impl(_OBSThis).set_info (c,info); }

sos_Bool _sos_Object_sos_Object_Mapping::move_cursor 
					  (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c,OBST_PARDECL( sos_Object) key)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   return m.move_cursor (c,key); 
}

void _sos_Object_sos_Object_Mapping::insert_before 
			    (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c,OBST_PARDECL( sos_Object) key,OBST_PARDECL( sos_Object) info)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   m.insert_before (c,key,info); 
   check_impl_type(_OBSThis,m);
}

void _sos_Object_sos_Object_Mapping::insert_after 
			    (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c,OBST_PARDECL( sos_Object) key,OBST_PARDECL( sos_Object) info)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   m.insert_after (c,key,info); 
   check_impl_type(_OBSThis,m);
}

sos_Int _sos_Object_sos_Object_Mapping::size (const sos_Typed_id&_OBSThis) 
const{ return _sos_Object::size(_OBSThis) + get_impl(_OBSThis).size(); }

sos_Bool _sos_Object_sos_Object_Mapping::is_role1 (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) key) 
const{ return get_impl(_OBSThis).is_role1 (key); }

sos_Bool _sos_Object_sos_Object_Mapping::is_role2 (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) info) 
const{ return get_impl(_OBSThis).is_role2 (info); }

sos_Object _sos_Object_sos_Object_Mapping::get_role1 (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c) 
const{ return get_impl(_OBSThis).get_role1 (c); }

sos_Object _sos_Object_sos_Object_Mapping::get_role2 (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c) 
const{ return get_impl(_OBSThis).get_role2 (c); }

void _sos_Object_sos_Object_Mapping::clear(const sos_Typed_id&_OBSThis)
const{ get_impl(_OBSThis).clear(); }

void _sos_Object_sos_Object_Mapping::remove_at (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{ sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
  m.check_node_type (c);
  m.remove_at(c); 
  check_impl_type (_OBSThis,m);
}

sos_Int _sos_Object_sos_Object_Mapping::card(const sos_Typed_id&_OBSThis)
const{  return get_impl(_OBSThis).card(); }

sos_Cursor _sos_Object_sos_Object_Mapping::open_cursor (const sos_Typed_id&_OBSThis,sos_Container cnt)
const{  return get_impl(_OBSThis).open_cursor(cnt); }

void _sos_Object_sos_Object_Mapping::close_cursor (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{  get_impl(_OBSThis).close_cursor (c); }

sos_Cursor _sos_Object_sos_Object_Mapping::duplicate 
(const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, sos_Container cnt /* = TEMP_CONTAINER*/)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   return m.duplicate (c,cnt); 
}

sos_Bool _sos_Object_sos_Object_Mapping::is_valid (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{ return get_impl(_OBSThis).is_valid (c); }

sos_Bool _sos_Object_sos_Object_Mapping::to_first (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   return m.to_first (c); 
}

sos_Bool _sos_Object_sos_Object_Mapping::to_last (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type(c);
   return m.to_last (c); 
}

sos_Bool _sos_Object_sos_Object_Mapping::to_succ (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, sos_Int i)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   return m.to_succ (c,i); 
}

sos_Bool _sos_Object_sos_Object_Mapping::to_pred (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, sos_Int i)
const{  sos_Object_sos_Object_Mapping_impl m = get_impl(_OBSThis);
   m.check_node_type (c);
   return m.to_pred (c,i); 
}

void _sos_Object_sos_Object_Mapping::local_finalize 
					      (OBST_PARDECL(sos_Object_sos_Object_Mapping) m)
{  m.get_impl().destroy(); }


sos_Int _sos_Object_sos_Object_Mapping::local_hash_value (OBST_PARDECL(sos_Object_sos_Object_Mapping) m)
{ return m.get_impl().hash_value(); }

// check if the node c.get_current() has the corroesponding type to
// the current implementation
void _sos_Object_sos_Object_Mapping_impl::check_node_type (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
const{  sos_Object_sos_Object_Mapping_impl m = sos_Object_sos_Object_Mapping_impl::make(_OBSThis,this);
   sos_Node n = c.get_current();
   n.check_list_cursor (sos_Object_sos_Object_Mapping_impl::make(_OBSThis,this));
   sos_Node  new_node;
   if (NOT (n.has_type (sos_Mapping_List_node_type))
      AND (m.has_type (sos_Object_sos_Object_Mapping_List_type)))
   {  new_node = sos_Mapping_node::create (c.container(), get_list_cursor(_OBSThis));
      sos_Object key = sos_Mapping_node::make (n).get_key();
      n.destroy();
      m.move_cursor (c, key);
   }
} // ** check_node_type **

