/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#define OBST_IMP_FORMATTED_IO
#include "obst_stdinc.h"

#include "agg.h"

#include "mta_use.h"
#include "smg.h"

// **************************************************************************
// Module Aggregate                 30/08/89           Bernhard Schiefer (bs)
//
// **************************************************************************
// implements methods of classes: sos_Aggregate, sos_Cursor
// **************************************************************************

// **************************************************************************
sos_Bool agg_same_entity (const sos_Object& o1, const sos_Object& o2,
		          sos_Bool based_on_equal, sos_Eq_kind eq_kind)
// **************************************************************************
{  if (based_on_equal)
      return o1.equal(o2, eq_kind);
   else
      return o1.identical(o2);
}


// **************************************************************************
sos_Bool sos_Aggregate::is_empty ()
// **************************************************************************
{
   T_PROC ("sos_Aggregate::is_empty");
   TT (agg_H, T_ENTER);

   sos_Bool result = (sos_Bool)(self.card() == 0);

   TT (agg_H, T_LEAVE; TI (result));
   return result;
} // ** is_empty **

// **************************************************************************
void sos_Aggregate::clear ()
// **************************************************************************
{
   T_PROC ("Aggregate::clear");
   TT (agg_H, T_ENTER);

   sos_Cursor c = self.open_cursor ();

   for ( ;
	 self.is_valid (c);
	 self.remove_at (c) ) ; // no body

   self.close_cursor (c);

   TT (agg_H, T_LEAVE);
} // ** clear **


// *******************************   sos_Cursor   ***************************

// **************************************************************************
void sos_Cursor::local_initialize (sos_Cursor c)
// **************************************************************************
{
   T_PROC ("sos_Cursor::local_initialize");
   TT (agg_H, T_ENTER);

   c.set_current (sos_Node::make (NO_OBJECT));

   TT (agg_H, T_LEAVE);
} // ** local_initialize **


// **************************************************************************
sos_Bool sos_Cursor::defined_for (sos_Aggregate agg)
// **************************************************************************
{
   T_PROC ("sos_Cursor::defined_for")
   TT (agg_H, T_ENTER);

				//ATT2.0 QUEERNESS: explicit operator
   sos_Bool result = (sos_Bool)(agg.operator==(self.get_domain()));

   TT (agg_H, T_LEAVE);
   return result;

}

// **************************************************************************
void sos_Node::check_list_cursor (sos_Aggregate agg)
// **************************************************************************
// checks wheather the flag list_cursor that was actual while
// the cursor was opened matches with the current list_cursor of the
// aggregate. It doesn't matter if the cursor has a list cursor, but
// not the aggregate; otherwise give an error.
// 
{  if (NOT self.get_list_cursor())
      if (agg.get_list_cursor())
         err_raise(err_SYS, "list_cursor match error",
                            "sos_Node::check_list_curor");
}


LOCAL inline sos_Int make_sos_Int (sos_Cstring s)
{  return atoi (s);
}
 
 
LOCAL sos_Bool make_sos_Bool (sos_Cstring s)
{  if (streql (s,"TRUE"))
      return TRUE;
   else
   if (streql (s, "FALSE"))
      return FALSE;

   err_assert (FALSE,"sos_Aggregate::make_sos_Bool:invalid value");
   return FALSE;
}
 

LOCAL agg_Impl make_agg_Impl (sos_Cstring s)
{  if (streql (s, "AGG_HASH"))
      return AGG_HASH;
   if (streql (s, "AGG_LIST"))
      return AGG_LIST;
   if (streql (s, "AGG_AUTOMATIC"))
      return AGG_AUTOMATIC;

   err_assert (FALSE,"sos_Aggregate::make_sos_Impl:invalid value");
   return AGG_AUTOMATIC;
}

// **************************************************************************
void sos_Aggregate::change (sos_Cstring create_parameter, 
                            sos_Cstring value)
// **************************************************************************
{
   sos_String crp_str = sos_String::create (TEMP_CONTAINER, create_parameter);
   sos_String value_str = sos_String::create (TEMP_CONTAINER, value);

      // get the sos_Class_type
   sos_Type          t  = self.sos_Object::type();
   sos_Schema_module sm = sos_Schema_module::retrieve (t.container());
   sos_Type_descr    td = sm.get_type_table()[t.get_name()];
   sos_Class_type    ct = sos_Class_type::make (td);

   /*
     // get the create parameter type
   sos_Param_List cp = ct.get_create_params();
   sos_Param p = sos_Param::make (NO_OBJECT);
   err_assert (VALID(cp),
	       "sos_Aggregate::change:there's no create parameter to change");
   agg_iterate (cp, sos_Param tmp)
      if (tmp.get_name().equal (crp_str))
         p = tmp;
   agg_iterate_end(cp, p);
   err_assert (VALID(p),
               "sos_Aggregate::change:unknown create parameter");
   */
      // get the internal change method
      // void change_<create_parameter> (<Wert>); 
   smg_String mn ("change_");
   mn += create_parameter;
   sos_Method_List ml = ct.get_methods()[mn.make_String (TEMP_CONTAINER)];
   err_assert (VALID(ml),
               "sos_Aggregate::change:unimplemented method");
   sos_Method m = ml.get_nth(1);
   err_assert (VALID(m),
               "sos_Aggregate::change:unimplemented method");

      // make the parameter 
   sos_Type_descr pt = m.get_params().get_nth(1).get_type();
   sos_Object_Array a = sos_Object_Array::create (TEMP_CONTAINER,0,0);
   sos_Object po = sos_Object::make (NO_OBJECT);

   if (pt.make_type().is_derived_from_some (sos_Int_type))
      po = make_sos_Int_object (make_sos_Int (value));
   else
   if (pt.isa (sos_Enum_type_type))
   {  sos_Enum_type et = sos_Enum_type::make (pt);
      sos_String_List literals = et.get_literals();
      sos_String lit = sos_String::make (NO_OBJECT);
      agg_iterate (literals, sos_String tmp)
         if (tmp.equal (value_str))
            lit = tmp;
      agg_iterate_end (literals, lit)
 
      err_assert (VALID(lit),
                  "sos_Aggregate::change:unknown literal");

         // implemented support of change types: sos_Int, sos_Bool, agg_Impl
      if (et.make_type().is_derived_from_some (sos_Bool_type))
         po = make_sos_Bool_object (make_sos_Bool (value));
      else
      if (et.make_type().is_derived_from_some (agg_Impl_type))
         po = make_agg_Impl_object (make_agg_Impl (value));
      else
         err_assert (FALSE,
                     "sos_Aggregate::change:unimplemented enum type");
   }
   else
      err_assert (FALSE, "sos_Aggregate::change:unimplemented value type");
 
   a.set_nth (0, po);
   m.execute (self, a);

   a.destroy(); 
   crp_str.destroy();
   value_str.destroy();
} // ** sos_Aggregate::change **



// **************************************************************************
// Module Association                06/09/90                Juergen Uhl (ju)
//
// **************************************************************************
// implements methods of classes: Association
// **************************************************************************

// **************************************************************************
sos_Bool sos_Object_sos_Object_Association::is_role1 (sos_Object o)
// **************************************************************************
{
   // The function tests if an object is an element of the aggregate.
   // The test may be based on equality or identity, depending on
   // the value of the "role1_based_on_equal" attribute.

   T_PROC ("sos_Object_sos_Object_Association::is_role1");
   TT (agg_H, T_ENTER);

   sos_Bool result = FALSE;
   sos_Object_sos_Object_Association a = self;
   sos_Bool based_on_equal = self.get_role1_based_on_equal();

   agg_iterate_association (a, sos_Object role1, sos_Object role2)
   {  if (agg_same_entity (o, role1, based_on_equal, EQ_STRONG))
      {  result = TRUE;
	 break;
      }
   }
   agg_iterate_association_end (a, role1, role2);

   TT (agg_H, T_LEAVE);
   return result;
} // ** is_role1 **

// **************************************************************************
sos_Bool sos_Object_sos_Object_Association::is_role2 (sos_Object o)
// **************************************************************************
{
   // The function tests if an object is an element of the aggregate.
   // The test may be based on equality or identity, depending on
   // the value of the "role2_based_on_equal" attribute.

   T_PROC ("sos_Object_sos_Object_Association::is_role2");
   TT (agg_H, T_ENTER);

   sos_Bool result = FALSE;
   sos_Object_sos_Object_Association a = self;
   sos_Bool based_on_equal = self.get_role2_based_on_equal();

   agg_iterate_association (a, sos_Object role1, sos_Object role2)
   {  if (agg_same_entity (o, role2, based_on_equal, EQ_STRONG))
      {  result = TRUE;
	 break;
      }
   }
   agg_iterate_association_end (a, role1, role2);

   TT (agg_H, T_LEAVE);

   return result;
} // ** is_role2 **



// **************************************************************************
// Module Collection                30/06/89           Bernhard Schiefer (bs)
//                                                   modified : 24/01/90 (bs)
// **************************************************************************
// implements methods of classes: Collection
// **************************************************************************

// **************************************************************************
sos_Bool sos_Object_Collection::is_element (sos_Object o)
// **************************************************************************
{
   // The function tests if an object is an element of the aggregate.
   // The test may be based on equality or identity, depending on
   // the value of the "based_on_equal" attribute.

   T_PROC ("sos_Object_Collection::is_element");
   TT (agg_H, T_ENTER);

   sos_Bool result = FALSE;
   sos_Object_Collection c = self;
   sos_Bool based_on_equal = self.get_based_on_equal();

   agg_iterate (c, sos_Object elem)
   {  if (agg_same_entity (o, elem, based_on_equal, EQ_STRONG))
      {  result = TRUE;
	 break;
      }
   }
   agg_iterate_end (c, elem);

   TT (agg_H, T_LEAVE);
   return result;
} // ** is_element **
