#ifndef _AGG_EXT_H
#define _AGG_EXT_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

// ****************************** agg_current_cursor ***********************
#define agg_current_cursor()  _agg_cursor
#define agg_current_cursor1() _agg_cursor1
#define agg_current_cursor2() _agg_cursor2

// ****************************** agg_iterate ****************************** 
#define agg_iterate(s, e)\
   {sos_Cursor _agg_cursor = (s).open_cursor();\
    if ((s).is_valid (_agg_cursor)) do{e=(s).get(_agg_cursor);

#define agg_iterate_end(s, e)\
   }while ((s).to_succ(_agg_cursor)); (s).close_cursor(_agg_cursor);}

// ************************** agg_iterate_reverse *************************** 
#define agg_iterate_reverse(s, e)\
   {sos_Cursor _agg_cursor=(s).open_cursor();\
    if ((s).to_last(_agg_cursor)) do{e=(s).get(_agg_cursor);

#define agg_iterate_reverse_end(s, e)\
   }while ((s).to_pred(_agg_cursor)); (s).close_cursor(_agg_cursor);}

// *************************** agg_iterate_double ************************** 
#define agg_iterate_double(s1, e1, s2, e2, comp) \
{ sos_Cursor _agg_cursor1=s1.open_cursor(); \
  sos_Cursor _agg_cursor2=s2.open_cursor(); \
  sos_Bool _agg_valid1, _agg_valid2; \
  for (_agg_valid1=s1.is_valid(_agg_cursor1),_agg_valid2=s2.is_valid(_agg_cursor2); \
       _agg_valid1 && _agg_valid2; \
  _agg_valid1=s1.to_succ(_agg_cursor1),_agg_valid2=s2.to_succ(_agg_cursor2)) \
  { e1 = s1.get(_agg_cursor1); e2 = s2.get(_agg_cursor2);
 
#define agg_iterate_double_end(s1, e1, s2, e2, comp) } \
  comp=(int(_agg_valid1)-int(_agg_valid2)); \
  s1.close_cursor (_agg_cursor1); s2.close_cursor (_agg_cursor2);}

// ************************ agg_iterate_association ************************ 
#define agg_iterate_association(s, e1, e2) \
   {sos_Cursor _agg_cursor=(s).open_cursor();\
    if ((s).is_valid(_agg_cursor))\
       do{e1=(s).get_role1(_agg_cursor);e2=(s).get_role2(_agg_cursor);

#define agg_iterate_association_end(s, e1, e2)\
   }while ((s).to_succ(_agg_cursor)); (s).close_cursor(_agg_cursor);}

// ****************** agg_iterate_association_reverse  ********************* 
#define agg_iterate_association_reverse(s, e1, e2) \
   {sos_Cursor _agg_cursor=(s).open_cursor();\
    if ((s).to_last(_agg_cursor))\
       do{e1=(s).get_role1(_agg_cursor);e2=(s).get_role2(_agg_cursor);

#define agg_iterate_association_reverse_end(s, e1, e2)\
   }while ((s).to_pred(_agg_cursor)); (s).close_cursor(_agg_cursor);}

#endif
