/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STRINGOP
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst.h"              // obst_init
#include "dir_use.h"           // sos_Directory
#include "../UnixFile/UnixFile_use.h" 

/* usage: Trans [new]
The resulting program may be called:
- without parameter
  An existing object of class UnixFile is used again;
  if there does not exist such an object, it is created.
- with parameter "new"
  Existing instances of class UnixFile are removed and a new
  one is created.
  This is necessary, if schema UnixFile has been recompiled, after the
  creation of this instance.
*/

UnixFile create_new_UnixFile (const sos_String &key)
{  
     UnixFile f = UnixFile::create (sos_Container::create(), key);

     if (ROOT_CONTAINER.status() != WRITEABLE)
        ROOT_CONTAINER.open (WRITING, WAITING);

     sos_Directory::root().insert (key, f);

     sos_Container_set modified;
     modified += ROOT_CONTAINER;
     modified += f.container();
     modified.close();  
     return f;
}

void print_status(sos_Container_status stat)
{
  static char* status_words[] = { "READABLE",    "CHECKEDOUT", "WRITEABLE", 
				   "DESTROYED", "UNAVAILABLE" };

  cout << "Status of container : " << status_words[(int)stat] << "\n";
}

int main (int argc, char *argv[])
{  obst_init (argc, argv);

  sos_Directory root_dir = sos_Directory::root();
  sos_String synchro_key = sos_String::create (TEMP_CONTAINER);
  synchro_key.assign_Cstring ("synchro_test");

  // start transaction for initialization
  TRANSACTION.start(LOCKING);

  UnixFile f;
  if (root_dir.is_key (synchro_key))  // object already exists
     if (argc > 1) 
	if (!strcmp (argv[1], "new")) // remove it
        {
           ROOT_CONTAINER.open (WRITING, WAITING);
	   root_dir.remove (synchro_key);
	   f = create_new_UnixFile (synchro_key);
        }
	else
	{  cerr << "*** usage: Trans [new]\n";
	   return 1;
	}
     else                            // use this object again
        f = UnixFile::make (root_dir[synchro_key]);
  else
  {  f = create_new_UnixFile (synchro_key);
  }

  TRANSACTION.commit();
  if (TRANSACTION.prev_transaction() == ABORTED)
  {
     cerr << "*** initialization failed\n";
     return 1;
  }

  while (TRUE)
  {  cout << "\n"
	  << "   b    -> begin transaction\n"
	  << "   e    -> commit transaction\n"
	  << "   a    -> abort transaction\n"
          << "   r    -> read access\n"
	  << "   w    -> write access\n"
	  << "   c    -> close/commit container\n"
	  << "   <CR> -> that's all\n"
	  << "Your choice, please:";
     char inp,newline;
     cin.get (inp);
     if (inp == 'b')
     {  cout << "starting a new transaction ...";cout.flush();
	TRANSACTION.start(LOCKING);
	cout << " done\n";
     }
     else if (inp == 'e')
     {  cout << "committing transaction ...";cout.flush();
	TRANSACTION.commit();
	if (TRANSACTION.prev_transaction() == ABORTED)
	   cout << " commit failed\n";
	 else
	   cout << " committed successfully\n";
     }
     else if (inp == 'a')
     {  cout << "aborting transaction ...";cout.flush();
	TRANSACTION.abort();
	cout << " done\n";
     }
     else if (inp == 'r')
     {  cout << "I try to get read permission...";cout.flush();
        f.container().open (READING, WAITING);
	if (TRANSACTION.act_ta_status() == ABORTED)
	{ // transaction is deadlock victim
	   TRANSACTION.abort();
           cout << "DEADLOCK: Transaction aborted\n";
	}
	else
	{
	   cout << "access granted\n";
	   print_status(f.container().status());
	   cout << "Size of demo file: " << f.get_size() << "\n";
	}
     }
     else if (inp == 'w')
     {  cout << "I try to get write permission...";cout.flush();
	f.container().open (WRITING, WAITING);
	if (TRANSACTION.act_ta_status() == ABORTED)
	{ // transaction is deadlock victim
	   TRANSACTION.abort();
           cout << "DEADLOCK: Transaction aborted\n";
	}
	else
	{
	   cout << "access granted\n";
	   print_status(f.container().status());
	   cout << "Please enter new size of demo file: ";
	   int value; cin  >> value;
	   f.set_size (value);
	}
     }
     else if (inp == 'c')
     {
        f.container().close();
	print_status(f.container().status());
     }
     else
	break; // assume user typed <Return>
     cin.get (newline);
  }
  return 0;
}
