/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST Projekt", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include <stream.h>
#include "obst.h"
#include "TextFile_use.h"
#include "../include/string_utils.h"

int main (int argc, char* argv[])
{  obst_init (argc, argv);
   
   sos_String no_name = sos_String::make (NO_OBJECT);

   TextFile tf_A = TextFile::create (TEMP_CONTAINER, no_name);
   tf_A.set ("text A, ");

   TextFile tf_B = TextFile::create (TEMP_CONTAINER, no_name);
   tf_B.set ("text B ");

   TextFile tf_C = TextFile::create (TEMP_CONTAINER, no_name);
   tf_C.set ("text C ");

   UnixFile f = UnixFile::create (TEMP_CONTAINER, no_name);
   tf_A.append (f); // -> type error

   tf_A.append (tf_B);

   sos_String separator = sos_String::create (TEMP_CONTAINER);
   separator.assign_Cstring ("and ");
   tf_A.append (tf_C, separator);
   
   cout << "tf_A:size     = " << tf_A.get_size() << "\n"
	<< "tf_A:contents = " << tf_A.get_contents() << "\n";

   return 0;
}

