/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include <stream.h>           // cout, cin
#include "obst.h"             // obst_init
#include "dir_use.h"          // sos_Directory
#include "../UnixFile/UnixFile_use.h" 

/* usage: Synchro [new]
The resulting program may be called:
- without parameter
  An existing object of class UnixFile is used again;
  if there does not exist such an object, it is created.
- with parameter "new"
  Existing instances of class UnixFile are removed and a new
  one is created.
  This is necessary, if schema UnixFile has been recompiled, after the
  creation of this instance.
*/

UnixFile create_new_UnixFile (const sos_String &key)
{    
     sos_String n = sos_String::copy (key, sos_Container::create());
     UnixFile   f = UnixFile::create (n.container(), n);

     if (ROOT_CONTAINER.status() != WRITEABLE)
        ROOT_CONTAINER.open (WRITING, WAITING);

     sos_Directory::root().insert (key, f);

     sos_Container_set modified;
     modified += ROOT_CONTAINER;
     modified += f.container();
     modified.close();  
     return f;
}

void print_status(sos_Container_status stat)
{
  static char* status_words[] = { "READABLE",    "CHECKEDOUT", "WRITEABLE", 
				   "DESTROYED", "UNAVAILABLE" };
  cout << "Status of container : " << status_words[(int)stat] << "\n";
}

int main (int argc, char *argv[])
{  obst_init (argc, argv);

  sos_Directory root_dir = sos_Directory::root();
  sos_String synchro_key = sos_String::create (TEMP_CONTAINER);
  synchro_key.assign_Cstring ("synchro_test");

  UnixFile f;
  if (root_dir.is_key (synchro_key))  // object already exists
     if (argc > 1) 
	if (!strcmp (argv[1], "new")) // remove it
        {
           ROOT_CONTAINER.open (WRITING, WAITING);
	   root_dir.remove (synchro_key);
	   f = create_new_UnixFile (synchro_key);
        }
	else
	{  cerr << "*** usage: Synchro [new]\n";
	   return 1;
	}
     else                            // use this object again
        f = UnixFile::make (root_dir[synchro_key]);
  else
  {  f = create_new_UnixFile (synchro_key);
  }

  while (TRUE)
  {  cout << "\n"
          << "   r    -> read access\n"
	  << "   w    -> write access\n"
	  << "   c    -> close/commit container\n"
	  << "   <CR> -> that's all\n"
	  << "Your choice, please:";
     char inp,newline;
     cin.get (inp);
     if (inp == 'r')
     {  cout << "I try to get read permission...";cout.flush();
	f.container().open (READING, WAITING);  
	cout << "access granted\n";
	print_status(f.container().status());
	cout << "Size of demo file: " << f.get_size() << "\n";
     }
     else if (inp == 'w')
     {  cout << "I try to get write permission...";cout.flush();
	f.container().open (WRITING, WAITING);
	cout << "access granted\n";
	print_status(f.container().status());
	cout << "Please enter new size of demo file: ";
	int value; cin  >> value;
	f.set_size (value);
     }
     else if (inp == 'c')
     {
        f.container().close();
	print_status(f.container().status());
     }
     else
	break; // assume user typed <Return>
     cin.get (newline);
  }
  return 0;
}
