/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst.h"
#include "Aggregates_use.h"
#include "../include/string_utils.h"

void whats_in (sos_String_Set set)
{  cout << "{ ";

   agg_iterate (set, sos_String s)
      cout << s << " ";
   agg_iterate_end (set, s);

   cout << "}\n";
}

int main (int argc, char* argv[])
{  obst_init (argc, argv);

   sos_String_Set set = sos_String_Set::create (TEMP_CONTAINER, TRUE, TRUE);
   set.insert (tmp_str ("s1"));
   set.insert (tmp_str ("s1"));
   set.insert (tmp_str ("s2"));

   cout << "Set #1 (based_on_equal == TRUE): "; whats_in (set);

   set = sos_String_Set::create (TEMP_CONTAINER, TRUE, FALSE);
   set.insert (tmp_str ("s1"));
   set.insert (tmp_str ("s1"));
   set.insert (tmp_str ("s2"));

   cout << "\nSet #2 (based_on_equal == FALSE): "; whats_in (set);

   sos_String to_be_removed = tmp_str ("s1");

   sos_Cursor c = set.open_cursor();
   while (set.is_valid (c))
   {  if (set.get (c).equal (to_be_removed))
	 set.remove_at (c);
      else
	 set.to_succ (c);
   }

   cout << "\nSet #2 (after removing \"s1\"): "; whats_in (set);

   return 0;
}
