/* ttywrite.c - ttywrite, writcopy */

#include <conf.h>
#include <kernel.h>
#include <slu.h>			/* before tty.h */
#include <tty.h>
#include <io.h>

/*------------------------------------------------------------------------
 *  ttywrite - write one or more characters to a tty device
 *------------------------------------------------------------------------
 */
ttywrite(devptr, buff, count)
struct	devsw	*devptr;
register char	*buff;
register int	count;
{
	register struct tty *ttyp;
	int avail;
	ps_t	ps;

	if (count < 0)
		return(SYSERR);
	if (count == 0)
		return(OK);

	disable(ps);
	ttyp = &tty[devptr->dvminor];
	if ( (avail=scount(ttyp->osem)) >= count) {
		writcopy(buff, ttyp, count);
#ifdef DL11
		(ttyp->ioaddr)->ctstat = SLUENABLE;
#endif DL11
#ifdef DUART681
		DUART_ENABLE((struct csr *)ttyp->ioaddr,ttyp);
#endif DUART681
	}
	else {
		if (avail > 0) {
			writcopy(buff, ttyp, avail);
			buff += avail;
			count -= avail;
		}
		for (; count>0 ; count--)
			ttyputc(devptr, *buff++);
	}
	restore(ps);
	return(OK);
}

/*------------------------------------------------------------------------
 *  writcopy - high-speed copy from user's buffer into system buffer
 *------------------------------------------------------------------------
 */
LOCAL writcopy(buff, ttyp, count)
register char *buff;
struct	tty *ttyp;
int	count;
{
	register char	*qhead, *qend, *uend;

	qhead = &ttyp->obuff[ttyp->ohead];
	qend  = &ttyp->obuff[OBUFLEN];
	uend  = buff + count;
	while (buff < uend) {
		*qhead++ = *buff++;
		if ( qhead >= qend )
			qhead = ttyp->obuff;
	}
	ttyp->ohead = qhead - ttyp->obuff;
	sreset(ttyp->osem, scount(ttyp->osem)-count);
}
