/* prdump.c - prdump, prdumph, prdumpa */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <q.h>

/*------------------------------------------------------------------------
 *  prdump  --  dump the active process table entries
 *------------------------------------------------------------------------
 */
prdump()
{
	pxdump(0);
}

/*------------------------------------------------------------------------
 *  prdumph  --  dump the active process table entries and halt
 *------------------------------------------------------------------------
 */
prdumph()
{
	pxdump(0);
	kprintf("\nDump complete -- type P to continue\n");
	while(0);
}

/*------------------------------------------------------------------------
 *  prdumpa  --  dump the process table entries printing all entries
 *------------------------------------------------------------------------
 */
prdumpa()
{
	pxdump(1);
}

static char *regnam[] = {
    "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
    "a0", "a1", "a2", "a3", "a4", "a5", "a6", "ssp", "ps", "pc", "usp" };

static char *statename[] = {
    "#0",
    "CURR",
    "FREE",
    "READY",
    "RECV",
    "SLEEP",
    "SUSP",
    "WAIT" };


static pxdump(all)
int all;
{
        int i, j, ctr;
        ps_t	ps;
        struct pentry *pptr;
        disable(ps);
        kprintf("\nProctab at loc %#x\ncurrpid is %d\n", proctab, currpid);
	for ( i=0 ; i<NPROC ; i++ ) {
            pptr = &proctab[i];
	    if (all!=0 || pptr->pstate!=PRFREE) {
                kprintf("\nProcess %d: ",i);
                kprintf("state=%s,name=",statename[pptr->pstate]);
                for ( j=0 ; j<PNMLEN ; j++ ) {
                        if (pptr->pname[j]=='\0') break;
                        kprintf("%c",pptr->pname[j]);
                }
                kprintf(",prio=%d,", pptr->pprio );
		if( pptr->pstate == PRWAIT )
		    kprintf("sem=%d,", pptr->psem );
		kprintf("stk:base=%x,limit=%x\n", pptr->pbase,pptr->plimit);
                for ( j=0 ; j<8 ; j++ )
                        kprintf("(%s)%x ",regnam[j],pptr->pregs[j]);
                kprintf("\n");
                for ( j=8 ; j<15 ; j++ )
                        kprintf("(%s)%x ",regnam[j],pptr->pregs[j]);
                kprintf("\n");
                for ( j=15 ; j<PNREGS ; j++ )
                        kprintf("(%s)%x ",regnam[j],pptr->pregs[j]);
                kprintf("\n");
	    }
	}
	kprintf("rdyhead:");
	ctr = NPROC;
        for ( i = q[rdyhead].qnext; i < NPROC ; i=q[i].qnext) {
                kprintf("%d ",i);
		if (q[i].qnext == i) {
			kprintf("\nLOOP in ready list");
			break;
		}
		if (--ctr < 0) {
			kprintf("\nCorrupt ready list -- too long");
			break;
		}
	}
        kprintf("\n");
        restore(ps);
}
