/* kprintf.c - kprintf, kputc, savestate, rststate */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <slu.h>
#include <tty.h>

/*#define SLOWDOWN 1000			/*  */
/*------------------------------------------------------------------------
 *  kprintf  --  kernel printf: formatted, unbuffered output to CONSOLE
 *------------------------------------------------------------------------
 */
#ifdef CONSOLE

#ifdef DL11
#define SAVEDXMIT 01
#define SAVEDRECV 02
#endif

# if 0
/*# define KPUTC sa_putc/**/
# else
# define KPUTC kputc
int     KPUTC();
# endif

LOCAL int savestate(), rststate();

kprintf(fmt, args)		/* Derived by Bob Brown, Purdue U.	*/
        char *fmt;
{
	ps_t	ps;
	int	saved;

	disable(ps);
	saved = savestate();
        _doprnt(fmt, &args, KPUTC, CONSOLE );
	rststate( saved );
	restore(ps);
        return(OK);
}

/*------------------------------------------------------------------------
 *  kputc  --  write a character on the console using polled I/O
 *------------------------------------------------------------------------
 */
kputc(device ,c)
    int	device;
    register char c;			/* character to print from _doprnt */
{
    volatile struct csr *csrptr;
    register int i;

    if ( c == 0 )
	return;
    if ( c == NEWLINE )
	kputc( device, RETURN );

    csrptr = (struct csr *)devtab[device].dvcsr; /* dev. address */

#ifdef DL11
    while ( (csrptr->ctstat & SLUREADY) == 0 ) ; /* poll for idle*/
    csrptr->ctbuf = c;
#endif DL11
#ifdef DUART681
    while ( (csrptr->DU_SRA & DU_SR_TXREADY) == 0 ) ; /* poll for idle */
    csrptr->DU_TBA = c;			/* send out on A */
#endif DUART681
#ifdef SLOWDOWN
    for( i = 0; i < SLOWDOWN; i++ )
	;
#endif SLOWDOWN
#ifdef DL11
    while ( (csrptr->ctstat & SLUREADY) == 0 ) ; /* poll for idle*/
#endif DL11
#ifdef DUART681
    while ( (csrptr->DU_SRA & DU_SR_TXREADY) == 0 ) ; /* poll for idle */
#endif DUART681
}

/*------------------------------------------------------------------------
 *  savestate  --  save the console control and status register
 *------------------------------------------------------------------------
 */
LOCAL	savestate()
{
	volatile register struct csr *cp;
	int state;

#ifdef DL11
	state = 0;
	cp =(struct csr *)devtab[CONSOLE].dvcsr;
	if( cp->crstat & SLUENABLE )
	    state |= SAVEDRECV;
	cp->crstat = SLUDISABLE;
	if( cp->ctstat & SLUENABLE )
	    state |= SAVEDXMIT;
	cp->ctstat = SLUDISABLE;
#endif
#ifdef DUART681
	register struct duart681 *dp;

	cp = (struct csr *)devtab[CONSOLE].dvcsr; /* get console duart csr */
	dp = ((struct tty *)(devtab[CONSOLE].dvioblk))->dptr; /* duart struct */
	state = dp->duart_imr;
	cp->DU_IMR = dp->duart_imr = 0;
#endif
	return( state );
}

/*------------------------------------------------------------------------
 *  rststate  --  restore the console output control and status register
 *------------------------------------------------------------------------
 */
LOCAL	rststate( old )
int old;
{
#ifdef DL11
	volatile register struct csr *cp;

	cp = (struct csr *) devtab[CONSOLE].dvcsr;
	if( old & SAVEDRECV )
	    cp->crstat = SLUENABLE;
	if( old & SAVEDXMIT )
	    cp->ctstat = SLUENABLE;
#endif
#ifdef DUART681
	volatile register struct csr *cp;
	register struct duart681 *dp;

	cp = (struct csr *)devtab[CONSOLE].dvcsr;
	dp = ((struct tty *)(devtab[CONSOLE].dvioblk))->dptr; /* duart struct */
	cp->DU_IMR = dp->duart_imr = old;
#endif
}

#ifdef DUART681
static struct tty xtty;
static struct duart681 duart;

konini() {				/* reset console for kprintf */
    volatile register struct csr *cptr;
    register int i;

    cptr = (struct csr *)devtab[CONSOLE].dvcsr;
    cptr->DU_CRA  = DU_CR_MSC_RMR | DU_CR_XMT_DIS | DU_CR_RCV_DIS;
					/* reset mr pointer to mr1 */
					/* disable xmit and recv */

    cptr->DU_ACR = DU_ACR_SET2;		/* baud set 2 */
    cptr->DU_CSRA = 0xbb;		/* rx, tx at 9600 baud */
    cptr->DU_MR1A = 0x13;		/* no rx rts, no rx irq */
					/* char er, none, even, 8 */
    cptr->DU_MR2A = 0x0f;		/* normal, no tx rts */
					/* no tx cts, 2 stop */
    cptr->DU_CRA = DU_CR_XMT_ENA | DU_CR_RCV_ENA;

    /* UGH... */
    devtab[CONSOLE].dvioblk = (char *) &xtty;
    xtty.dptr = &duart;
    duart.duart_imr = 0;
    /* end UGH */
    
#ifdef SLOWDOWN
    for( i = 0; i < SLOWDOWN; i++ )
	;
#endif SLOWDOWN
}
# endif DUART681

#endif CONSOLE
