/* initialize.c - nulluser, sysinit */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <sem.h>
#include <mem.h>
#include <slu.h>			/* budd */
#include <tty.h>
#include <q.h>
#include <io.h>
#include <disk.h>
#include <magic.h>			/* budd */

extern	int	main();			/* address of user's main prog	*/

/* Declarations of major kernel variables */

struct	pentry	proctab[NPROC]; /* process table			*/
int	nextproc;		/* next process slot to use in create	*/
struct	sentry	semaph[NSEM];	/* semaphore table			*/
int	nextsem;		/* next semaphore slot to use in screate*/
struct	qent	q[NQENT];	/* q table (see queue.c)		*/
int	nextqueue;		/* next slot in q structure to use	*/
int	*maxaddr;		/* max memory address (set by sizmem)	*/
struct	mblock	memlist;	/* list of free memory blocks		*/

#ifdef	Ntty
struct  tty     tty[Ntty];	/* SLU buffers and mode control		*/

#ifdef	DUART681
struct	duart681 duart681[(Ntty+1)/2];
#endif	DUART681

#endif	Ntty

#ifdef MC68K
long	vectab[ 256 ];			/* vbr points here */
#endif MC68K

#ifdef NS32K
int (*vectab)[ 256 ];
#endif

/* active system status */

int	numproc;		/* number of live user processes	*/
int	currpid;		/* id of currently running process	*/
int	reboot = 0;		/* non-zero after first boot		*/

/* real-time clock variables and sleeping process queue pointers	*/

#ifdef	RTCLOCK
int	count6;			/* counts in 60ths of a second 6-0	*/
int     defclk;			/* non-zero, then deferring clock count */
int     clkdiff;		/* deferred clock ticks			*/
int     slnempty;		/* FALSE if the sleep queue is empty	*/
int     *sltop;			/* address of key part of top entry in	*/
				/* the sleep queue if slnonempty==TRUE	*/
int     clockq;			/* head of queue of sleeping processes  */
int	preempt;		/* preemption counter.	Current process */
				/* is preempted when it reaches zero;	*/
				/* set in resched; counts in ticks	*/
int	clkruns;		/* set TRUE iff clock exists by setclkr	*/
#else
int	clkruns = FALSE;	/* no clock configured; be sure sleep	*/
#endif	RTCLOCK			/*   doesn't wait forever		*/
int	rdyhead,rdytail;	/* head/tail of ready list (q indexes)	*/
int	initproc;		/* budd -- pid of initial process	*/

/************************************************************************/
/***				NOTE:				      ***/
/***								      ***/
/***   This is where the system begins after the C environment has    ***/
/***   been established.  Interrupts are initially DISABLED, and      ***/
/***   must eventually be enabled explicitly.  This routine turns     ***/
/***   itself into the null process after initialization.  Because    ***/
/***   the null process must always remain ready to run, it cannot    ***/
/***   execute code that might cause it to be suspended, wait for a   ***/
/***   semaphore, or put to sleep, or exit.  In particular, it must   ***/
/***   not do I/O unless it uses kprintf for polled output.           ***/
/***								      ***/
/************************************************************************/

/*------------------------------------------------------------------------
 *  nulluser  -- initialize system and become the null process (id==0)
 *------------------------------------------------------------------------
 */

nulluser() {				/* babysit CPU when no one home */
	ps_t	ps;
	extern char verstr[];

	konini();			/* reset console for kprintf */
	kprintf("\nXinu Version %s %s", VERSION, verstr);
	if (reboot++ > 0 )
	    kprintf("    (reboot %d)\n", reboot);
	sysinit();			/* initialize all of Xinu */
	kprintf("%u real mem\n",(Word)maxaddr+(Word)sizeof(Word));
	kprintf("%u avail mem\n",
		(Word)maxaddr-(Word)(&end)+(Word)sizeof(int));
	kprintf("clock %sabled\n\n", clkruns==1?"en":"dis");
	enable();			/* enable interrupts */

	/* start a process executing the user's main program */

	resume( initproc = create(main,INITSTK,INITPRIO,INITNAME,1,0)	);
	while (TRUE) {			/* run forever without actually */
		pause();		/*  executing instructions	*/
/*	        resched();		/*  */
/*		stackcheck("null");	/*  */
	}
}

/*------------------------------------------------------------------------
 *  sysinit  --  initialize all Xinu data structures and devices
 *------------------------------------------------------------------------
 */
LOCAL	sysinit()
{
	int	i,j;
	struct	pentry	*pptr;
	struct	sentry	*sptr;
	struct	mblock	*mptr;

	numproc = 0;			/* initialize system variables */
	nextproc = NPROC-1;
	nextsem = NSEM-1;
	nextqueue = NPROC;		/* q[0..NPROC-1] are processes */

	memlist.mnext = mptr =		/* initialize free memory list */
	  (struct mblock *) roundew(&end);
	mptr->mnext = (struct mblock *)NULL;
	mptr->mlen = (Word) truncew( (Word)maxaddr-NULLSTK-(Word)&end );

	for (i=0 ; i<NPROC ; i++)	/* initialize process table */
		proctab[i].pstate = PRFREE;
	kprintf("%d processes\n", NPROC );

	pptr = &proctab[NULLPROC];	/* initialize null process entry */
	pptr->pstate = PRCURR;
	for (j=0; j<7; j++)
		pptr->pname[j] = "prnull"[j];
	pptr->plimit = ( (Word)maxaddr ) - NULLSTK;
	pptr->pbase = (Word)maxaddr;
	*(int *)maxaddr = MAGIC;	/* budd */
	pptr->pprio = 0;		/* budd */
	pptr->paddr = (Word)nulluser;
	pptr->pargs = 0;

	currpid = NULLPROC;

	for (i=0 ; i<NSEM ; i++) {	/* initialize semaphores */
		(sptr = &semaph[i])->sstate = SFREE;
		sptr->sqtail = 1 + (sptr->sqhead = newqueue());
	}
	kprintf("%d semaphores\n", NSEM );

	rdytail = 1 + (rdyhead=newqueue());/* initialize ready list */

#ifdef	MEMMARK
	_mkinit();			/* initialize memory marking */

#endif
#ifdef	RTCLOCK
	clkinit();			/* initialize r.t.clock	*/
#endif
#ifdef	Ndsk
	dskdbp= mkpool(DBUFSIZ,NDBUFF);	/* initialize disk buffers */
	dskrbp= mkpool(DREQSIZ,NDREQ);
#endif
#ifdef NDEVS
	for ( i=0 ; i<NDEVS ; i++ ) {	/* initialize devices */
	    kprintf("dev %d: ", i );
	    init(i);
	}
#endif
#ifdef	NNETS
	netinit();			/* initialize networks */
#endif
	return(OK);
}
