;* ctxsw.s - ctxsw

;*----------------------------------------------------------------------------
;* ctxsw  --	actually perform context switch, saving and loading registers
;*		This routine is executed in kernel mode.
;*
;*		Upon entry, r0-r7, the ssp, the psr, and the pc are
;*		saved.  The usp is ignored.
;*
;*		Upon exit, all registers saved are restored, and the value
;*		of the supervisor stack pointer is copied into the user 
;*		stack pointer.
;*----------------------------------------------------------------------------


	.text

; ctxsw( &old, &new )

; +8	new
; +4	old
; +0	pc

_ctxsw::
	movd	r0,0(4(sp))		; stow r0 [0]
	movd	4(sp),r0		; point r0 at old block
;;;;;;;;;;;;;;;;
;; save gpr's
;; frob sp so we can use "save" (must shut off interrupts first!)???
	movd	r1,4(r0)		; [1]
	movd	r2,8(r0)		; [2]
	movd	r3,12(r0)		; [3]
	movd	r4,16(r0)		; [4]
	movd	r5,20(r0)		; [5]
	movd	r6,24(r0)		; [6]
	movd	r7,28(r0)		; [7]
	sprd	sp,32(r0)		; [8]  sys sp
	movd	0(sp),36(r0)		; [9]  old pc
	sprw	psr,40(r0)		; [10] psr
	sprd	fp, 44(r0)		; [11] frame
	sprd	usp,48(r0)		; [12] user sp
	sprd	sb, 52(r0)		; [13] static base
;;;;;;;;;;;;;;;;
;; fp regs?? mod??

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; load up new process
	movd	8(sp),r0		; get new block
;;;;;;;;;;;;;;;;
;; load general purpose registers
	movd	4(r0),r1
	movd	8(r0),r2
	movd	12(r0),r3
	movd	16(r0),r4
	movd	20(r0),r5
	movd	24(r0),r6
	movd	28(r0),r7
	lprd	sp, 32(r0)		; sys sp
	movd	36(r0),tos		; push pc on stack
	lprw	psr,40(r0)		; psr
	lprd	fp, 44(r0)		; frame
	lprd	usp,48(r0)		; load usp too!? (w/ sys sp value)
	lprd	sb, 52(r0)		; static base
	movd	0(r0),r0		; restore r0
;;;;;;;;;;;;;;;;
;; fp regs?? sb?? mod??

	ret	0
